<?php

namespace App\Models;

use DB;
use DateTime;
use App\Traits\Uuids;
use Illuminate\Support\Carbon;
use App\Traits\ClearsHomePageCache;
use App\Traits\HasActivityLogging;
use Illuminate\Support\Facades\Date;
use Illuminate\Support\Facades\Hash;
use Illuminate\Database\Eloquent\Model;
use Spatie\Activitylog\Traits\LogsActivity;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class TrendingFlight extends Model
{
    use HasFactory, LogsActivity, Uuids,ClearsHomePageCache,HasActivityLogging;

    protected $table = 'trending_flights';

    protected $guarded = [];

    protected static $logName = 'trending_flights';
    protected $fillable = [
        'from_airport_id',
        'from_airport_name',
        'from_airport',
        'from_airport_city_en',
        'from_airport_city_ar',
        'to_airport_id',
        'to_airport_name',
        'to_airport',
        'to_airport_city_en',
        'to_airport_city_ar',
        'from_date',
        'to_date',
        'trip_type',
        'trip_class',
        'adult',
        'child',
        'infant',
        'status'
    ];

    /**
     * ger list or single or all records to display
     */
    public static function getTrendingFlights($option = array())
    {

        $return = array(
            'status' => 0,
            'message' => 'something went wrong',
            'data' => []
        );


        $data = array(
            'id' => '',
            'order_by' => 'created_at',
            'sorting' => 'desc',
            'status' => '',
            'where' => array(),
            'orWhere' => array(),
            'onlyData' => false
        );

        $config = array_merge($data, $option);
        $result = [];
        if ($config['id'] != '') {
            try {
                $query = TrendingFlight::query();
                $query->select('trending_flights.*');
                $query->where('trending_flights.id', $config['id']);
                $result = $query->first();
            } catch (\Exception $e) {
                $return['message'] = $e->getMessage();
            }
        } else {
            try {
                $query = TrendingFlight::query();
                $query->select('trending_flights.*');
                $query->orderBy($config['order_by'], $config['sorting']);

                if (!empty($config['where'])) {
                    foreach ($config['where'] as $where) {
                        $query->where('trending_flights.' . $where[0], $where[1], $where[2]);
                    }
                }

                if (!empty($config['orWhere'])) {
                    foreach ($config['orWhere'] as $orWhere) {
                        $query->orWhere($orWhere[0], $orWhere[1], $orWhere[2]);
                    }
                }
                if ($config['onlyData']) {
                    $result = $query->get();
                } elseif (isset($config['per_page'])) {
                    $result = $query->paginate($config['per_page']);
                    $result->setPath('?per_page=' . $config['per_page']);
                } else {
                    $result = $query->get();
                }
            } catch (\Exception $e) {
                if ($config['onlyData']) {
                    return [];
                } else {
                    $return['message'] = $e->getMessage();
                }
            }
        }
        if (!empty($result)) {
            if ($config['onlyData']) {
                return $result->toArray();
            } else {
                $return['status'] = 1;
                $return['message'] = 'Trending Flight list successfully';
                $return['data'] = $result;
                return $return;
            }
        } else {
            return $return;
        }
    }

    public static function createTrendingFlight($requestData)
    {

        $return = array(
            'status' => 0,
            'message' => 'something went wrong',
            'data' => []
        );

        $trendingFlightArrayData = array(
            'from_airport_id' => $requestData['from_airport_id'],
            'from_airport_name' => $requestData['from_airport_name'],
            'from_airport' => $requestData['from_airport'],
            'from_airport_city_en' => $requestData['from_airport_city_en'],
            'from_airport_city_ar' => $requestData['from_airport_city_ar'],
            'to_airport_id' => $requestData['to_airport_id'],
            'to_airport_name' => $requestData['to_airport_name'],
            'to_airport' => $requestData['to_airport'],
            'to_airport_city_en' => $requestData['to_airport_city_en'],
            'to_airport_city_ar' => $requestData['to_airport_city_ar'],
            'from_date' => $requestData['from_date'],
            'to_date' => $requestData['to_date'],
            'trip_type' => $requestData['trip_type'],
            'trip_class' => $requestData['trip_class'],
            'adult' => $requestData['adult'],
            'child' => $requestData['child'],
            'infant' => $requestData['infant'],
            'status' => $requestData['status'],
        );
        try {
            DB::beginTransaction();
            $trendingFlightData = TrendingFlight::create($trendingFlightArrayData);
            DB::commit();
            if ($trendingFlightData) {
                $return['status'] = 1;
                $return['message'] = 'Trending Flight have created successfully';
                $return['data'] = $trendingFlightData;
            }
        } catch (\Exception $e) {
            $return['message'] = 'Error during save TrendingFlights : ' . $e->getMessage();
        }

        return $return;
    }
    public static function updateTrendingFlight($requestData)
    {

        $return = array(
            'status' => 0,
            'message' => 'something went wrong',
            'data' => []
        );
        try {
            @$trendingFlightTypeDetails = array(
                'id' => $requestData['id'],
                'from_airport_id' => $requestData['from_airport_id'],
                'from_airport_name' => $requestData['from_airport_name'],
                'from_airport' => $requestData['from_airport'],
                'from_airport_city_en' => $requestData['from_airport_city_en'],
                'from_airport_city_ar' => $requestData['from_airport_city_ar'],
                'to_airport_id' => $requestData['to_airport_id'],
                'to_airport_name' => $requestData['to_airport_name'],
                'to_airport' => $requestData['to_airport'],
                'to_airport_city_en' => $requestData['to_airport_city_en'],
                'to_airport_city_ar' => $requestData['to_airport_city_ar'],
                'from_date' => $requestData['from_date'],
                'to_date' => $requestData['to_date'],
                'trip_type' => $requestData['trip_type'],
                'trip_class' => $requestData['trip_class'],
                'adult' => $requestData['adult'],
                'child' => $requestData['child'],
                'infant' => $requestData['infant'],
                'status' => $requestData['status'],
            );
            try {

                DB::beginTransaction();
                $matchTrendingFlightType = ['id' => $trendingFlightTypeDetails['id']];
                $TrendingFlightType = TrendingFlight::updateOrCreate($matchTrendingFlightType, $trendingFlightTypeDetails);
                DB::commit();
                if ($TrendingFlightType) {
                    $return['status'] = 1;
                    $return['message'] = 'Trending Flight have updated successfully';
                    $return['data'] = $TrendingFlightType;
                }
            } catch (\Exception $e) {
                $return['message'] = 'Error during update TrendingFlights : ' . $e->getMessage();
            }
        } catch (\Exception $e) {
            $return['message'] = 'Something went wrong : ' . $e->getMessage();
        }
        return $return;
    }

    public static function deleteTrendingFlight($trendingFlightId)
    {

        $trendingFlightDetails = TrendingFlight::where('id', $trendingFlightId)->first()->toArray();
        if ($trendingFlightDetails) {
            TrendingFlight::where('id', $trendingFlightId)->delete();

            $return['status'] = 1;
            $return['message'] = 'Trending Flight have deleted successfully';
        } else {
            $return['status'] = 0;
            $return['message'] = 'Unable to delete neg fare. Please try again.';
        }

        return $return;
    }
}
