<?php

namespace App\Models;

use DB;
use DateTime;
use App\Traits\Uuids;
use Illuminate\Support\Carbon;
use App\Traits\ClearsHomePageCache;
use App\Traits\HasActivityLogging;
use Illuminate\Support\Facades\Date;
use Illuminate\Support\Facades\Hash;
use Illuminate\Database\Eloquent\Model;
use Spatie\Activitylog\Traits\LogsActivity;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class TrendingHotel extends Model
{
    use HasFactory, LogsActivity, Uuids, ClearsHomePageCache,HasActivityLogging;

    protected $table = 'trending_hotels';

    protected $guarded = [];

    protected static $logName = 'trending_hotels';
    protected $fillable = ['city_en', 'city_ar', 'longitude', 'latitude', 'from_date', 'to_date', 'guests', 'no_of_nights', 'status'];

    /**
     * ger list or single or all records to display
     */
    public static function getTrendingHotels($option = array())
    {

        $return = array(
            'status' => 0,
            'message' => 'something went wrong',
            'data' => []
        );


        $data = array(
            'id' => '',
            'order_by' => 'created_at',
            'sorting' => 'desc',
            'status' => '',
            'where' => array(),
            'orWhere' => array(),
            'onlyData' => false
        );

        $config = array_merge($data, $option);
        $result = [];
        if ($config['id'] != '') {
            try {
                $query = TrendingHotel::query();
                $query->select('trending_hotels.*');
                $query->where('trending_hotels.id', $config['id']);
                $result = $query->first();
            } catch (\Exception $e) {
                $return['message'] = $e->getMessage();
            }
        } else {
            try {
                $query = TrendingHotel::query();
                $query->select('trending_hotels.*');
                $query->orderBy($config['order_by'], $config['sorting']);

                if (!empty($config['where'])) {
                    foreach ($config['where'] as $where) {
                        $query->where('trending_hotels.' . $where[0], $where[1], $where[2]);
                    }
                }

                if (!empty($config['orWhere'])) {
                    foreach ($config['orWhere'] as $orWhere) {
                        $query->orWhere($orWhere[0], $orWhere[1], $orWhere[2]);
                    }
                }
                if ($config['onlyData']) {
                    $result = $query->get();
                } elseif (isset($config['per_page'])) {
                    $result = $query->paginate($config['per_page']);
                    $result->setPath('?per_page=' . $config['per_page']);
                } else {
                    $result = $query->get();
                }
            } catch (\Exception $e) {
                if ($config['onlyData']) {
                    return [];
                } else {
                    $return['message'] = $e->getMessage();
                }
            }
        }
        if (!empty($result)) {
            if ($config['onlyData']) {
                return $result->toArray();
            } else {
                $return['status'] = 1;
                $return['message'] = 'Trending Hotel list successfully';
                $return['data'] = $result;
                return $return;
            }
        } else {
            return $return;
        }
    }

    public static function createTrendingHotel($requestData)
    {

        $return = array(
            'status' => 0,
            'message' => 'something went wrong',
            'data' => []
        );

        $trendingHotelArrayData = array(
            'city_ar' => $requestData['city_ar'],
            'city_en' => $requestData['city_en'],
            'longitude' => $requestData['longitude'],
            'latitude' => $requestData['latitude'],
            'from_date' => $requestData['from_date'],
            'to_date' => $requestData['to_date'],
            'guests' => $requestData['guests'],
            'no_of_nights' => $requestData['no_of_nights'],
            'status' => $requestData['status'],
        );
        try {
            DB::beginTransaction();
            $trendingHotelData = TrendingHotel::create($trendingHotelArrayData);
            DB::commit();
            if ($trendingHotelData) {
                $return['status'] = 1;
                $return['message'] = 'Trending Hotel have created successfully';
                $return['data'] = $trendingHotelData;
            }
        } catch (\Exception $e) {
            $return['message'] = 'Error during save TrendingHotels : ' . $e->getMessage();
        }

        return $return;
    }
    public static function updateTrendingHotel($requestData)
    {

        $return = array(
            'status' => 0,
            'message' => 'something went wrong',
            'data' => []
        );
        try {
            @$trendingHotelTypeDetails = array(
                'id' => $requestData['id'],
                'city_ar' => $requestData['city_ar'],
                'city_en' => $requestData['city_en'],
                'longitude' => $requestData['longitude'],
                'latitude' => $requestData['latitude'],
                'from_date' => $requestData['from_date'],
                'to_date' => $requestData['to_date'],
                'guests' => $requestData['guests'],
                'no_of_nights' => $requestData['no_of_nights'],
                'status' => $requestData['status'],
            );
            try {

                DB::beginTransaction();
                $matchTrendingHotelType = ['id' => $trendingHotelTypeDetails['id']];
                $TrendingHotelType = TrendingHotel::updateOrCreate($matchTrendingHotelType, $trendingHotelTypeDetails);
                DB::commit();
                if ($TrendingHotelType) {
                    $return['status'] = 1;
                    $return['message'] = 'Trending Hotel have updated successfully';
                    $return['data'] = $TrendingHotelType;
                }
            } catch (\Exception $e) {
                $return['message'] = 'Error during update TrendingHotels : ' . $e->getMessage();
            }
        } catch (\Exception $e) {
            $return['message'] = 'Something went wrong : ' . $e->getMessage();
        }
        return $return;
    }

    public static function deleteTrendingHotel($trendingHotelId)
    {

        $trendingHotelDetails = TrendingHotel::where('id', $trendingHotelId)->first()->toArray();
        if ($trendingHotelDetails) {
            TrendingHotel::where('id', $trendingHotelId)->delete();

            $return['status'] = 1;
            $return['message'] = 'Trending Hotel have deleted successfully';
        } else {
            $return['status'] = 0;
            $return['message'] = 'Unable to delete neg fare. Please try again.';
        }

        return $return;
    }
}
