<?php

namespace App\Models;

use Illuminate\Support\Facades\DB;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Wallet extends Model
{
    use HasFactory,SoftDeletes;

    public function customer()
    {
        return $this->belongsTo(Customer::class, 'customer_id');
    }

    // Define the getFilteredWallets method
    public static function getFilteredWallets($filter)
    {
        $query = self::with('customer');

        if (isset($filter['status']) && $filter['status'] !== '') {
            $query->where('status', '=', $filter['status']);
        }

        if (isset($filter['email']) && $filter['email'] !== '') {
            $query->whereHas('customer', function ($query) use ($filter) {
                $query->where('email', 'like', '%' . $filter['email'] . '%');
            });
        }

        if (isset($filter['order_by']) && isset($filter['sorting'])) {
            $query->orderBy($filter['order_by'], $filter['sorting']);
        }

        return $query->paginate($filter['per_page']);
    }

    public static function getCustomerWalletList($customerId)
    {
        $walletList = Wallet::where('customer_id', $customerId)
            ->where('status', 'active')
            ->orderBy('updated_at', 'desc')
            ->get();
        return $walletList;
    }

    public static function getTotalWalletAmount($customerId)
    {
        $date = date('Y-m-d');
        $totalAmount = Wallet::where('customer_id', $customerId)
            ->where('status', 'active')
            ->where('type', 'credit')
            ->where(function ($q) {
                $q->where('wallet_used_status', '!=', 'used')
                    ->orWhereNull('wallet_used_status');
            })

            ->where('expiry_date', '>=', $date)
            ->sum('balance');
        return $totalAmount;
    }
}
