<?php

namespace App\Observers;

use App\Models\Customer;
use App\Models\CustomerLog;
use Illuminate\Support\Facades\Auth;

class CustomerObserver
{
    /**
     * Handle the Customer "created" event.
     */
    public function created(Customer $customer): void
    {
       try {
            CustomerLog::create([
                'customer_id'   => $customer->id,
                'log_name'    => 'Customer Created',
                'log_description' => 'Customer created successfully',
                'created_by' => Auth::id(),
            ]);
        } catch (\Exception $e) {
            logger('Log insert failed: ' . $e->getMessage());
        }
    }

    /**
     * Handle the Customer "updated" event.
     */
    public function updated(Customer $customer): void
    {
        $logDescription = collect($customer->getChanges())
            ->map(fn($val, $key) => "$key changed to \"$val\"")
            ->implode('; ');
        try {
            CustomerLog::create([
                'customer_id'   => $customer->id,
                'log_name'    => 'Customer Updated',
                'log_description' => $logDescription,
                'created_by' => Auth::id(),
            ]);
        } catch (\Exception $e) {
            logger('Log insert failed: ' . $e->getMessage());
        }
    }

    /**
     * Handle the Customer "deleted" event.
     */
    public function deleted(Customer $customer): void
    {
       try {
            CustomerLog::create([
                'customer_id'   => $customer->id,
                'log_name'    => 'Customer Deleted',
                'log_description' => 'Customer Deleted Successfully',
                'created_by' => Auth::id(),
            ]);
        } catch (\Exception $e) {
            logger('Log insert failed: ' . $e->getMessage());
        }
    }

    /**
     * Handle the Customer "restored" event.
     */
    public function restored(Customer $customer): void
    {
        //
    }

    /**
     * Handle the Customer "force deleted" event.
     */
    public function forceDeleted(Customer $customer): void
    {
        //
    }
}
