<?php

namespace App\Observers;

use App\Models\EditHotelDetail;
use App\Models\EditHotelBookingLog;
use Illuminate\Support\Facades\Auth;

class EditHotelBookingObserver
{
    /**
     * Handle the EditHotelDetail "created" event.
     */
    public function created(EditHotelDetail $editHotelDetail): void
    {
        //
    }

    /**
     * Handle the EditHotelDetail "updated" event.
     */
    public function updated(EditHotelDetail $editHotelDetail): void
    {
        $logDescription = collect($editHotelDetail->getChanges())
            ->map(fn($val, $key) => "$key changed to \"$val\"")
            ->implode('; ');
        try {
            EditHotelBookingLog::create([
                'booking_id' => $editHotelDetail->booking_id,
                'log_name' => 'Updated',
                'log_description' => json_encode($logDescription),
                'created_by' => Auth::id() ?? 0
            ]);
        } catch (\Exception $e) {
            logger('Log insert failed: ' . $e->getMessage());
        }
    }

    /**
     * Handle the EditHotelDetail "deleted" event.
     */
    public function deleted(EditHotelDetail $editHotelDetail): void
    {
        //
    }

    /**
     * Handle the EditHotelDetail "restored" event.
     */
    public function restored(EditHotelDetail $editHotelDetail): void
    {
        //
    }

    /**
     * Handle the EditHotelDetail "force deleted" event.
     */
    public function forceDeleted(EditHotelDetail $editHotelDetail): void
    {
        //
    }
}
