<?php

namespace App\Observers;

use App\Models\HotelSpecialRequest;
use App\Models\HotelSpecialRequestLog;
use Illuminate\Support\Facades\Auth;

class HotelSpecialRequestObserver
{
    /**
     * Handle the HotelSpecialRequest "created" event.
     */
    public function created(HotelSpecialRequest $hotelSpecialRequest): void
    {
         try {
            HotelSpecialRequestLog::create([
                'special_request_id'   => $hotelSpecialRequest->id,
                'log_name'    => 'Hotel Special Request Created',
                'log_description' => 'Hotel Special Request created successfully',
                'created_by' => Auth::id(),
            ]);
        } catch (\Exception $e) {
            logger('Log insert failed: ' . $e->getMessage());
        }
    }

    /**
     * Handle the HotelSpecialRequest "updated" event.
     */
    public function updated(HotelSpecialRequest $hotelSpecialRequest): void
    {
        $logDescription = collect($hotelSpecialRequest->getChanges())
            ->map(fn($val, $key) => "$key changed to \"$val\"")
            ->implode('; ');
        try {
            HotelSpecialRequestLog::create([
                'special_request_id'   => $hotelSpecialRequest->id,
                'log_name'    => 'Hotel Special Request Updated',
                'log_description' => $logDescription,
                'created_by' => Auth::id(),
            ]);
        } catch (\Exception $e) {
            logger('Log insert failed: ' . $e->getMessage());
        }
    }

    /**
     * Handle the HotelSpecialRequest "deleted" event.
     */
    public function deleted(HotelSpecialRequest $hotelSpecialRequest): void
    {
        try {
            HotelSpecialRequestLog::create([
                'special_request_id'   => $hotelSpecialRequest->id,
                'log_name'    => 'Hotel Special Request Deleted',
                'log_description' => 'Hotel Special Request Deleted Successfully',
                'created_by' => Auth::id(),
            ]);
        } catch (\Exception $e) {
            logger('Log insert failed: ' . $e->getMessage());
        }
    }

    /**
     * Handle the HotelSpecialRequest "restored" event.
     */
    public function restored(HotelSpecialRequest $hotelSpecialRequest): void
    {
        //
    }

    /**
     * Handle the HotelSpecialRequest "force deleted" event.
     */
    public function forceDeleted(HotelSpecialRequest $hotelSpecialRequest): void
    {
        //
    }
}
