<?php

namespace App\Observers;

use App\Models\SalesServiceMarkup;
use App\Models\SalesServiceMarkupLog;
use Illuminate\Support\Facades\Auth;

class SalesServiceMarkupObserver
{
    /**
     * Handle the SalesServiceMarkup "created" event.
     */
    public function created(SalesServiceMarkup $salesServiceMarkup): void
    {
        try {
            SalesServiceMarkupLog::create([
                'sales_service_markup_id'   => $salesServiceMarkup->id,
                'log_name'    => 'Sales Service Markup Created',
                'log_description' => 'Sales Service Markup created successfully',
                'created_by' => Auth::id(),
            ]);
        } catch (\Exception $e) {
            logger('Log insert failed: ' . $e->getMessage());
        }
    }

    /**
     * Handle the SalesServiceMarkup "updated" event.
     */
    public function updated(SalesServiceMarkup $salesServiceMarkup): void
    {
        $logDescription = collect($salesServiceMarkup->getChanges())
            ->map(fn($val, $key) => "$key changed to \"$val\"")
            ->implode('; ');
        try {
            SalesServiceMarkupLog::create([
                'sales_service_markup_id'   => $salesServiceMarkup->id,
                'log_name'    => 'Sales Service Markup Updated',
                'log_description' => $logDescription,
                'created_by' => Auth::id(),
            ]);
        } catch (\Exception $e) {
            logger('Log insert failed: ' . $e->getMessage());
        }
    }

    /**
     * Handle the SalesServiceMarkup "deleted" event.
     */
    public function deleted(SalesServiceMarkup $salesServiceMarkup): void
    {
        try {
            SalesServiceMarkupLog::create([
                'sales_service_markup_id'   => $salesServiceMarkup->id,
                'log_name'    => 'Sales Service Markup Deleted',
                'log_description' => 'Sales Service Markup Deleted Successfully',
                'created_by' => Auth::id(),
            ]);
        } catch (\Exception $e) {
            logger('Log insert failed: ' . $e->getMessage());
        }
    }

    /**
     * Handle the SalesServiceMarkup "restored" event.
     */
    public function restored(SalesServiceMarkup $salesServiceMarkup): void
    {
        //
    }

    /**
     * Handle the SalesServiceMarkup "force deleted" event.
     */
    public function forceDeleted(SalesServiceMarkup $salesServiceMarkup): void
    {
        //
    }
}
