<?php

namespace App\Observers;

use App\Models\Wallet;
use App\Models\WalletLog;
use Illuminate\Support\Facades\Auth;

class WalletObserver
{
    /**
     * Handle the Wallet "created" event.
     */
    public function created(Wallet $wallet): void
    {
        try {
            WalletLog::create([
                'created_by'    => Auth::id(),
                'log_name'    => 'wallet created',
                'wallet_id'   => $wallet->id,
                'updated_field' => 'Nil',
            ]);
        } catch (\Exception $e) {
            logger('Log insert failed: ' . $e->getMessage());
        }
    }

    /**
     * Handle the Wallet "updated" event.
     */
    public function updated(Wallet $wallet): void
    {
        $logDescription = collect($wallet->getChanges())
            ->map(fn($val, $key) => "$key changed to \"$val\"")
            ->implode('; ');
        try {
            WalletLog::create([
                'created_by'    => Auth::id(),
                'log_name'    => 'wallet updated',
                'wallet_id'   => $wallet->id,
                'updated_field' => $logDescription,
            ]);
        } catch (\Exception $e) {
            logger('Log insert failed: ' . $e->getMessage());
        }
    }

    /**
     * Handle the Wallet "deleted" event.
     */
    public function deleted(Wallet $wallet): void
    {
        try {
            WalletLog::create([
                'created_by'    =>  Auth::id(),
                'log_name'    => 'Id ' .  $wallet->id . ' wallet Deleted',
                'wallet_id'   =>  $wallet->id,
                'updated_field' => 'Nil',
            ]);
        } catch (\Exception $e) {
            logger('Log insert failed: ' . $e->getMessage());
        }
    }

    /**
     * Handle the Wallet "restored" event.
     */
    public function restored(Wallet $wallet): void
    {
        //
    }

    /**
     * Handle the Wallet "force deleted" event.
     */
    public function forceDeleted(Wallet $wallet): void
    {
        //
    }
}
