<?php

namespace App\Providers;


use Laravel\Scout\EngineManager;
use Elastic\Elasticsearch\Client;
use Illuminate\Support\Facades\URL;
use Illuminate\Pagination\Paginator;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\ServiceProvider;
use Elastic\Elasticsearch\ClientBuilder;
use Matchish\ScoutElasticSearch\Engines\ElasticSearchEngine;


class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        if(config('app.env') === 'production') {
            \URL::forceScheme('https');
        }

        $this->app->singleton(Client::class, function () {
            return ClientBuilder::create()
                ->setHosts(['https://127.0.0.1:9200'])
                ->setBasicAuthentication('elastic', 'VDGjmggOg+PWlrPQYB=v')
                ->setSSLVerification(false)
                ->build();
        });
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {


        // if (config('app.env') === 'production') {
        //     URL::forceScheme('https');
        // }

        URL::forceScheme('https');
        Model::preventLazyLoading();
        Paginator::useBootstrap();

        resolve(EngineManager::class)->extend('elasticsearch', function ($app) {
        return new ElasticSearchEngine(
            $app->make(Client::class),
            config('scout.prefix'),
            [] // no IndexSettings needed in v7
        );
    });

    \App\Models\EditFlightDetail::observe(\App\Observers\EditFlightBookingObserver::class);
    \App\Models\EditHotelDetail::observe(\App\Observers\EditHotelBookingObserver::class);
    \App\Models\Wallet::observe(\App\Observers\WalletObserver::class);
    \App\Models\Coupon::observe(\App\Observers\CouponObserver::class);
    \App\Models\CustomerLoginToken::observe(\App\Observers\CustomerLoginTokenObserver::class);
    \App\Models\User::observe(\App\Observers\UserObserver::class);
    \App\Models\Customer::observe(\App\Observers\CustomerObserver::class);
    \App\Models\SalesServiceMarkup::observe(\App\Observers\SalesServiceMarkupObserver::class);
    \App\Models\HotelSpecialRequest::observe(\App\Observers\HotelSpecialRequestObserver::class);
    }
}
