<?php

namespace App\Services;

use App\Models\CurlRequestLogs;
use Illuminate\Support\Facades\Log;

class CurlRequestService
{
    public static function sendRequest(array $options)
    {
        $curl = curl_init();

        $method   = strtoupper($options['method'] ?? 'GET');
        $url      = $options['url'] ?? '';
        $headers  = $options['headers'] ?? [];
        $body     = $options['body'] ?? null;
        $timeout  = $options['timeout'] ?? 30;
        $startTime = microtime(true);
        // cURL options
        $curlOptions = [
            CURLOPT_URL            => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING       => '',
            CURLOPT_MAXREDIRS      => 10,
            CURLOPT_TIMEOUT        => $timeout,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION   => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST  => $method,
            CURLOPT_POSTFIELDS =>  $body,
            CURLOPT_HTTPHEADER     => $headers,
        ];


        curl_setopt_array($curl, $curlOptions);   
        $response = curl_exec($curl);
        curl_close($curl);
        $duration = (microtime(true) - $startTime) * 1000;


        //  Save logs
        try {
            CurlRequestLogs::logRequest(
                $method,
                $url,
                json_encode($headers),
                is_string($body) ? $body : json_encode($body),
                is_string($response) ? $response : json_encode($response),
                round($duration, 2),
                $timeout,
            );
        } catch (\Throwable $e) {
            Log::error('Failed to log cURL request: ' . $e->getMessage());
        }

        return $response;
    }

    // Explicitly For Flight Offer Search
    public static function executeAmadeusCurl($method = 'POST', $appURL, $amaClientRef, $amadeusAPISecret, $requestData)
    {
        $headers = [
            'Content-Type: application/json',
            "Authorization: Bearer $amadeusAPISecret",
            "ama-client-ref: $amaClientRef",
        ];
        $curl = curl_init();
        $startTime = microtime(true);
        curl_setopt_array($curl, [
            CURLOPT_URL => $appURL,

            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => $method,
            CURLOPT_POSTFIELDS => $requestData,
            CURLOPT_HTTPHEADER => $headers,
        ]);
        // Execute the cURL request
        $response = curl_exec($curl);
        $duration = (microtime(true) - $startTime) * 1000;

        //  Save logs
        try {
            CurlRequestLogs::logRequest(
                $method,
                $appURL,
                json_encode($headers),
                is_string($requestData) ? $requestData : json_encode($requestData),
                is_string($response) ? $response : json_encode($response),
                round($duration, 2),
                30,
            );
        } catch (\Throwable $e) {
            Log::error('Failed to log cURL request: ' . $e->getMessage());
        }

        return $response;
    }
}
