<?php

namespace App\Services;

class ImageUrlMasker
{
    /**
     * Replace all Gimmonix image URLs in a given array or object
     * with your proxy URL.
     *
     * @param array $data
     * @return array
     */
    public static function mask(array $data): array
    {
        array_walk_recursive($data, function (&$item, $key) {
            if (
                is_string($item) &&
                str_starts_with($item, 'https://content.hsp.gimmonix.com')
            ) {
                $item = str_replace(
                    'https://content.hsp.gimmonix.com',
                    'https://api.' . env('APP_URL') . '/api/v1/hotel/hotel-images',
                    $item
                );
            }
        });

        return $data;
    }
}
