<?php

namespace App\Services;

use App\Enums\Locale;
use App\Models\CityI18n;
use App\Models\HotelName;
use App\Models\AirlineI18ns;
use App\Models\AirportI18ns;
use App\Models\CountryI18ns;
use App\Models\HotelAddress;

class TranslateBookingDetails
{
    public static function translateFlightBookingDetails(&$bookingDetails, $translatelang)
    {
        $airlines =  $bookingDetails['booking_details']['booking_details']['flightDetails']['airlines'] ?? $bookingDetails['booking_details']['booking_details']['booking_details']['flightDetails']['airlines'];
        // Collect all unique names
        $airlineNames = [];
        $airportNames = [];
        $cityNames = [];
        $countryNames = [];

        foreach ($airlines as $airline) {
            foreach ($airline['flights'] as $flight) {
                // airline
                if (!empty($flight['airline']['name'])) {
                    $airlineNames[] = $flight['airline']['name'];
                }

                // arrival airport data
                if (!empty($flight['arrivalAirportData'])) {
                    $airportNames[] = $flight['arrivalAirportData']['airport_name'] ?? null;
                    $cityNames[]    = $flight['arrivalAirportData']['city_name'] ?? null;
                    $countryNames[] = $flight['arrivalAirportData']['country_name'] ?? null;
                }

                // departure airport data
                if (!empty($flight['departureAirportData'])) {
                    $airportNames[] = $flight['departureAirportData']['airport_name'] ?? null;
                    $cityNames[]    = $flight['departureAirportData']['city_name'] ?? null;
                    $countryNames[] = $flight['departureAirportData']['country_name'] ?? null;
                }

                // segments
                if (!empty($flight['segments'])) {
                    foreach ($flight['segments'] as $segment) {
                        if (!empty($segment['airlineData']['name'])) {
                            $airlineNames[] = $segment['airlineData']['name'];
                        }

                        if (!empty($segment['arrivalAirportData'])) {
                            $airportNames[] = $segment['arrivalAirportData']['airport_name'] ?? null;
                            $cityNames[]    = $segment['arrivalAirportData']['city_name'] ?? null;
                            $countryNames[] = $segment['arrivalAirportData']['country_name'] ?? null;
                        }

                        if (!empty($segment['departureAirportData'])) {
                            $airportNames[] = $segment['departureAirportData']['airport_name'] ?? null;
                            $cityNames[]    = $segment['departureAirportData']['city_name'] ?? null;
                            $countryNames[] = $segment['departureAirportData']['country_name'] ?? null;
                        }
                    }
                }
            }
        }

        // remove nulls & duplicates
        $airlineNames = array_filter(array_unique($airlineNames));
        $airportNames = array_filter(array_unique($airportNames));
        $cityNames    = array_filter(array_unique($cityNames));
        $countryNames = array_filter(array_unique($countryNames));


        // Fetch all translations in bulk
        $airlineMap = AirlineI18ns::whereIn('airline_name', $airlineNames)
            ->pluck('airline_id', 'airline_name')->toArray();

        $airlineTranslations = AirlineI18ns::whereIn('airline_id', $airlineMap)
            ->where('language_code', $translatelang)
            ->pluck('airline_name', 'airline_id')->toArray();

        $airportMap = AirportI18ns::whereIn('airport_name', $airportNames)
            ->pluck('airport_id', 'airport_name')->toArray();

        $airportTranslations = AirportI18ns::whereIn('airport_id', $airportMap)
            ->where('language_code', $translatelang)
            ->pluck('airport_name', 'airport_id')->toArray();

        $cityMap = CityI18n::whereIn('city_name', $cityNames)
            ->pluck('city_id', 'city_name')->toArray();

        $cityTranslations = CityI18n::whereIn('city_id', $cityMap)
            ->where('language_code', $translatelang)
            ->pluck('city_name', 'city_id')->toArray();

        $countryMap = CountryI18ns::whereIn('country_name', $countryNames)
            ->pluck('country_id', 'country_name')->toArray();

        $countryTranslations = CountryI18ns::whereIn('country_id', $countryMap)
            ->where('language_code', $translatelang)
            ->pluck('country_name', 'country_id')->toArray();


        //Replace values inside original $airlines
        foreach ($airlines as &$airline) {
            foreach ($airline['flights'] as &$flight) {
                // airline
                if (!empty($flight['airline']['name']) && isset($airlineMap[$flight['airline']['name']])) {
                    $id = $airlineMap[$flight['airline']['name']];
                    $flight['airline']['name'] = $airlineTranslations[$id] ?? $flight['airline']['name'];
                }

                // arrival airport data
                if (!empty($flight['arrivalAirportData'])) {
                    if (!empty($flight['arrivalAirportData']['airport_name'])) {
                        $orig = $flight['arrivalAirportData']['airport_name'];
                        if (isset($airportMap[$orig])) {
                            $id = $airportMap[$orig];
                            $flight['arrivalAirportData']['airport_name'] = $airportTranslations[$id] ?? $orig;
                        }
                    }
                    if (!empty($flight['arrivalAirportData']['city_name'])) {
                        $orig = $flight['arrivalAirportData']['city_name'];
                        if (isset($cityMap[$orig])) {
                            $id = $cityMap[$orig];
                            $flight['arrivalAirportData']['city_name'] = $cityTranslations[$id] ?? $orig;
                        }
                    }
                    if (!empty($flight['arrivalAirportData']['country_name'])) {
                        $orig = $flight['arrivalAirportData']['country_name'];
                        if (isset($countryMap[$orig])) {
                            $id = $countryMap[$orig];
                            $flight['arrivalAirportData']['country_name'] = $countryTranslations[$id] ?? $orig;
                        }
                    }
                }

                // departure airport data
                if (!empty($flight['departureAirportData'])) {
                    if (!empty($flight['departureAirportData']['airport_name'])) {
                        $orig = $flight['departureAirportData']['airport_name'];
                        if (isset($airportMap[$orig])) {
                            $id = $airportMap[$orig];
                            $flight['departureAirportData']['airport_name'] = $airportTranslations[$id] ?? $orig;
                        }
                    }
                    if (!empty($flight['departureAirportData']['city_name'])) {
                        $orig = $flight['departureAirportData']['city_name'];
                        if (isset($cityMap[$orig])) {
                            $id = $cityMap[$orig];
                            $flight['departureAirportData']['city_name'] = $cityTranslations[$id] ?? $orig;
                        }
                    }
                    if (!empty($flight['departureAirportData']['country_name'])) {
                        $orig = $flight['departureAirportData']['country_name'];
                        if (isset($countryMap[$orig])) {
                            $id = $countryMap[$orig];
                            $flight['departureAirportData']['country_name'] = $countryTranslations[$id] ?? $orig;
                        }
                    }
                }

                // segments
                if (!empty($flight['segments'])) {
                    foreach ($flight['segments'] as &$segment) {
                        if (!empty($segment['airlineData']['name']) && isset($airlineMap[$segment['airlineData']['name']])) {
                            $id = $airlineMap[$segment['airlineData']['name']];
                            $segment['airlineData']['name'] = $airlineTranslations[$id] ?? $segment['airlineData']['name'];
                        }

                        if (!empty($segment['arrivalAirportData'])) {
                            if (!empty($segment['arrivalAirportData']['airport_name'])) {
                                $orig = $segment['arrivalAirportData']['airport_name'];
                                if (isset($airportMap[$orig])) {
                                    $id = $airportMap[$orig];
                                    $segment['arrivalAirportData']['airport_name'] = $airportTranslations[$id] ?? $orig;
                                }
                            }
                            if (!empty($segment['arrivalAirportData']['city_name'])) {
                                $orig = $segment['arrivalAirportData']['city_name'];
                                if (isset($cityMap[$orig])) {
                                    $id = $cityMap[$orig];
                                    $segment['arrivalAirportData']['city_name'] = $cityTranslations[$id] ?? $orig;
                                }
                            }
                            if (!empty($segment['arrivalAirportData']['country_name'])) {
                                $orig = $segment['arrivalAirportData']['country_name'];
                                if (isset($countryMap[$orig])) {
                                    $id = $countryMap[$orig];
                                    $segment['arrivalAirportData']['country_name'] = $countryTranslations[$id] ?? $orig;
                                }
                            }
                        }

                        if (!empty($segment['departureAirportData'])) {
                            if (!empty($segment['departureAirportData']['airport_name'])) {
                                $orig = $segment['departureAirportData']['airport_name'];
                                if (isset($airportMap[$orig])) {
                                    $id = $airportMap[$orig];
                                    $segment['departureAirportData']['airport_name'] = $airportTranslations[$id] ?? $orig;
                                }
                            }
                            if (!empty($segment['departureAirportData']['city_name'])) {
                                $orig = $segment['departureAirportData']['city_name'];
                                if (isset($cityMap[$orig])) {
                                    $id = $cityMap[$orig];
                                    $segment['departureAirportData']['city_name'] = $cityTranslations[$id] ?? $orig;
                                }
                            }
                            if (!empty($segment['departureAirportData']['country_name'])) {
                                $orig = $segment['departureAirportData']['country_name'];
                                if (isset($countryMap[$orig])) {
                                    $id = $countryMap[$orig];
                                    $segment['departureAirportData']['country_name'] = $countryTranslations[$id] ?? $orig;
                                }
                            }
                        }
                    }
                    unset($segment);
                }
            }
            unset($flight);
        }
        unset($airline);

        if (isset($bookingDetails['booking_details']['booking_details']['flightDetails']['airlines'])) {

            $bookingDetails['booking_details']['booking_details']['flightDetails']['airlines'] = $airlines;
        } else {
            $bookingDetails['booking_details']['booking_details']['booking_details']['flightDetails']['airlines'] = $airlines;
        }
        $flightInfoDetails = $bookingDetails['booking_details']['booking_details']['flightDetails']['flightInfo']
            ?? $bookingDetails['booking_details']['booking_details']['booking_details']['flightDetails']['flightInfo'];

        // Collect all names that need translation
        $airlineNames = $airportNames = $cityNames = $countryNames = [];

        foreach ($flightInfoDetails as $flightInfo) {
            foreach ($flightInfo['itineraries'] as $itinerary) {
                foreach ($itinerary as $segments) {
                    if (!is_array($segments)) continue;
                    foreach ($segments as $seg) {
                        if (isset($seg['airlineData']['name'])) $airlineNames[] = $seg['airlineData']['name'];
                        if (isset($seg['arrivalAirportData']['airport_name'])) $airportNames[] = $seg['arrivalAirportData']['airport_name'];
                        if (isset($seg['arrivalAirportData']['city_name'])) $cityNames[] = $seg['arrivalAirportData']['city_name'];
                        if (isset($seg['arrivalAirportData']['country_name'])) $countryNames[] = $seg['arrivalAirportData']['country_name'];
                        if (isset($seg['departureAirportData']['airport_name'])) $airportNames[] = $seg['departureAirportData']['airport_name'];
                        if (isset($seg['departureAirportData']['city_name'])) $cityNames[] = $seg['departureAirportData']['city_name'];
                        if (isset($seg['departureAirportData']['country_name'])) $countryNames[] = $seg['departureAirportData']['country_name'];
                    }
                }
            }
        }

        //Remove duplicates
        $airlineNames = array_unique($airlineNames);
        $airportNames = array_unique($airportNames);
        $cityNames = array_unique($cityNames);
        $countryNames = array_unique($countryNames);

        //Batch fetch translations
        $airlineTranslations = AirlineI18ns::whereIn('airline_name', $airlineNames)
            ->pluck('airline_name', 'airline_id')
            ->toArray();

        $airlineLangMap = AirlineI18ns::whereIn('airline_name', $airlineNames)
            ->where('language_code', $translatelang)
            ->pluck('airline_name', 'airline_id')
            ->toArray();

        $airportTranslations = AirportI18ns::whereIn('airport_name', $airportNames)
            ->pluck('airport_name', 'airport_id')
            ->toArray();

        $airportLangMap = AirportI18ns::whereIn('airport_name', $airportNames)
            ->where('language_code', $translatelang)
            ->pluck('airport_name', 'airport_id')
            ->toArray();

        $cityTranslations = CityI18n::whereIn('city_name', $cityNames)
            ->pluck('city_name', 'city_id')
            ->toArray();

        $cityLangMap = CityI18n::whereIn('city_name', $cityNames)
            ->where('language_code', $translatelang)
            ->pluck('city_name', 'city_id')
            ->toArray();

        $countryTranslations = CountryI18ns::whereIn('country_name', $countryNames)
            ->pluck('country_name', 'country_id')
            ->toArray();

        $countryLangMap = CountryI18ns::whereIn('country_name', $countryNames)
            ->where('language_code', $translatelang)
            ->pluck('country_name', 'country_id')
            ->toArray();

        // Map translations back to segments
        foreach ($flightInfoDetails as &$flightInfo) {
            foreach ($flightInfo['itineraries'] as &$itinerary) {
                foreach ($itinerary as &$segments) {
                    if (!is_array($segments)) continue;
                    foreach ($segments as &$seg) {
                        // Airline
                        if (isset($seg['airlineData']['name'])) {
                            $airlineId = array_search($seg['airlineData']['name'], $airlineTranslations);
                            if ($airlineId && isset($airlineLangMap[$airlineId])) {
                                $seg['airlineData']['name'] = $airlineLangMap[$airlineId];
                            }
                        }

                        // Arrival
                        if (isset($seg['arrivalAirportData'])) {
                            if (isset($seg['arrivalAirportData']['airport_name'])) {
                                $airportId = array_search($seg['arrivalAirportData']['airport_name'], $airportTranslations);
                                if ($airportId && isset($airportLangMap[$airportId])) {
                                    $seg['arrivalAirportData']['airport_name'] = $airportLangMap[$airportId];
                                }
                            }
                            if (isset($seg['arrivalAirportData']['city_name'])) {
                                $cityId = array_search($seg['arrivalAirportData']['city_name'], $cityTranslations);
                                if ($cityId && isset($cityLangMap[$cityId])) {
                                    $seg['arrivalAirportData']['city_name'] = $cityLangMap[$cityId];
                                }
                            }
                            if (isset($seg['arrivalAirportData']['country_name'])) {
                                $countryId = array_search($seg['arrivalAirportData']['country_name'], $countryTranslations);
                                if ($countryId && isset($countryLangMap[$countryId])) {
                                    $seg['arrivalAirportData']['country_name'] = $countryLangMap[$countryId];
                                }
                            }
                        }

                        // Departure
                        if (isset($seg['departureAirportData'])) {
                            if (isset($seg['departureAirportData']['airport_name'])) {
                                $airportId = array_search($seg['departureAirportData']['airport_name'], $airportTranslations);
                                if ($airportId && isset($airportLangMap[$airportId])) {
                                    $seg['departureAirportData']['airport_name'] = $airportLangMap[$airportId];
                                }
                            }
                            if (isset($seg['departureAirportData']['city_name'])) {
                                $cityId = array_search($seg['departureAirportData']['city_name'], $cityTranslations);
                                if ($cityId && isset($cityLangMap[$cityId])) {
                                    $seg['departureAirportData']['city_name'] = $cityLangMap[$cityId];
                                }
                            }
                            if (isset($seg['departureAirportData']['country_name'])) {
                                $countryId = array_search($seg['departureAirportData']['country_name'], $countryTranslations);
                                if ($countryId && isset($countryLangMap[$countryId])) {
                                    $seg['departureAirportData']['country_name'] = $countryLangMap[$countryId];
                                }
                            }
                        }
                    }
                    unset($seg);
                }
                unset($segments);
            }
            unset($itinerary);
        }
        unset($flightInfo);

        if (isset($bookingDetails['booking_details']['booking_details']['flightDetails']['flightInfo'])) {
            $bookingDetails['booking_details']['booking_details']['flightDetails']['flightInfo'] = $flightInfoDetails;
        } else {
            $bookingDetails['booking_details']['booking_details']['booking_details']['flightDetails']['flightInfo'] = $flightInfoDetails;
        }


        // Translate Airline List
        $airlineList = $bookingDetails['booking_details']['booking_details']['searchDetails']['airlineList'] ?? $bookingDetails['booking_details']['booking_details']['booking_details']['searchDetails']['airlineList'];
        if (is_array($airlineList) && !empty($airlineList)) {
            $airlineNames = array_column($airlineList, 'name');

            $airlineIds = AirlineI18ns::whereIn('airline_name', $airlineNames)
                ->pluck('airline_id', 'airline_name')
                ->toArray();

            $translations = AirlineI18ns::whereIn('airline_id', $airlineIds)
                ->where('language_code', $translatelang)
                ->pluck('airline_name', 'airline_id')
                ->toArray();

            foreach ($airlineList as &$airline) {
                if (!empty($airlineIds[$airline['name']])) {
                    $airlineId = $airlineIds[$airline['name']];
                    if (!empty($translations[$airlineId])) {
                        $airline['name'] = $translations[$airlineId];
                    }
                }
            }
            unset($airline);
        }


        if (isset($bookingDetails['booking_details']['booking_details']['searchDetails']['airlineList'])) {
            $bookingDetails['booking_details']['booking_details']['searchDetails']['airlineList'] =  $airlineList;
        } else {
            $bookingDetails['booking_details']['booking_details']['booking_details']['searchDetails']['airlineList'] =  $airlineList;
        }

        $bookingDetails = $bookingDetails;
        return $bookingDetails;
    }

    public static function translateHotelBookingDetails(&$bookingDetails, $translatelang)
    {

        $hotelDetails = $bookingDetails['booking_details']['hotelDetails']['hotelDetails'];
        $hotelName = $hotelDetails['DisplayName'] ?? '';
        $hotelId = $hotelDetails['ID'] ?? '';
        $cityName = $bookingDetails['booking_details']['searchDetails']['city'] ?? '';
        if ($hotelName) {
            if ($translatelang == Locale::Arabic->value) {
                if ($hotelId) {
                    $translatedHotelName = HotelName::select('display_name')->where('hotel_id', $hotelId)->first();
                    $bookingDetails['booking_details']['hotelDetails']['hotelDetails']['DisplayName'] = $translatedHotelName ? $translatedHotelName->display_name : $hotelName;
                }
                if ($cityName) {
                    $cityId = CityI18n::where('city_name', $cityName)->value('city_id');
                    if ($cityId) {
                        $cityName = CityI18n::where('city_id', $cityId)->where('language_code', $translatelang)?->value('city_name');
                        $bookingDetails['booking_details']['searchDetails']['city'] = $cityName ? $cityName : $bookingDetails['booking_details']['searchDetails']['city'];
                    }
                }
            } else {
                if ($hotelId) {
                    $translatedHotelName = HotelAddress::select('displayname')->where('hotelid', $hotelId)->first();

                    $bookingDetails['booking_details']['hotelDetails']['hotelDetails']['DisplayName'] = $translatedHotelName ? $translatedHotelName->displayname : $hotelName;
                }
                if ($cityName) {
                    $cityId = CityI18n::where('city_name', $cityName)->value('city_id');
                    if ($cityId) {
                        $cityName = CityI18n::where('city_id', $cityId)->where('language_code', $translatelang)?->value('city_name');
                        $bookingDetails['booking_details']['searchDetails']['city'] = $cityName ? $cityName : $bookingDetails['booking_details']['searchDetails']['city'];
                    }
                }
            }
        }
        return  $bookingDetails;
    }
}
