<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */


namespace App\Traits;

use App\Enums\BookingStatus;
use App\Enums\Currency;
use App\Enums\Locale;
use App\Enums\ServiceType as EnumsServiceType;
use App\Models\Bookings;
use App\Models\BookingAdditionalDetail;
use App\Models\Country;
use App\Models\CurrencyExchangeRates;
use App\Models\Customer;
use App\Models\ServiceType;
use App\Models\Setting;
use App\Models\SmsTemplate;
use App\Models\SmsTemplateI18ns;
use App\Models\Suppliers;
use App\Traits\EmailService;
use App\Traits\PaymentService;
use App\Traits\SmsService;
use App\Traits\WhatsappService;
use App\Traits\HotelBeds;
use App\Traits\EditBooking;
use App\Models\DefaultMarkup;
use App\Models\SupplierLog;
use Illuminate\Support\Str;
use Carbon\Carbon;
use Config;
use DateTime;
use Exception;
use App\Traits\LoyaltyPointsService;
use Illuminate\Support\Facades\Log;



trait BookingService
{
    use EmailService, HotelBeds, LoyaltyPointsService, PaymentService, SmsService, WhatsappService, EditBooking;

    public function getCountriesWithIsoCode()
    {
        $countriesWithIsoCode = [];
        $countries = Country::select('id', 'iso_code')->where('status', 'active')->get();
        if ($countries) {
            foreach ($countries as $country) {
                $countriesWithIsoCode[$country->id] = $country->iso_code;
            }
        }
        return $countriesWithIsoCode;
    }

    public function getCountriesByIds()
    {
        $countriesWithIsoCode = [];
        $countries = Country::select('id', 'iso_code')->where('status', 'active')->get();
        if ($countries) {
            foreach ($countries as $country) {
                $countriesWithIsoCode[$country->id] = $country->iso_code;
            }
        }
        return $countriesWithIsoCode;
    }

    public function processBookingRequestData($bookingDetails)
    {
        $serviceTypeId = ServiceType::where('is_active', '1')->where('code', $bookingDetails['bookingDetails']['bookingType'])->value('id');
        $bookingDetails['bookingDetails']['service_type_id'] = $serviceTypeId;
        $supplierDetails = Suppliers::where('core_service_type_id', $serviceTypeId)->first()->toArray();
        $bookingDetails['bookingDetails']['supplier'] = $supplierDetails['code'];
        $bookingDetails['bookingDetails']['supplier_id'] = $supplierDetails['id'];
        if (!isset($bookingDetails['bookingDetails']['agencyId'])) {
            $bookingDetails['bookingDetails']['agencyId'] = 0;
        }
        return $bookingDetails;
    }

    public function generateFlightBookingPayload($bookingDetails)
    {
        $countriesWithIsoCode = $this->getCountriesWithIsoCode();

        $contactDetails = [
            'companyName' => env('APP_NAME'),
            'firstName' => '',
            'lastName' => '',
            'countryCode' => str_replace('+', '', $bookingDetails['userDetails']['phoneCode']),
            'mobileNumber' => $bookingDetails['userDetails']['phoneNumber'],
            'emailAddress' => $bookingDetails['userDetails']['email'],
            'address' => $bookingDetails['billingDetails']['address'],
            'address1' => (isset($bookingDetails['billingDetails']['address1']) ? $bookingDetails['billingDetails']['address1'] : ''),
            'cityName' => $bookingDetails['billingDetails']['city'],
            'countryIsoCode' => $bookingDetails['billingDetails']['country'],
            'postalCode' => $bookingDetails['billingDetails']['zipcode'],
        ];

        if ($bookingDetails['userDetails']['userId'] != '') {
            $customerDetails = Customer::where('id', $bookingDetails['userDetails']['userId'])->first()->toArray();
            if ($customerDetails) {
                $contactDetails['firstName'] = $customerDetails['first_name'];
                $contactDetails['lastName'] = $customerDetails['last_name'];
            }
        }
        if ($contactDetails['firstName'] == '') {
            $contactDetails['firstName'] = $bookingDetails['passengerDetails'][0]['first_name'];
            $contactDetails['lastName'] = $bookingDetails['passengerDetails'][0]['last_name'];
        }

        $flightOfferIds = [];
        $formOfPayments = [];
        foreach ($bookingDetails['flightDetails']['flightInfo'] as $flightDetails) {
            array_push($flightOfferIds, $flightDetails['id']);
            array_push($formOfPayments, [
                'other' => [
                    'method' => 'CASH',
                    'flightOfferIds' => [$flightDetails['id']]
                ]
            ]);
        }
        $countryCallingCode = '966';
        if ($contactDetails['countryCode'] != '') {
            $countryCallingCode = $contactDetails['countryCode'];
        }
        $result = [
            'agencyId' => $bookingDetails['bookingDetails']['agencyId'],
            'currencyCode' => $bookingDetails['bookingDetails']['customer_currency'],
            'supplier' => $bookingDetails['bookingDetails']['supplier'],
            'languageCode' => $bookingDetails['bookingDetails']['customer_language_code'],
            'data' => [
                'type' => 'flight-order',
                'flightOffers' => $bookingDetails['flightDetails']['flightInfo'],
                'travelers' => [],
                'remarks' => [
                    'general' => [
                        [
                            'subType' => 'GENERAL_MISCELLANEOUS',
                            'text' => 'Online Flight booking for ' . $contactDetails['companyName']
                        ]
                    ]
                ],
                'ticketingAgreement' => [
                    'option' => 'CONFIRM'
                ],
                'contacts' => [
                    [
                        'addresseeName' => [
                            'firstName' => $contactDetails['firstName'],
                            'lastName' => $contactDetails['lastName']
                        ],
                        'companyName' => $contactDetails['companyName'],
                        'purpose' => 'STANDARD',
                        'phones' => [
                            [
                                'deviceType' => 'MOBILE',
                                'countryCallingCode' => $countryCallingCode,
                                'number' => $contactDetails['mobileNumber']
                            ]
                        ],
                        'emailAddress' => $contactDetails['emailAddress'],
                        'address' => [
                            'lines' => [
                                $contactDetails['address']
                            ],
                            'cityName' => $contactDetails['cityName'],
                            'countryCode' => $contactDetails['countryIsoCode'],
                            'postalCode' => $contactDetails['postalCode']
                        ]
                    ]
                ],
                'formOfPayments' => $formOfPayments
            ]
        ];
        if ($contactDetails['address1'] != '') {
            array_push($result['data']['contacts'][0]['address']['lines'], $contactDetails['address1']);
        }
        $travelers = [];
        foreach ($bookingDetails['passengerDetails'] as $key => $passenger) {
            $issuanceCountry = $countriesWithIsoCode[$passenger['passport_issued_country']];
            $nationalityCountry = $countriesWithIsoCode[$passenger['passport_nationality']];
            if (array_key_exists('gender', $passenger) == false) {
                $passenger['gender'] = 'male';
            }
            $traveler = [
                'id' => ($key + 1),
                'dateOfBirth' => substr($passenger['date_of_birth'], 0, 10),
                'gender' => strtoupper($passenger['gender']),
                'name' => [
                    'firstName' => $passenger['first_name'],
                    'lastName' => $passenger['last_name'],
                ],
                'contact' => [
                    'emailAddress' => $contactDetails['emailAddress'],
                    'phones' => [
                        [
                            'deviceType' => 'MOBILE',
                            'countryCallingCode' => $contactDetails['countryCode'],
                            'number' => $contactDetails['mobileNumber']
                        ]
                    ]
                ]
            ];
            if ($key == 0) {
                $birthPlace = (array_key_exists('birth_place', $passenger) ? $passenger['birth_place'] : 'India');
                if (array_key_exists('id_type', $passenger) == false) {
                    $passenger['id_type'] = 'passport';
                }
                $documents = [
                    'documentType' => strtoupper($passenger['id_type']),
                    'birthPlace' => substr($birthPlace, 0, 10),
                    'issuanceLocation' => $birthPlace,
                    'issuanceDate' => substr($passenger['issue_date'], 0, 10),
                    'number' => $passenger['passport_number'],
                    'expiryDate' => substr($passenger['expiry_date'], 0, 10),
                    'issuanceCountry' => $issuanceCountry,
                    'validityCountry' => $issuanceCountry,
                    'nationality' => $nationalityCountry,
                    'holder' => true
                ];
                $traveler['documents'] = [$documents];
                $traveler['contact']['documents'] = [$documents];
            }
            $travelers[$key] = $traveler;
        }
        $result['data']['travelers'] = $travelers;

        return $result;
    }

    public function generateHotelBookingPayload($bookingDetails)
    {
        $payload = $bookingDetails['hotelDetails']['selectedRooms'];
        $payload['clientReference'] = 'Rehlte Hotel Booking';
        $payload['remark'] = 'Rehlte hotel booking remarks';
        return $payload;
    }

    public function sendBookingEmailOld($bookingDetails)
    {
        $result = [
            'success' => false,
            'message' => '',
        ];

        $bookingCode = 'BOOKING_CONFIRMATION';
        $agencyLogo = Setting::where('config_key', 'general|basic|colorLogo')->get('value')[0]['value'] ?? Setting::where('config_key', 'general|basic|siteName')->get('value')[0]['value'];
        $siteName = count(Setting::where('config_key', 'general|basic|siteName')->get('value')) > 0 ? Setting::where('config_key', 'general|basic|siteName')->get('value')[0]['value'] : "Rehlte";
        if ($bookingDetails['booking_type'] == EnumsServiceType::Flight->value) {
            $bookingEmailData = [
                'agency_logo' => $agencyLogo,
                'agency_name' => $siteName,
                'BookingRef' => $bookingDetails['booking_ref'],
                'ItinearyId' => $bookingDetails['supplier_booking_ref'],
                'BookingDate' => date('d-m-Y', strtotime($bookingDetails['booking_date'])),
                'TravelDate' => date('d-m-Y', strtotime($bookingDetails['booking_start_date'])),
                'StartLocation' => '',
                'TourName' => 'Rehlte Flight',
                'CurrencySymbol' => $bookingDetails['customer_currency'],
                'GrandTotal' => $bookingDetails['total'],
                'GuestDetail' => '',
                'LocalContactNumber' => '',
                'LeadPassengerName' => '',
                'LeadPassengerNameEmail' => '',
                'LeadPassengerPhone' => '',
                'LeadPassengerAddress' => '',
            ];
            $getCreateBookingTemplateData = EmailService::createBookingMailTemplate($bookingCode, $bookingEmailData, $bookingDetails['customer_language_code']);
        } elseif ($bookingDetails['booking_type'] == EnumsServiceType::Hotel->value) {
            $bookingCode = 'HOTEL_BOOKING_CONFIRMATION';
            $bookingEmailData = [
                'agency_logo' => $agencyLogo,
                'agency_name' => $siteName,
                'BookingRef' => $bookingDetails['booking_ref'],
                'ItinearyId' => $bookingDetails['supplier_booking_ref'],
                'BookingDate' => date('d-m-Y', strtotime($bookingDetails['booking_date'])),
                'TravelDate' => date('d-m-Y', strtotime($bookingDetails['booking_start_date'])),
                'StartLocation' => '',
                'TourName' => 'Rehlte Flight',
                'CurrencySymbol' => $bookingDetails['customer_currency'],
                'GrandTotal' => $bookingDetails['total'],
                'GuestDetail' => '',
                'LocalContactNumber' => '',
                'LeadPassengerName' => '',
                'LeadPassengerNameEmail' => '',
                'LeadPassengerPhone' => '',
                'LeadPassengerAddress' => '',
            ];
            $getCreateBookingTemplateData = EmailService::createBookingMailTemplate($bookingCode, $bookingEmailData, $bookingDetails['customer_language_code']);
        }

        if ($getCreateBookingTemplateData['status'] == 'false') {
            $result['message'] = $getCreateBookingTemplateData['error'];
        } else {
            $toEmail = $bookingDetails['email'];
            $mailSubject = $getCreateBookingTemplateData['data']['subject'];
            $emailContent = $getCreateBookingTemplateData['data']['mailData'];

            $baseUrl = url('/');
            $url = $baseUrl . "/booking/download/" . $bookingDetails['id'];
            $filename = $bookingDetails['booking_ref'] . ".pdf";
            $pdf_file_url = $_SERVER["DOCUMENT_ROOT"] . "/" . $filename;
            $cmd = "wkhtmltopdf $url $pdf_file_url 2>&1";
            exec($cmd);

            $file = $baseUrl . "/" . $filename;
            $files = [$file];

            // set data in sendEmail function
            $data = EmailService::sendEmail($toEmail, $mailSubject, $emailContent, $files, $siteName);
            if ($data['status'] == 'true') {
                $result['success'] = true;
                $result['message'] = 'Booking email resent successfully!';
            } else {
                $result['message'] = 'Something went wrong. Please try again.';
            }
        }
        return $result;
    }

    public function processBookingEmailContent($templateDetails, $bookingDetails, $agencyName)
    {
        $agencyLogo = Setting::where('config_key', 'general|basic|colorLogo')->get('value')[0]['value'] ?? Setting::where('config_key', 'general|basic|siteName')->get('value')[0]['value'];
        $bookingAdditionalDetails = BookingAdditionalDetail::where('booking_id', $bookingDetails['id'])->select('booking_details')->first();
        $bookingPayloadDetails = json_decode($bookingAdditionalDetails['booking_details'], true);
        $bookingType = $bookingDetails['booking_type'] ?? '';
        $editedBookingDetail = $this->getEditedBooking($bookingDetails['id'], $bookingType);
        if (!empty($editedBookingDetail)) {
            $processedPrice = json_decode($editedBookingDetail['processedPrice'], true);
            $totalPrice = $processedPrice['grandTotal'] ?? '';
        }

        $bookingRef = $bookingDetails['booking_ref'] ?? '';
        $languageCode = $bookingDetails['customer_language_code'] ?? '';
        $name = $bookingDetails['first_name'] . ' ' . $bookingDetails['last_name'] ?? '';
        $pnr = $bookingDetails['supplier_booking_associated_ref'] ?? '';
        $currency = $bookingDetails['customer_currency'] ?? '';
        $totalPrice = $totalPrice ?? $bookingDetails['total'] ?? '';
        $totalPrice =  $currency . ' ' . $totalPrice;
        $isd_code = $bookingDetails['phone_country_code'] ?? '';
        $phone_no = $bookingDetails['phone'] ?? '';
        $phone = $isd_code . ' ' . $phone_no;
        $serviceProvider = $bookingDetails['service_provider'] ?? '';

        $searchArray = [
            '{{agencyName}}',
            '{{agencyLogo}}',
            '{{bookingRef}}',
            '{{supplierBookingRef}}',
            '{{pnr}}',
            '{{bookedOn}}',
            '{{name}}',
            '{{travelDate}}',
            '{{totalPrice}}',
            '{{email}}',
            '{{phone}}'
        ];
        $replaceArray = [
            ucwords($agencyName),
            ucwords($agencyLogo),
            $bookingRef,
            $bookingDetails['supplier_booking_ref'],
            $pnr,
            date('d M Y', strtotime($bookingDetails['booking_date'])),
            $name,
            date('d M Y', strtotime($bookingDetails['booking_start_date'])),
            $totalPrice,
            $bookingDetails['email'],
            $phone
        ];

        $adultChildrenByLanguage = [
            Locale::English->value => ['adult' => 'Adult', 'adults' => 'Adults', 'children' => 'Children'],
            Locale::Arabic->value => ['adult' => 'الكبار', 'adults' => 'الكبار', 'children' => 'أطفال'],
        ];
        $languageCommon = [
            Locale::English->value => ['pnr' => 'PNR', 'terminal' => 'Terminal', 'night' => 'Night Stay', 'nights' => 'Nights Stay', 'room' => 'Room', 'rooms' => 'Rooms', 'guest' => 'Guest', 'guests' => 'Guests', 'travellers' => 'TRAVELERS', 'layover_at' => 'Layover at'],
            Locale::Arabic->value => ['pnr' => 'رقم سجل الركاب', 'terminal' => 'صالة', 'night' => 'إقامة ليلية', 'nights' => 'ليال البقاء', 'room' => 'غرفة', 'rooms' => 'غرف', 'guest' => 'ضيف', 'guests' => 'ضيوف', 'travellers' => 'المسافرون', 'layover_at' => 'توقف عند'],
        ];

        switch ($bookingType) {
            case EnumsServiceType::Flight->value:
                $flightRoutesByLanguage = [
                    Locale::English->value => ['one-way' => 'One way', 'round-trip' => 'Round trip', 'multicity' => 'Multi city', 'multi-city' => 'Multi city'],
                    Locale::Arabic->value => ['one-way' => 'طريقة واحدة', 'round-trip' => 'جولة', 'multicity' => 'مدينة متعددة', 'multi-city' => 'مدينة متعددة']
                ];
                $flightRoute = $bookingDetails['additional_details'];
                if ($flightRoute == '') {
                    $flightRoute = 'one-way';
                }
                $travelers = '';
                $additionalbookingDetails = BookingAdditionalDetail::where('booking_id', $bookingDetails['id'])->first();
                $pnrDetails = json_decode($additionalbookingDetails->service_provider_booking_response, true) ?? [];
                $airlinePnr = $gdsPnr = [];
                if (!empty($pnrDetails)) {
                    $bookingData['pnrDetails'] =  $pnrDetails['data']['associatedRecords'] ?? [];
                    foreach ($bookingData['pnrDetails'] as $record) {
                        if ($record['originSystemCode'] === 'GDS') {
                            $gdsPnr[] = $record['reference'];
                        } else {
                            $airlinePnr[] = $record['reference'];
                        }
                    }
                }

                if (is_array($airlinePnr)) {
                    $pnr = implode(', ', array_filter(array_map('trim', $airlinePnr)));
                } elseif (!empty($airlinePnr)) {
                    $pnr = implode(', ', array_filter(array_map('trim', explode(',', $airlinePnr))));
                } else {
                    $pnr = 'N/A';
                }

                foreach ($bookingPayloadDetails['passengerDetails'] as $passenger) {
                    $passengerName = strtoupper($passenger['title']) . '. ' . strtoupper($passenger['first_name']) . ' ' . strtoupper($passenger['last_name']);
                    $adultChildren = '';
                    if (isset($passenger['traveler_type'])) {
                        $adultChildren = ($passenger['traveler_type'] == 'adult') ? $adultChildrenByLanguage[$languageCode]['adult'] : $adultChildrenByLanguage[$languageCode]['children'];
                    }
                    $travelers .= '
                    <tr>
                        <td style="padding-bottom:15px" valign="top">
                            <table border="0" cellpadding="0" cellspacing="0" width="100%">
                                <tbody>
                                    <tr>
                                    <td>
                                        <div style="color:#000000;font-size:13px;margin:0 0 3px;font-weight:bold">' . $passengerName ?? '' . '  <span style="font-size:13px;color:#777777;margin:0;font-weight:normal">' . $adultChildren . '</span></div>
                                    </td>
                                    </tr>
                                </tbody>
                            </table>
                        </td>
                    </tr>
                    ';
                }

                $bookingFromTo = $flightDetails = '';
                foreach ($bookingPayloadDetails['flightDetails']['airlines'][0]['flights'] as $key => $flight) {
                    $departureCity = trim($flight['departureAirportData']['city_name']);
                    $arrivalCity = trim($flight['arrivalAirportData']['city_name']);

                    if ($key != 0) {
                        $bookingFromTo .= ',&nbsp;&nbsp;';
                    }
                    $bookingFromTo .= $departureCity . '&nbsp;-&nbsp;' . $arrivalCity;

                    $totalDuration = '';
                    if (isset($flight['totalDuration'])) {
                        $totalDuration = ' &#x2022; ' . $flight['totalDuration'];
                    }

                    $flightDetails .= '
                    <tr>
                        <td style="padding:20px 0px 12px">
                            <table border="0" cellpadding="0" cellspacing="0" width="100%">
                            <tbody>
                            <tr>
                                <td style="font-family:Arial,Helvetica,sans-serif;font-size:20px;color:#000000;font-weight:bold" valign="top">' . $departureCity . ' - ' . $arrivalCity . '</td>
                            </tr>
                            <tr>
                                <td style="font-family:Arial,Helvetica,sans-serif;font-size:12px;color:#4a4a4a;padding-top:5px" valign="top"><span style="display:inline-block;padding-right:3px">' . date('d-M-Y h:i A', strtotime($flight['segments'][0]['departure']['at'])) . $totalDuration . '</span></td>
                            </tr>
                            </tbody>
                            </table>
                        </td>
                    </tr>
                    <tr>
                        <td style="border:1px solid #e7e7e7;border-radius:8px;background-color:#ffffff" valign="top">
                            <table border="0" cellpadding="0" cellspacing="0" width="100%">
                            <tbody>
                            <tr>
                                <td style="padding:0px">
                                    <table border="0" cellpadding="0" cellspacing="0" width="100%">
                                    <tbody>
                                    <tr>
                                        <td style="padding:0px;border-bottom:1px solid #e7e7e7">';

                    foreach ($flight['segments'] as $skey => $segment) {
                        $flightDetails .= '
                                            <table border="0" cellpadding="0" cellspacing="0" width="100%">
                                            <tbody>
                                            <tr>
                                                <td style="padding:16px 0px" valign="top" width="30%">
                                                    <table border="0" cellpadding="0" cellspacing="0" width="100%">
                                                    <tbody>
                                                        <tr>
                                                            <td style="font-family:Arial,Helvetica,sans-serif;font-size:14px;font-weight:normal;color:#747474;line-height:14px;padding-left:16px;padding-right:16px">
                                                                <table border="0" cellpadding="0" cellspacing="0" width="100%">
                                                                <tbody>
                                                                <tr>
                                                                    <td style="width:32px" valign="top" width="32"><img alt="airlogo" src="' . $segment['airlineData']['logo'] . '" style="width:32px;height:32px" width="32" class="CToWUd" data-bit="iit"></td>
                                                                    <td style="padding-left:8px;padding-right:10px" valign="top">
                                                                        <div style="margin:0;padding:0 0 3px;font-size:12px;font-weight:bold;font-family:Arial,Helvetica,sans-serif;color:#46484d">' . $segment['airlineData']['name'] . '</div>
                                                                        <div style="margin:0;padding:0px;font-size:12px;font-weight:normal;font-family:Arial,Helvetica,sans-serif;color:#777777">' . $segment['aircraftData']['name'] . '</div>
                                                                    </td>
                                                                </tr>
                                                                </tbody>
                                                                </table>
                                                                <table align="left" border="0" cellpadding="0" cellspacing="0" width="100%">
                                                                <tbody>
                                                                <tr>
                                                                    <td style="height:40px"></td>
                                                                </tr>
                                                                <tr>
                                                                    <td style="padding:0">
                                                                        <table align="left" border="0" cellpadding="0" cellspacing="0">
                                                                        <tbody>
                                                                        <tr>
                                                                            <td height="30" style="background-color:#e20a18;border:1px solid #e20a18;font-size:14px;font-weight:normal;font-family:Arial,Helvetica,sans-serif;color:#ffffff;text-align:center;border-top-left-radius:4px;border-bottom-left-radius:4px;height:30px" width="50">' . $languageCommon[$languageCode]['pnr'] . '</td>
                                                                            <td align="center" height="30" style="padding:0px 10px;font-weight:bold;font-family:Arial,Helvetica,sans-serif;color:#e20a18;border:1px solid #e20a18;border-bottom-right-radius:4px;border-top-right-radius:4px;text-align:center" width="85">' . $pnr . '</td>
                                                                        </tr>
                                                                        </tbody>
                                                                        </table>
                                                                    </td>
                                                                </tr>
                                                                </tbody>
                                                                </table>
                                                            </td>
                                                        </tr>
                                                    </tbody>
                                                    </table>
                                                </td>
                                                <td style="padding:16px 0px;border-left:1px solid #e7e7e7" valign="top" width="70%">
                                                    <table border="0" cellpadding="0" cellspacing="0" width="100%">
                                                    <tbody>
                                                    <tr>
                                                        <td style="padding-left:10px" valign="top" width="40%">
                                                            <table align="right" border="0" cellpadding="0" cellspacing="0" width="100%">
                                                            <tbody>
                                                            <tr>
                                                                <td style="font-family:Arial,Helvetica,sans-serif;font-size:14px;font-weight:normal;color:#4a4a4a;line-height:18px;padding-bottom:10px">
                                                                <div style="font-weight:bold;color:#000000;margin:0 0 3px 0">' . $segment['departureAirportData']['city_name'] . '</div>
                                                                <div style="font-size:16px;color:#4f525a;margin:0 0 3px 0">' . $segment['departureAirportData']['code'] . '</div>
                                                                <div style="font-size:11px;color:#4a4a4a;margin:0">' . date('d-M-Y h:i A', strtotime($segment['departure']['at'])) . '</div>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td style="font-family:Arial,Helvetica,sans-serif;font-size:11px;font-weight:normal;color:#4f525a;line-height:14px;border-top:1px solid #e7e7e7;padding-top:5px">' . $segment['departureAirportData']['airport_name'];
                        if (isset($segment['departure']['terminal'])) {
                            $flightDetails .= '<br/>' . $languageCommon[$languageCode]['terminal'] . ': ' . $segment['departure']['terminal'];
                        }
                        $flightDetails .= '</td>
                                                            </tr>
                                                            </tbody>
                                                            </table>
                                                        </td>
                                                        <td style="padding-left:7px;padding-right:7px" valign="top" width="20%">
                                                            <div style="margin:0 0 5px;text-align:center"><img alt="" height="12" src="https://webview.rehlte.com/assets/img/duration.jpg" style="display:block;width:56px;margin:0 auto;height:12px" width="56" class="CToWUd" data-bit="iit"></div>
                                                            <div style="color:#898b91;font-size:11px;margin:0;text-align:center">' . $segment['durationText'] . '</div>
                                                        </td>
                                                        <td style="padding-right:10px" valign="top" width="40%">
                                                            <table border="0" cellpadding="0" cellspacing="0" width="100%">
                                                            <tbody>
                                                            <tr>
                                                                <td style="font-family:Arial,Helvetica,sans-serif;font-size:14px;font-weight:normal;color:#4a4a4a;line-height:18px;padding:0 0px 10px 0">
                                                                <div style="font-weight:bold;color:#000000;margin:0 0 3px 0;text-align:right">' . $segment['arrivalAirportData']['city_name'] . '</div>
                                                                <div style="font-size:16px;color:#4f525a;margin:0 0 3px 0;text-align:right">' . $segment['arrivalAirportData']['code'] . ' </div>
                                                                <div style="font-size:11px;color:#4a4a4a;margin:0;text-align:right">' . date('d-M-Y h:i A', strtotime($segment['arrival']['at'])) . '</div>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                            <td style="font-family:Arial,Helvetica,sans-serif;font-size:11px;font-weight:normal;color:#4f525a;line-height:14px;border-top:1px solid #e7e7e7;padding-top:5px">' . $segment['arrivalAirportData']['airport_name'];
                        if (isset($segment['arrival']['terminal'])) {
                            $flightDetails .= '<br/>' . $languageCommon[$languageCode]['terminal'] . ': ' . $segment['arrival']['terminal'];
                        }
                        $flightDetails .= '</td>
                                                            </tr>
                                                            </tbody>
                                                            </table>
                                                        </td>
                                                    </tr>
                                                    </tbody>
                                                    </table>
                                                </td>
                                            </tr>
                                            </tbody>
                                            </table>';
                        // Add layover row only if not last segment
                        if ($skey < count($flight['segments']) - 1) {
                            $nextSegment = $flight['segments'][$skey + 1];

                            $layoverArrival = new \DateTime($segment['arrival']['at'] ?? null);
                            $nextDeparture = new \DateTime($nextSegment['departure']['at'] ?? null);

                            if ($layoverArrival && $nextDeparture) {
                                $layoverDuration = $layoverArrival->diff($nextDeparture);
                                $layoverText = $layoverDuration->format('%h hrs %i mins');

                                $city = $segment['arrivalAirportData']['city_name'] ?? '';
                                $country = $segment['arrivalAirportData']['country_name'] ?? '';

                                $flightDetails .= '
        <tr>
            <td colspan="6" style="text-align: center; font-size: 0.9em; color: #555; padding: 8px; font-family:Arial,Helvetica,sans-serif; border-top:1px solid #e7e7e7;">
                ' . $languageCommon[$languageCode]['layover_at']. ' ' . $city . ', ' . $country . ' (' . $layoverText . ')
            </td>
        </tr>';
                            }
                        }
                    }
                    $flightDetails .= '
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="background-color:#fcfcfc;padding:15px 16px;border-top:1px solid #e7e7e7;border-bottom-left-radius:8px;border-bottom-right-radius:8px">
                                            <table border="0" cellpadding="0" cellspacing="0" width="100%">
                                            <tbody>
                                            <tr>
                                                <td style="font-size:14px;color:#222;text-transform:uppercase;width:230px;padding-bottom:10px" valign="top">'.$languageCommon[$languageCode]['travellers'].'</td>
                                            </tr>' . $travelers . '
                                            </tbody>
                                            </table>
                                        </td>
                                    </tr>
                                    </tbody>
                                    </table>
                                </td>
                            </tr>
                            </tbody>
                            </table>
                        </td>
                    </tr>
                    ';
                }

                $json_ld = [
                    "@context" => "http://schema.org",
                    "@type" => "FlightReservation",
                    "reservationNumber" => $bookingRef,
                    "reservationStatus" => "http://schema.org/Confirmed",
                    "underName" => [
                        "@type" => "Person",
                        "name" => $name ?? '',
                        "email" => $bookingDetails['email'] ?? ''
                    ],
                    "reservationFor" => [
                        "@type" => "Flight",
                        "flightNumber" => $bookingPayloadDetails['flightDetails']['airlines'][0]['flights'][0]['segments'][0]['carrierCode'] . ($bookingPayloadDetails['flightDetails']['airlines'][0]['flights'][0]['segments'][0]['number'] ?? ''),
                        "airline" => [
                            "@type" => "Airline",
                            "name" => $bookingPayloadDetails['flightDetails']['airlines'][0]['name'] ?? '',
                            "iataCode" => $bookingPayloadDetails['flightDetails']['airlines'][0]['code'] ?? ''
                        ],
                        "departureAirport" => [
                            "@type" => "Airport",
                            "name" => $bookingPayloadDetails['flightDetails']['airlines'][0]['flights'][0]['segments'][0]['departureAirportData']['airport_name'] ?? '',
                            "iataCode" => $bookingPayloadDetails['flightDetails']['airlines'][0]['flights'][0]['segments'][0]['departureAirportData']['code'] ?? ''
                        ],
                        "arrivalAirport" => [
                            "@type" => "Airport",
                            "name" => $bookingPayloadDetails['flightDetails']['airlines'][0]['flights'][0]['segments'][0]['arrivalAirportData']['airport_name'] ?? '',
                            "iataCode" => $bookingPayloadDetails['flightDetails']['airlines'][0]['flights'][0]['segments'][0]['arrivalAirportData']['code'] ?? ''
                        ],
                        "departureTime" => $bookingPayloadDetails['flightDetails']['airlines'][0]['flights'][0]['segments'][0]['departure']['at'] ?? '',
                        "arrivalTime" => $bookingPayloadDetails['flightDetails']['airlines'][0]['flights'][0]['segments'][0]['arrival']['at'] ?? ''
                    ]
                ];

                $structuredData = '<script type="application/ld+json">' . json_encode($json_ld, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT) . '</script>';


                $searchArray = array_merge($searchArray, [
                    '{{structuredData}}',
                    '{{bookingFromTo}}',
                    '{{pnr}}',
                    '{{flightRoute}}',
                    '{{flightDetails}}',
                    
                    
                ]);
               $replaceArray = array_merge($replaceArray, [
                    $structuredData,
                    $bookingFromTo,
                    $bookingDetails['supplier_booking_associated_ref'],
                    $flightRoutesByLanguage[$languageCode][$flightRoute],
                    $flightDetails,
                   
                ]);



                $subject = str_replace(['{{bookingRef}}', '{{agencyName}}'], [$bookingRef, $agencyName], $templateDetails['subject']);
                break;
            case EnumsServiceType::Hotel->value:
                if ($serviceProvider == 'HOTEL_BEDS') {
                    $hotelName = $bookingPayloadDetails['hotelDetails']['hotelDetails']['name']['content'];
                    $checkIn = strtotime($bookingPayloadDetails['searchDetails']['stay']['checkIn']);
                    $checkOut = strtotime($bookingPayloadDetails['searchDetails']['stay']['checkOut']);
                    $nightsStay = round(($checkOut - $checkIn) / 86400);
                    $currency = $bookingDetails['customer_currency'] ?? '';
                    $totalPrice = $currency  . ' ' . $bookingPayloadDetails['processedPrice']['grandTotal'] ?? '';
                    if ($nightsStay > 1) {
                        $nightsStay .= '-' . $languageCommon[$languageCode]['nights'];
                    } else {
                        $nightsStay .= '-' . $languageCommon[$languageCode]['night'];
                    }
                    $checkInDay = date('D', $checkIn);
                    $checkInDate1 = date('d M', $checkIn);
                    $checkInDate2 = date('Y', $checkIn);
                    $checkOutDay = date('D', $checkOut);
                    $checkOutDate1 = date('d M', $checkOut);
                    $checkOutDate2 = date('Y', $checkOut);
                    $stayDates = $checkInDay . ', ' . $checkInDate1 . ' - ' . $checkOutDay . ', ' . $checkOutDate1;
                    $noOfRooms = $noOfAdults = $noOfChildren = $noOfPersons = 0;
                    foreach ($bookingPayloadDetails['searchDetails']['occupancies'] as $occupancy) {
                        $noOfRooms += $occupancy['rooms'];
                        $noOfAdults += $occupancy['adults'];
                        $noOfChildren += $occupancy['children'];
                    }
                    if ($noOfRooms > 1) {
                        $noOfRooms .= ' ' . $languageCommon[$languageCode]['rooms'];
                    } else {
                        $noOfRooms .= ' ' . $languageCommon[$languageCode]['room'];
                    }
                    $noOfGuests = $noOfAdults + $noOfChildren;
                    if ($noOfGuests > 1) {
                        $noOfGuests .= ' ' . $languageCommon[$languageCode]['guests'];
                    } else {
                        $noOfGuests .= ' ' . $languageCommon[$languageCode]['guest'];
                    }
                    $noOfPersons = '';
                    if ($noOfAdults > 1) {
                        $noOfPersons .= $noOfAdults . ' ' . $adultChildrenByLanguage[$languageCode]['adults'];
                    } else {
                        $noOfPersons .= $noOfAdults . ' ' . $adultChildrenByLanguage[$languageCode]['adult'];
                    }
                    if ($noOfChildren > 0) {
                        $noOfPersons .= ', ' . $noOfChildren . ' ' . $adultChildrenByLanguage[$languageCode]['children'];
                    }

                    $hotelDetails = $bookingPayloadDetails['hotelDetails']['hotelDetails'];
                    $selectedRooms = $bookingPayloadDetails['hotelDetails']['selectedRooms'];
                    $roomNameBoardDetails = [];
                    foreach ($hotelDetails['rooms'] as $key => $room) {
                        foreach ($room['rates'] as $rate) {
                            $roomNameBoardDetails[$rate['rateKey']] = [
                                'roomName' => ucwords($room['name']),
                                'boardCode' => $rate['boardCode'],
                                'boardName' => $rate['boardName'],
                            ];
                        }
                    }
                    $roomName = $boardName = $rateComments = '';
                    foreach ($selectedRooms['rooms'] as $key => $selectedRoom) {
                        $roomName = $roomNameBoardDetails[$selectedRoom['rateKey']]['roomName'];
                        $boardName = $roomNameBoardDetails[$selectedRoom['rateKey']]['boardName'];
                        if (isset($selectedRoom['rateComments'])) {
                            $rateComments = str_replace(' .  ', '&nbsp;&#x2022;&nbsp;&nbsp;', $selectedRoom['rateComments']);
                        }
                    }
                    $hotelAddress = $hotelDetails['address']['content'] . ',<br/>' . $hotelDetails['city']['content'] . ', ' . $hotelDetails['state']['name'] . ', ' . $hotelDetails['country']['description']['content'];
                    $hotelEmail = '';
                    if (isset($hotelDetails['email'])) {
                        $hotelEmail = $hotelDetails['email'];
                    }
                    $hotelPhoneNumber = '';
                    if (isset($hotelDetails['phones']) && is_array($hotelDetails['phones'])) {
                        foreach ($hotelDetails['phones'] as $key => $phone) {
                            if ($key != 0) {
                                $hotelPhoneNumber .= ', ';
                            }
                            $hotelPhoneNumber .= ucfirst(strtolower($phone['phoneType'])) . ': ' . $phone['phoneNumber'];
                        }
                    }

                    $searchArray = array_merge($searchArray, [
                        '{{hotelName}}',
                        '{{hotelAddress}}',
                        '{{hotelPhoneNumber}}',
                        '{{hotelEmail}}',
                        '{{nightsStay}}',
                        '{{stayDates}}',
                        '{{noOfRooms}}',
                        '{{noOfGuests}}',
                        '{{noOfPersons}}',
                        '{{checkInDay}}',
                        '{{checkInDate1}}',
                        '{{checkInDate2}}',
                        '{{checkOutDay}}',
                        '{{checkOutDate1}}',
                        '{{checkOutDate2}}',
                        '{{roomName}}',
                        '{{boardName}}',
                        '{{rateComments}}',

                    ]);
                    $replaceArray = array_merge($replaceArray, [
                        $hotelName,
                        $hotelAddress,
                        $hotelPhoneNumber,
                        $hotelEmail,
                        $nightsStay,
                        $stayDates,
                        $noOfRooms,
                        $noOfGuests,
                        $noOfPersons,
                        $checkInDay,
                        $checkInDate1,
                        $checkInDate2,
                        $checkOutDay,
                        $checkOutDate1,
                        $checkOutDate2,
                        $roomName,
                        $boardName,
                        $rateComments,

                    ]);
                } elseif ($serviceProvider == 'GIMMONIX') {

                    $hotelName = $bookingPayloadDetails['hotelDetails']['hotelDetails']['DisplayName'] ?? '';
                    $checkIn = strtotime($bookingPayloadDetails['searchDetails']['stay']['checkIn'] ?? '');
                    $checkOut = strtotime($bookingPayloadDetails['searchDetails']['stay']['checkOut'] ?? '');

                    $nightsStay = round(($checkOut - $checkIn) / 86400);
                    if ($nightsStay > 1) {
                        $nightsStay .= '-' . $languageCommon[$languageCode]['nights'] ?? '';
                    } else {
                        $nightsStay .= '-' . $languageCommon[$languageCode]['night'] ?? '';
                    }
                    $checkInDay = date('D', $checkIn) ?? '';
                    $checkInDate1 = date('d M', $checkIn) ?? '';
                    $checkInDate2 = date('Y', $checkIn) ?? '';
                    $checkOutDay = date('D', $checkOut) ?? '';
                    $checkOutDate1 = date('d M', $checkOut) ?? '';
                    $checkOutDate2 = date('Y', $checkOut) ?? '';
                    $stayDates = $checkInDay . ', ' . $checkInDate1 . ' - ' . $checkOutDay . ', ' . $checkOutDate1;
                    $noOfRooms = $noOfAdults = $noOfChildren = $noOfPersons = 0;
                    foreach ($bookingPayloadDetails['searchDetails']['occupancies'] as $occupancy) {
                        $noOfRooms += $occupancy['rooms'];
                        $noOfAdults += $occupancy['adults'];
                        $noOfChildren += $occupancy['children'];
                    }
                    if ($noOfRooms > 1) {
                        $noOfRooms .= ' ' . $languageCommon[$languageCode]['rooms'];
                    } else {
                        $noOfRooms .= ' ' . $languageCommon[$languageCode]['room'];
                    }
                    $noOfGuests = $noOfAdults + $noOfChildren;
                    if ($noOfGuests > 1) {
                        $noOfGuests .= ' ' . $languageCommon[$languageCode]['guests'];
                    } else {
                        $noOfGuests .= ' ' . $languageCommon[$languageCode]['guest'];
                    }
                    $noOfPersons = '';
                    if ($noOfAdults > 1) {
                        $noOfPersons .= $noOfAdults . ' ' . $adultChildrenByLanguage[$languageCode]['adults'];
                    } else {
                        $noOfPersons .= $noOfAdults . ' ' . $adultChildrenByLanguage[$languageCode]['adult'];
                    }
                    if ($noOfChildren > 0) {
                        $noOfPersons .= ', ' . $noOfChildren . ' ' . $adultChildrenByLanguage[$languageCode]['children'];
                    }

                    $hotelDetails = $bookingPayloadDetails['hotelDetails']['hotelDetails'] ?? '';
                    $selectedRooms = $bookingPayloadDetails['hotelDetails']['selectedRooms'] ?? '';
                    $roomName = $bookingPayloadDetails['hotelDetails']['selectedRooms']['RoomName'] ?? '';
                    $boardName = $bookingPayloadDetails['hotelDetails']['selectedRooms']['RoomBasis'] ?? '';
                    $rateComments = $bookingPayloadDetails['hotelDetails']['selectedRooms']['Remarks'][0] ?? '';
                    $hotelAddress = $bookingPayloadDetails['hotelDetails']['hotelDetails']['Address'] ?? '';
                    $hotelEmail = '';
                    $hotelPhoneNumber = '';
                    // if (isset($hotelDetails['email'])) {
                    //     $hotelEmail = $hotelDetails['email'];
                    // }
                    // if (isset($hotelDetails['phones']) && is_array($hotelDetails['phones'])) {
                    //     foreach($hotelDetails['phones'] as $key => $phone) {
                    //         if ($key != 0) {
                    //             $hotelPhoneNumber .= ', ';
                    //         }
                    //         $hotelPhoneNumber .= ucfirst(strtolower($phone['phoneType'])).': '.$phone['phoneNumber'];
                    //     }
                    // }

                    $searchArray = array_merge($searchArray, [
                        '{{hotelName}}',
                        '{{hotelAddress}}',
                        '{{hotelPhoneNumber}}',
                        '{{hotelEmail}}',
                        '{{nightsStay}}',
                        '{{stayDates}}',
                        '{{noOfRooms}}',
                        '{{noOfGuests}}',
                        '{{noOfPersons}}',
                        '{{checkInDay}}',
                        '{{checkInDate1}}',
                        '{{checkInDate2}}',
                        '{{checkOutDay}}',
                        '{{checkOutDate1}}',
                        '{{checkOutDate2}}',
                        '{{roomName}}',
                        '{{boardName}}',
                        '{{rateComments}}',

                    ]);
                    $replaceArray = array_merge($replaceArray, [
                        $hotelName,
                        $hotelAddress,
                        $hotelPhoneNumber,
                        $hotelEmail,
                        $nightsStay,
                        $stayDates,
                        $noOfRooms,
                        $noOfGuests,
                        $noOfPersons,
                        $checkInDay,
                        $checkInDate1,
                        $checkInDate2,
                        $checkOutDay,
                        $checkOutDate1,
                        $checkOutDate2,
                        $roomName,
                        $boardName,
                        $rateComments,

                    ]);
                }
                $subject = str_replace(['{{hotelName}}'], [$hotelName], $templateDetails['subject']);
                break;
        }

        $mailContent = str_replace($searchArray, $replaceArray, $templateDetails['mailData']);


        return [
            'subject' => $subject,
            'mailContent' => $mailContent,
        ];
    }
    public function sendBookingEmail($bookingDetails)
    {
        $result = [
            'success' => false,
            'message' => 'An error occurred while sending the booking email.',
        ];

        try {
            $bookingType = $bookingDetails['booking_type'] ?? null;
            $bookingCode = $bookingType === EnumsServiceType::Flight->value
                ? 'BOOKING_CONFIRMATION'
                : ($bookingType === EnumsServiceType::Hotel->value ? 'HOTEL_BOOKING_CONFIRMATION' : null);

            if (!$bookingCode) {
                $result['message'] = 'Invalid booking type.';
                return $result;
            }

            $agencyName = Setting::where('config_key', 'general|basic|siteName')->value('value') ?? 'Rehlte';

            // Fetch email template
            $languageCode = $bookingDetails['customer_language_code'] ?? Locale::English->value;
            $getCreateBookingTemplateData = EmailService::createBookingMailTemplate($bookingCode, $languageCode);

            // Log the response for debugging
            // Log::info('Template Response:', ['response' => $getCreateBookingTemplateData]);

            if (!isset($getCreateBookingTemplateData['status']) || $getCreateBookingTemplateData['status'] === 'false') {
                $result['message'] = $getCreateBookingTemplateData['error'] ?? 'Template data not found.';
                // return $result;
            }

            $toEmail = $bookingDetails['email'] ?? null;
            if (!$toEmail) {
                $result['message'] = 'Recipient email not provided.';
                return $result;
            }

            $processedEmailContent = $this->processBookingEmailContent(
                $getCreateBookingTemplateData['data'],
                $bookingDetails,
                $agencyName
            );

            $mailSubject = $processedEmailContent['subject'] ?? 'Booking Confirmation';
            $mailContent = $processedEmailContent['mailContent'] ?? '';
            if (!$mailContent) {
                $result['message'] = 'Processed email content is empty.';
                return $result;
            }

            if ($bookingDetails['booking_type'] == EnumsServiceType::Hotel->value || $bookingDetails['booking_type'] == EnumsServiceType::Hotel->value) {
                // Generate PDF
                $pdfFilePath = storage_path("app/public/{$bookingDetails['booking_ref']}.pdf");
                // $pdfUrl = url("/api/v1/booking/show_voucher/{$bookingDetails['id']}");
                $pdfUrl = env('API_BASE_URL') ."booking/show_voucher/{$bookingDetails['id']}/{$languageCode}";
                $cmd = "wkhtmltopdf $pdfUrl $pdfFilePath 2>&1";
                exec($cmd);
            } elseif ($bookingDetails['booking_type'] == EnumsServiceType::Flight->value || strtolower(EnumsServiceType::Flight->value)) {

                // Generate PDF
                $pdfFilePath = storage_path("app/public/{$bookingDetails['booking_ref']}.pdf");
                // $pdfUrl = url("/api/v1/booking/showFlightTicket/{$bookingDetails['id']}");
                $pdfUrl = env('API_BASE_URL') ."booking/showFlightTicket/{$bookingDetails['id']}/{$languageCode}";
                $cmd = "wkhtmltopdf $pdfUrl $pdfFilePath 2>&1";
                exec($cmd);
            }


            if (!file_exists($pdfFilePath)) {
                $result['message'] = 'Failed to generate booking PDF.';
                return $result;
            }

            // Send email
            $emailResponse = EmailService::sendEmail($toEmail, $mailSubject, $mailContent, [$pdfFilePath], $agencyName);

            // Log the response for debugging
            Log::info('Email Response:', ['response' => $emailResponse]);

            if (isset($emailResponse['status']) && $emailResponse['status'] === 'true') {
                $result['success'] = true;
                $result['message'] = 'Booking email sent successfully!';
            } else {
                $result['message'] = $emailResponse['error'] ?? 'Failed to send the booking email.';
            }
        } catch (Exception $e) {
            $result['message'] = 'An exception occurred: ' . $e->getMessage();
        }

        return $result;
    }



    public function sendBookingWhatsapp($bookingDetails)
    {
        $isdMobile = $bookingDetails['phone_country_code'] . $bookingDetails['phone'];
        $serviceProvider = $bookingDetails['service_provider'];
        $bookingAdditionalDetails = BookingAdditionalDetail::where('booking_id', $bookingDetails['id'])->select('booking_details')->first();
        $bookingPayloadDetails = json_decode($bookingAdditionalDetails['booking_details'], true);
        $customerLanguageCode = $bookingDetails['customer_language_code'] ?? Locale::English->value;

        if ($bookingDetails['booking_type'] == EnumsServiceType::Flight->value) {
            $bookingFrom = $bookingTo = $flightNo = $journeyDate = $journeyTime = $pnr = $totalPassengers = '';

            foreach ($bookingPayloadDetails['flightDetails']['airlines'][0]['flights'] as $key => $flight) {
                if ($key == 0) {
                    $bookingFrom = $flight['departureAirportData']['city_name'];
                    $flightNo = $flight['segments'][0]['aircraftData']['name'] . ' (' . $flight['segments'][0]['airlineData']['name'] . ')';
                    if ($bookingDetails['additional_details'] != 'multicity') {
                        $bookingTo = $flight['arrivalAirportData']['city_name'];
                    }
                    $journeyDateTime = $flight['segments'][0]['departure']['at'];
                    $journeyDate = date('d-M-Y', strtotime($journeyDateTime));
                    $journeyTime = date('H:i', strtotime($journeyDateTime));
                }
                // if ($key > 0 && $bookingTo != '') {

                // $bookingTo = $flight['arrivalAirportData']['city_name'];
                // }
            }
            $bookingFrom =  $bookingPayloadDetails['searchDetails']['originDestinations'][0]['originLocationCode'] ?? '';
            $bookingTo = $bookingPayloadDetails['searchDetails']['originDestinations'][0]['destinationLocationCode'] ?? '';
            // $pnr = $bookingDetails['supplier_booking_associated_ref'];
            $totalPassengers = count($bookingPayloadDetails['passengerDetails']);
            $additionalbookingDetails = BookingAdditionalDetail::where('booking_id', $bookingDetails['id'])->first();
            $pnrDetails = json_decode($additionalbookingDetails->service_provider_booking_response, true) ?? [];
            $airlinePnr = $gdsPnr = [];
            if (!empty($pnrDetails)) {
                $bookingData['pnrDetails'] =  $pnrDetails['data']['associatedRecords'] ?? [];
                foreach ($bookingData['pnrDetails'] as $record) {
                    if ($record['originSystemCode'] === 'GDS') {
                        $gdsPnr[] = $record['reference'];
                    } else {
                        $airlinePnr[] = $record['reference'];
                    }
                }
            }

            if (is_array($airlinePnr)) {
                $pnr = implode(', ', array_filter(array_map('trim', $airlinePnr)));
            } elseif (!empty($airlinePnr)) {
                $pnr = implode(', ', array_filter(array_map('trim', explode(',', $airlinePnr))));
            } else {
                $pnr = 'N/A';
            }
            $WhatsTemplateCode = 'flight_booking_conf_temp';
            $searchArray = [
                '{{bookingFrom}}',
                '{{bookingTo}}',
                '{{flightNo}}',
                '{{journeyDate}}',
                '{{journeyTime}}',
                '{{pnr}}',
                '{{totalPassengers}}'
            ];
            // if (!$pnr) {
            //     $pnr = "PNR-SYHHFU";
            // }
            $booking_id = $bookingDetails['booking_ref'];
            $replaceArray = [
                $flightNo,
                $journeyDate,
                $booking_id,
                $pnr,
                $bookingFrom . ' → ' . $bookingTo,
                $WhatsTemplateCode,
                $isdMobile,
            ];
        } elseif ($bookingDetails['booking_type'] == EnumsServiceType::Hotel->value) {
            if ($serviceProvider == 'HOTEL_BEDS') {
                $hotelName = $bookingPayloadDetails['hotelDetails']['hotelDetails']['name']['content'] ?? '';
                $city = $bookingPayloadDetails['hotelDetails']['hotelDetails']['destination']['name']['content']  ?? '';
            } elseif ($serviceProvider == 'GIMMONIX') {
                $hotelName = $bookingPayloadDetails['hotelDetails']['hotelDetails']['DisplayName'] ?? '';
                $city = $bookingPayloadDetails['searchDetails']['city'] ?? '';
            }
            $totalAdults = $totalChildren = 0;
            $checkInDate = date('d-M-Y', strtotime($bookingPayloadDetails['searchDetails']['stay']['checkIn']));
            $checkOutDate = date('d-M-Y', strtotime($bookingPayloadDetails['searchDetails']['stay']['checkOut']));
            $bookingReference = $bookingDetails['booking_ref'];
            foreach ($bookingPayloadDetails['searchDetails']['occupancies'] as $occupancy) {
                $totalAdults += $occupancy['adults'];
                $totalChildren += $occupancy['children'];
            }

            $WhatsTemplateCode = 'hotel_booking_confirmed';
            $searchArray = [
                '{{hotelName}}',
                '{{city}}',
                '{{checkInDate}}',
                '{{checkOutDate}}',
                '{{bookingReference}}',
                '{{totalAdults}}',
                '{{totalChildren}}',
            ];
            $replaceArray = [
                $hotelName,
                $city,
                $checkInDate,
                $checkOutDate,
                $bookingReference,
                $WhatsTemplateCode,
                $isdMobile
            ];
        }

        return  $this->sendWhatsappmessage($replaceArray, $customerLanguageCode);
    }

    public function sendBookingSms($bookingDetails)
    {
        $isdMobile = $bookingDetails['phone_country_code'] . $bookingDetails['phone'];
        $serviceProvider = $bookingDetails['service_provider'];
        $bookingAdditionalDetails = BookingAdditionalDetail::where('booking_id', $bookingDetails['id'])->select('booking_details')->first();
        $bookingPayloadDetails = json_decode($bookingAdditionalDetails['booking_details'], true);

        $smsMessage = '';
        if ($bookingDetails['booking_type'] == EnumsServiceType::Flight->value) {
            $bookingFrom = $bookingTo = $flightNo = $journeyDate = $journeyTime = $pnr = $totalPassengers = '';
            foreach ($bookingPayloadDetails['flightDetails']['airlines'][0]['flights'] as $key => $flight) {
                if ($key == 0) {
                    $bookingFrom = $flight['departureAirportData']['code'];
                    $airlineName = $flight['airline']['name'] ?? '';
                    $flightNo = $flight['segments'][0]['aircraftData']['name'] . ' (' . $flight['segments'][0]['airlineData']['name'] . ')';
                    if ($bookingDetails['additional_details'] != 'multicity') {
                        $bookingTo = $flight['arrivalAirportData']['city_name'];
                    }
                    $journeyDateTime = $flight['segments'][0]['departure']['at'];
                    $journeyDate = date('d-M-Y', strtotime($journeyDateTime));
                    $journeyTime = date('H:i', strtotime($journeyDateTime));
                }
                if ($key > 0 && $bookingTo != '') {
                    $bookingTo = $flight['arrivalAirportData']['code'];
                }
            }
            $pnr = $bookingDetails['supplier_booking_associated_ref'];
            $totalPassengers = count($bookingPayloadDetails['passengerDetails']);
            $ticketNo = '';
            $bookingReference = $bookingDetails['booking_ref'];
            $additionalbookingDetails = BookingAdditionalDetail::where('booking_id', $bookingDetails['id'])->first();
            $pnrDetails = json_decode($additionalbookingDetails->service_provider_booking_response, true) ?? [];
            $airlinePnr = $gdsPnr = [];
            if (!empty($pnrDetails)) {
                $bookingData['pnrDetails'] =  $pnrDetails['data']['associatedRecords'] ?? [];
                foreach ($bookingData['pnrDetails'] as $record) {
                    if ($record['originSystemCode'] === 'GDS') {
                        $gdsPnr[] = $record['reference'];
                    } else {
                        $airlinePnr[] = $record['reference'];
                    }
                }
            }

            if (is_array($airlinePnr)) {
                $pnr = implode(', ', array_filter(array_map('trim', $airlinePnr)));
            } elseif (!empty($airlinePnr)) {
                $pnr = implode(', ', array_filter(array_map('trim', explode(',', $airlinePnr))));
            } else {
                $pnr = 'N/A';
            }

            $smsTemplateCode = 'FLIGHT_BOOKING_CONFIRMATION';
            $searchArray = [
                '{{airlineName}}',
                '{{bookingFrom}}',
                '{{bookingTo}}',
                '{{journeyDate}}',
                '{{journeyTime}}',
                '{{pnr}}',
                '{{totalPassengers}}',
                '{{ticketNo}}',
                '{{bookingReference}}',
            ];
            $replaceArray = [
                $airlineName,
                $bookingFrom,
                $bookingTo,
                $journeyDate,
                $journeyTime,
                $pnr,
                $totalPassengers,
                $ticketNo,
                $bookingReference
            ];
        } elseif ($bookingDetails['booking_type'] == EnumsServiceType::Hotel->value) {
            $roomType = $roomCount = '';
            if ($serviceProvider == 'HOTEL_BEDS') {
                $hotelName = $bookingPayloadDetails['hotelDetails']['hotelDetails']['name']['content'];
                $city = $bookingPayloadDetails['hotelDetails']['hotelDetails']['destination']['name']['content'];
            } elseif ($serviceProvider == 'GIMMONIX') {
                $hotelName = $bookingPayloadDetails['hotelDetails']['hotelDetails']['DisplayName'] ?? '';
                $city = $bookingPayloadDetails['searchDetails']['city'] ?? '';
                $roomType = $bookingPayloadDetails['hotelDetails']['selectedRooms']['RoomBasis'] ?? '' . ' | ' . $bookingPayloadDetails['hotelDetails']['selectedRooms']['RoomType'] ?? '';
                $roomCount = count($bookingPayloadDetails['searchDetails']['occupancies']);
            }
            $totalAdults = $totalChildren = 0;
            $checkInDate = date('d-M-Y', strtotime($bookingPayloadDetails['searchDetails']['stay']['checkIn']));
            $supplierReference = $bookingDetails['supplier_booking_associated_ref'];
            $bookingReference = $bookingDetails['booking_ref'];
            foreach ($bookingPayloadDetails['searchDetails']['occupancies'] as $occupancy) {
                $totalAdults += $occupancy['adults'];
                $totalChildren += $occupancy['children'];
            }

            $smsTemplateCode = 'HOTEL_BOOKING_CONFIRMATION';
            $searchArray = [
                '{{hotelName}}',
                '{{city}}',
                '{{checkInDate}}',
                '{{bookingReference}}',
                '{{supplierReference}}',
                '{{totalAdults}}',
                '{{totalChildren}}',
                '{{roomType}}',
                '{{roomCount}}'
            ];
            $replaceArray = [
                $hotelName,
                $city,
                $checkInDate,
                $bookingReference,
                $supplierReference,
                $totalAdults,
                $totalChildren,
                $roomType,
                $roomCount
            ];
        }

        if ($smsTemplateCode != '') {
            $smsTemplateId = SmsTemplate::where('code', $smsTemplateCode)->value('id');
            $smsTemplateContent = SmsTemplateI18ns::where('sms_id', $smsTemplateId)->where('language_code', $bookingDetails['customer_language_code'])->value('content');
            $replaceArray;
            $smsMessage = str_replace($searchArray, $replaceArray, $smsTemplateContent);
            return $this->sendSms($isdMobile, $smsMessage);
        }
        return false;
    }

    public function getPaymentData($amount, $paymentBrand, $paymentId, $bookingId)
    {
        $isCapturePayment = $this->isCapturePayment($paymentBrand);
        return [
            'payment_id' => $paymentId,
            'booking_id' => $bookingId,
            'amount' => $amount,
            'payment_type' => '',
            'payment_brand' => $paymentBrand,
            'payment_status' => '',
            'payment_flow' => '',
            'debit' => 'false',
            'debit_id' => '',
            'debit_code' => '',
            'debit_description' => '',
            'debit_response' => '',
            'pre_authorization' => 'false',
            'pre_authorization_id' => '',
            'pre_authorization_code' => '',
            'pre_authorization_description' => '',
            'pre_authorization_response' => '',
            'capture' => 'false',
            'capture_id' => '',
            'capture_code' => '',
            'capture_description' => '',
            'capture_response' => '',
            'revert' => 'false',
            'revert_id' => '',
            'revert_code' => '',
            'revert_description' => '',
            'revert_response' => '',
            'is_capture_payment' => $isCapturePayment,
            'payment_flow' => (($isCapturePayment) ? 'CP' : 'DB')
        ];
    }

    public function updatePaymentData($type, $status, $paymentData, $paymentResponse, $initialUpdate = false)
    {
        if ($initialUpdate) {
            if (array_key_exists('amount', $paymentResponse)) {
                $paymentData['amount'] = $paymentResponse['amount'];
            } else {
                $paymentData['amount'] = 0;
            }
            $paymentData['payment_type'] = $paymentResponse['paymentType'] ?? '';
            $paymentData['payment_brand'] = $paymentResponse['paymentBrand'] ?? '';
        }
        $paymentData[$type] = $status;
        $paymentData[$type . '_id'] = ($status) ? $paymentResponse['id'] : '';
        $paymentData[$type . '_code'] = $paymentResponse['result']['code'];
        $paymentData[$type . '_description'] = $paymentResponse['result']['description'];
        $paymentData[$type . '_response'] = json_encode($paymentResponse);

        return $paymentData;
    }

    public function processPaymentData($paymentData)
    {
        if ($paymentData['payment_flow'] == 'CP') {
            if ($paymentData['revert'] == 'true') {
                $paymentData['payment_status'] = 'Reverted';
            } elseif ($paymentData['capture'] == 'true') {
                $paymentData['payment_status'] = 'Captured';
            } else {
                $paymentData['payment_status'] = 'PreAuthorized';
            }
        } else {
            if ($paymentData['revert'] == 'true') {
                $paymentData['payment_status'] = 'Reverted';
            } else {
                $paymentData['payment_status'] = 'Debited';
            }
        }
        return $paymentData;
    }

    public function validateBookingDetails($requestData)
    {
        return [
            'status' => 'true',
            'message' => ''
        ];
    }

    public function getCheckoutPayload($paymentBrand, $amount, $bookingDetails)
    {
        $paymentPayload = [
            'paymentBrand' => $paymentBrand,
            'amount' => number_format($amount, 2, '.', ''),
            'currency' => $bookingDetails['bookingDetails']['customer_currency'],
            'merchantTransactionId' => getRandomString(),
            'billing.street1' => $bookingDetails['billingDetails']['address'],
            'billing.city' => $bookingDetails['billingDetails']['city'],
            'billing.state' => $bookingDetails['billingDetails']['state'],
            'billing.country' => $bookingDetails['billingDetails']['country'],
            'billing.postcode' => $bookingDetails['billingDetails']['zipcode'],
            'customer.email' => $bookingDetails['userDetails']['emailAddress'],
        ];
        if ($bookingDetails['bookingDetails']['bookingType'] == EnumsServiceType::Flight->value) {
            $paymentPayload['customer.givenName'] = $bookingDetails['passengerDetails'][0]['first_name'];
            $paymentPayload['customer.surname'] = $bookingDetails['passengerDetails'][0]['last_name'];
        } elseif ($bookingDetails['bookingDetails']['bookingType'] == EnumsServiceType::Hotel->value) {
            $paymentPayload['customer.givenName'] = $bookingDetails['userDetails']['first_name'];
            $paymentPayload['customer.surname'] = $bookingDetails['userDetails']['last_name'];
        }
        if ($paymentBrand == 'TABBY') {
            if (env('APP_ENV') != 'production') {
                $paymentPayload['testMode'] = 'EXTERNAL';
            }
            $paymentPayload['customer.email'] = $bookingDetails['userDetails']['emailAddress'];
            $paymentPayload['customer.mobile'] = $bookingDetails['userDetails']['countryCode'] . $bookingDetails['userDetails']['mobileNumber'];
            $paymentPayload['cart.items[0].quantity'] = '1';
            $paymentPayload['cart.items[0].description'] = '';
            $paymentPayload['cart.items[0].productUrl'] = '';
            $paymentPayload['cart.items[0].price'] = $amount;
            if ($bookingDetails['bookingDetails']['bookingType'] == EnumsServiceType::Flight->value) {
                $flightCount = count($bookingDetails['flightDetails']['airlines'][0]['flights']);
                $description = $bookingDetails['flightDetails']['airlines'][0]['flights'][0]['departureAirportData']['city_name'] . '-';
                $description .= $bookingDetails['flightDetails']['airlines'][0]['flights'][$flightCount - 1]['departureAirportData']['city_name'];
                $paymentPayload['cart.items[0].name'] = $description;
                $paymentPayload['cart.items[0].sku'] = $description;
            } elseif ($bookingDetails['bookingDetails']['bookingType'] == EnumsServiceType::Hotel->value) {
                $paymentPayload['cart.items[0].name'] = $bookingDetails['hotelDetails']['hotelDetails']['name']['content'];
                $paymentPayload['cart.items[0].sku'] = $bookingDetails['hotelDetails']['hotelDetails']['code'];
            }
        }
        return $paymentPayload;
    }

    public function getHotelCheckoutPayload($paymentBrand, $amount, $currency, $bookingDetails, $refId, $bookingVia = '', $checkoutUrl = '')
    {
        $shopperResultUrl = env('BOOKING_PROCESS_URL') . '?payment_brand=' . $paymentBrand;
        $paymentPayload = [
            'paymentBrand' => $paymentBrand,
            'amount' => number_format($amount, 2, '.', ''),
            'currency' => $currency,
            'merchantTransactionId' => getRandomString(),
            'customParameters[SHOPPER_amount]' => number_format($amount, 2, '.', ''),
            'customParameters[SHOPPER_ref_id]' => $refId,
            'customParameters[SHOPPER_booking_via]' => 'web',
            'billing.street1' => $bookingDetails['billingDetails']['address'] ?? '',
            'billing.city' => $bookingDetails['billingDetails']['city'] ?? '',
            'billing.state' => $bookingDetails['billingDetails']['state'] ?? '',
            'billing.country' => $bookingDetails['billingDetails']['country'] ?? '',
            'billing.postcode' => $bookingDetails['billingDetails']['zipcode'] ?? '',
            'customer.email' => $bookingDetails['billingDetails']['customer.email'] ?? '',
            'customer.givenName' => $bookingDetails['billingDetails']['customer.givenName'] ?? '',
            'customer.surname' => $bookingDetails['billingDetails']['customer.surname'] ?? '',
        ];
        if ($bookingVia == 'web') {
            $paymentPayload['shopperResultUrl'] = $shopperResultUrl;
        }
        if ($paymentBrand == 'TABBY') {
            if (env('APP_ENV') != 'production') {
                $paymentPayload['testMode'] = 'EXTERNAL';
            }
            $paymentPayload['customer.email'] = $bookingDetails['userDetails']['email'];
            $paymentPayload['customer.mobile'] = $bookingDetails['userDetails']['phoneCode'] . $bookingDetails['userDetails']['phoneNumber'];
            $paymentPayload['cart.items[0].quantity'] = '1';
            $paymentPayload['cart.items[0].description'] = '';
            $paymentPayload['cart.items[0].productUrl'] = '';
            $paymentPayload['cart.items[0].price'] = $amount;
            $paymentPayload['cart.items[0].name'] = $bookingDetails['hotelDetails']['hotelDetails']['DisplayName'];
            $paymentPayload['cart.items[0].sku'] = $bookingDetails['hotelDetails']['hotelDetails']['ID'];
        }
        return $paymentPayload;
    }

    public function getCheckoutIdList()
    {
        return [
            'MADA' => '',
            'VISA' => '',
            'MASTER' => '',
            'AMEX' => '',
            'APPLEPAY' => '',
            'STC_PAY' => '',
            'SADAD_VA' => '',
            'TABBY' => ''
        ];
    }

    public function getRehlteRefNoDetails()
    {
        $rehlteRef = Setting::where('config_key', 'booking|rehlte_ref')->first()->toArray();
        $rehlteRefArr = explode('-', $rehlteRef['value']);
        $rehlteRefNo = $rehlteRefArr[1] + 1;
        $rehlteRefNo = $rehlteRefArr[0] . '-' . str_pad($rehlteRefNo, 7, 0, STR_PAD_LEFT);

        return [
            'id' => $rehlteRef['id'],
            'value' => $rehlteRefNo
        ];
    }

    public function getBookingProcessedPrice($requestData, $bookingType = EnumsServiceType::Flight->value, $customerId = '', $parentLogId = '')
    {
        $result = [
            'status' => 'false',
            'data' => [],
            'message' => ''
        ];
        if (isset($requestData['bookingDetails'])) {
            $supplier = $requestData['bookingDetails']['supplier'];
            $agencyId = $requestData['bookingDetails']['agencyId'];
            $languageCode = $requestData['bookingDetails']['customer_language_code'];
            $currency = $requestData['bookingDetails']['customer_currency'];
            if ($bookingType == EnumsServiceType::Hotel->value) {
                $selectedRooms = $requestData['hotelDetails']['selectedRooms']['rooms'];
            }
        } else {
            $supplier = $requestData['supplier'];
            $agencyId = $requestData['agencyId'];
            $languageCode = $requestData['languageCode'];
            $currency = $requestData['currencyCode'];
            if ($bookingType == EnumsServiceType::Hotel->value) {
                $selectedRooms = $requestData['selectedRooms']['rooms'];
            }
        }

        $supplierTypeId = Suppliers::where('code', $supplier)->value('core_service_type_id');

        //get default markup details
        $query = DefaultMarkup::where('service_type_id', $supplierTypeId)->first();

        if ($agencyId == '0') {
            $markupType = $query['b2c_markup_type'];
            $markupValue = $query['b2c_markup'];
        } else {
            $markupType = $query['b2b_markup_type'];
            $markupValue = $query['b2b_markup'];
        }

        $processedPrice = [];

        if ($bookingType == EnumsServiceType::Flight->value) {
            //
        } elseif ($bookingType == EnumsServiceType::Hotel->value) {
            $errorMessage = '';
            $travelersTotalPriceSum = $travelersBasePriceSum = $totalTaxAmount = 0;
            $fromCurrency = '';
            $generalVATPercentage = Setting::where('config_key', 'general|site|defaultVatPercentage')->get('value')[0]['value'];
            $generalServiceFee = Setting::where('config_key', 'general|site|hotelServiceFee')->get('value')[0]['value'];

            foreach ($selectedRooms as &$selectedRoom) {
                $checkRateResponse = $this->getHotelRoomRate($selectedRoom['rateKey'], $customerId, $parentLogId);
                if ($checkRateResponse['status'] == 'true') {
                    $hotelDetails = $checkRateResponse['data'];
                    $travelersBasePriceSum += $hotelDetails['totalNet'];
                    $fromCurrency = $hotelDetails['currency'];
                    $totalTax = 0;
                    if (isset($hotelDetails['rooms'][0]['rates'][0]['rateComments'])) {
                        $selectedRoom['rateComments'] = $hotelDetails['rooms'][0]['rates'][0]['rateComments'];
                    }
                    if (isset($hotelDetails['rooms'][0]['rates'][0]['taxes']) && isset($hotelDetails['rooms'][0]['rates'][0]['taxes']['taxes'])) {
                        $taxes = $hotelDetails['rooms'][0]['rates'][0]['taxes']['taxes'];
                        foreach ($taxes as $tax) {
                            if ($tax['included'] == false) {
                                $totalTax += $tax['clientAmount'];
                            }
                        }
                    }
                    $totalTaxAmount += $totalTax;
                } else {
                    $errorMessage = $checkRateResponse['message']['code'] . ': ' . $checkRateResponse['message']['message'];
                }
            }
            if ($errorMessage != '') {
                $result['message'] = $errorMessage;
            } else {
                $travelersTotalPriceSum = $travelersBasePriceSum + $totalTaxAmount;

                $convertedTotalPrice = convertCurrencyExchangeRate($travelersTotalPriceSum, $fromCurrency, $currency, $requestData);
                $convertedBasePrice = convertCurrencyExchangeRate($travelersBasePriceSum, $fromCurrency, $currency, $requestData);
                $convertedTaxAmount = convertCurrencyExchangeRate($totalTaxAmount, $fromCurrency, $currency, $requestData);
                $displayCurrency = ($languageCode == Locale::Arabic->value) ? $convertedTotalPrice['data']['symbol'] : $convertedTotalPrice['data']['toCurrencyCode'];

                //remove vat from traveler's base price
                $baseRemovedVAT = $convertedBasePrice['data']['convertedRate'] / (1 + ($generalVATPercentage / 100));
                $travelerVAT = $convertedBasePrice['data']['convertedRate'] * $generalVATPercentage / 100;

                $travelersTotalPriceSum = $convertedTotalPrice['data']['convertedRate'];
                $travelersBasePriceSum = $baseRemovedVAT;
                $totalTaxAmount = $convertedTaxAmount['data']['convertedRate'];

                $markupFee = ($markupType == 'percentage') ? $travelersTotalPriceSum * $markupValue / 100 : $markupValue;
                $markupServiceFee = $markupFee + $generalServiceFee;
                $vat = $markupServiceFee * $generalVATPercentage / 100;
                $totalInclusiveTax = $travelersTotalPriceSum  + $markupServiceFee + $vat;
                $payload = [
                    'service' => 'Hotel Booking',
                    'amount' => $totalInclusiveTax,
                    'fromCurrency' => Currency::SAR->value,
                    'toCurrency' => $currency
                ];
                $loyaltyPoints = $this->getLoyaltyPoints($payload);
                $redeemDetails = [];
                if ($customerId != '') {
                    $redeemDetails = $this->getCustomerMaxRedeemPoints($customerId, $bookingType, $currency);
                }

                $processedPrice = [
                    'currency' => $displayCurrency,
                    'markupFee' => number_format($markupFee, '2', '.', ''),
                    'serviceFee' => number_format($generalServiceFee, '2', '.', ''),
                    'markupServiceFee' => number_format($markupServiceFee, '2', '.', ''),
                    'vatPercentage' => $generalVATPercentage,
                    'vat' => number_format($vat, '2', '.', ''),
                    'totalPrice' => number_format($travelersTotalPriceSum, '2', '.', ''),
                    'grandTotal' => number_format($totalInclusiveTax, '2', '.', ''),
                    'markupType' => $markupType,
                    'markupValue' => $markupValue,
                    'totalTaxAmount' => $totalTaxAmount,
                    'loyaltyPoints' => $loyaltyPoints,
                    'redeemDetails' => $redeemDetails,
                    'checkRateResponse' => $checkRateResponse['data'],
                ];
                $result['status'] = 'true';
                if ($bookingType == EnumsServiceType::Hotel->value) {
                    $result['selectedRooms'] = $selectedRooms;
                }
                $result['data'] = $processedPrice;
            }
        }

        return $result;
    }

    public function getSuppliers()
    {
        $result = [];
        $suppliers = Suppliers::where('is_active', '1')->get()->toArray();
        if (count($suppliers) > 0) {
            foreach ($suppliers as $supplier) {
                $result[$supplier['id']] = $supplier['name'];
            }
        }
        return $result;
    }

    public function getServiceTypes()
    {
        $result = [];
        $serviceTypes = ServiceType::where('is_active', '1')->get()->toArray();
        if (count($serviceTypes) > 0) {
            foreach ($serviceTypes as $serviceType) {
                $result[$serviceType['id']] = $serviceType['name'];
            }
        }
        return $result;
    }

    public function getBookingRefId()
    {
        $lastBookingRefId = Bookings::where('created_at', '>=', Carbon::today())
            ->orderBy('created_at', 'DESC')
            ->take(1)
            ->value('booking_ref');
        if ($lastBookingRefId) {
            $refPrefix = substr($lastBookingRefId, 0, 8);
            $refSuffix = substr($lastBookingRefId, 8, 5);
            $bookingRefId = $refPrefix . str_pad(($refSuffix + 1), 5, '0', STR_PAD_LEFT);
        } else {
            $bookingRefId = date('Ymd') . str_pad(1, 5, '0', STR_PAD_LEFT);
        }
        return $bookingRefId;
    }

    public function updateRedeemedPointsInUrl($redirectUrl, $redeemPointsUsedValue)
    {
        $redirectUrlArr =  explode("?", $redirectUrl);
        $queryStr = $redirectUrlArr[1];
        parse_str($queryStr, $queryParams);
        $queryParams['redeem_points_used'] = $redeemPointsUsedValue;
        $queryStr = http_build_query($queryParams);
        $redirectUrl = $redirectUrlArr[0] . '?' . $queryStr;
        return $redirectUrl;
    }

    public function getCreateBookingPayload($bookingDetails, $refId)
    {
        $requestPayload = ['booking_status' => BookingStatus::Pending->value];
        $isGuestBooking = ($bookingDetails['userDetails']['userId'] != '') ? false : true;
        $currencyConversionRate = CurrencyExchangeRates::where('from_currency_code', Currency::SAR->value)->where('to_currency_code', $bookingDetails['bookingDetails']['customer_currency'])->get('exchange_rate')[0]['exchange_rate'];
        switch ($bookingDetails['booking_type']) {
            case EnumsServiceType::Flight->value:
                $isOneWayCombinable = $bookingDetails['searchDetails']['isOneWayCombinable'];
                $bookingDescription = '';
                $itineraries = $bookingDetails['flightDetails']['flightInfo'][0]['itineraries'];
                $itineraryCount = count($itineraries);
                foreach ($itineraries as $itinerary) {
                    //count itineraries's count and get origin and destination code to check trip type start
                    if ($itineraryCount == 1) {
                        // Single itinerary
                        $departure = $itineraries[0]['segments'][0]['departure']['iataCode'];
                        $arrival = $itineraries[0]['segments'][count($itineraries[0]['segments']) - 1]['arrival']['iataCode'];
                        $bookingDescription =  "From $departure to $arrival (One-way)";
                    } elseif ($itineraryCount == 2) {
                        // Round-trip or multi-city
                        $firstDeparture = $itineraries[0]['segments'][0]['departure']['iataCode'];
                        if ($isOneWayCombinable == true) {
                            $secondArrival = $bookingDetails['flightDetails']['flightInfo'][1]['itineraries']['segments'][0]['departure']['iataCode'];
                        } else {
                            $secondArrival = $itineraries[1]['segments'][count($itineraries[1]['segments']) - 1]['arrival']['iataCode'];
                        }
                        if ($isOneWayCombinable == true) {
                            $bookingDescription =  "From {$itineraries[0]['segments'][0]['departure']['iataCode']} to {$itineraries[1]['segments'][0]['departure']['iataCode']} (Round-trip)";
                        } else {
                            if ($firstDeparture == $secondArrival) {
                                $bookingDescription =  "From {$firstDeparture} to {$secondArrival} (Round-trip)";
                            } else {
                                // Multi-city
                                $segments = [];
                                foreach ($itineraries as $itinerary) {
                                    foreach ($itinerary['segments'] as $segment) {
                                        $segments[] = $segment['departure']['iataCode'] . '-' . $segment['arrival']['iataCode'];
                                    }
                                }
                                $multiCityRoute = implode(' via ', $segments);
                                $bookingDescription =  "From {$itineraries[0]['segments'][0]['departure']['iataCode']} via $multiCityRoute to {$itineraries[$itineraryCount - 1]['segments'][count($itineraries[$itineraryCount - 1]['segments']) - 1]['arrival']['iataCode']} (Multi-city)";
                            }
                        }
                    } else {
                        // Multi-city
                        $segments = [];
                        foreach ($itineraries as $itinerary) {
                            foreach ($itinerary['segments'] as $segment) {
                                $segments[] = $segment['departure']['iataCode'] . '-' . $segment['arrival']['iataCode'];
                            }
                        }
                        $multiCityRoute = implode(' via ', $segments);
                        $bookingDescription =  "From {$itineraries[0]['segments'][0]['departure']['iataCode']} via $multiCityRoute to {$itineraries[$itineraryCount - 1]['segments'][count($itineraries[$itineraryCount - 1]['segments']) - 1]['arrival']['iataCode']} (Multi-city)";
                    }
                }
                $processedPrice = $bookingDetails['processedPrice'];

                //echo "<pre>"; print_r($processedPrice); print_r($bookingDetails); die;
                $bookingDate = '';
                if (array_key_exists('bookingDate', $bookingDetails['bookingDetails'])) {
                    $bookingDate = $bookingDetails['bookingDetails']['bookingDate'];
                } elseif (array_key_exists('lastTicketingDate', $bookingDetails['flightDetails']['flightInfo'][0])) {
                    $bookingDate = $bookingDetails['flightDetails']['flightInfo'][0]['lastTicketingDate'];
                }
                $requestPayload['booking_type'] = EnumsServiceType::Flight->value;
                $requestPayload['booking_start_date'] = $bookingDate;
                $requestPayload['customer_id'] = $bookingDetails['userDetails']['userId'];
                $requestPayload['is_guest'] = $isGuestBooking ? true : false;
                $requestPayload['first_name'] = $bookingDetails['passengerDetails'][0]['first_name'];
                $requestPayload['last_name'] = $bookingDetails['passengerDetails'][0]['last_name'];
                $requestPayload['email'] = $bookingDetails['userDetails']['emailAddress'];
                $requestPayload['phone_country_code'] = $bookingDetails['userDetails']['countryCode'];
                $requestPayload['phone'] = $bookingDetails['userDetails']['mobileNumber'];
                $requestPayload['supplier_currency'] = $bookingDetails['bookingDetails']['customer_currency'];
                $requestPayload['customer_language_code'] = $bookingDetails['bookingDetails']['customer_language_code'];
                $requestPayload['billing_address1'] = (isset($bookingDetails['billingDetails']['address']) ? $bookingDetails['billingDetails']['address'] : '');
                $requestPayload['billing_address2'] = (isset($bookingDetails['billingDetails']['address1']) ? $bookingDetails['billingDetails']['address1'] : '');
                $requestPayload['billing_city'] = (isset($bookingDetails['billingDetails']['city']) ? $bookingDetails['billingDetails']['city'] : '');
                $requestPayload['billing_state'] = (isset($bookingDetails['billingDetails']['state']) ? $bookingDetails['billingDetails']['state'] : '');
                $requestPayload['billing_country'] = (isset($bookingDetails['billingDetails']['country']) ? $bookingDetails['billingDetails']['country'] : '');
                $requestPayload['billing_zip'] = (isset($bookingDetails['billingDetails']['zipcode']) ? $bookingDetails['billingDetails']['zipcode'] : '');
                $requestPayload['supplier_id'] = $bookingDetails['bookingDetails']['supplier_id'];
                $requestPayload['booking_date'] = date('Y-m-d');
                $requestPayload['total'] = $bookingDetails['paymentDetails']['amount'];
                $requestPayload['booking_points'] = $processedPrice['loyaltyPoints'];
                $requestPayload['service_id'] = $bookingDetails['bookingDetails']['service_type_id'];
                $requestPayload['agency_id'] = $bookingDetails['bookingDetails']['agencyId'];
                $requestPayload['description'] = $bookingDescription;
                $requestPayload['booking_details'] = json_encode($bookingDetails);
                $requestPayload['customer_currency'] = $processedPrice['currency'];
                $requestPayload['customer_language_code'] = $bookingDetails['bookingDetails']['customer_language_code'];
                $requestPayload['sub_total'] = $processedPrice['totalPrice'];
                $requestPayload['tax'] = $processedPrice['vat'];
                $requestPayload['s_markup_fee'] = $processedPrice['markupFee'];
                $requestPayload['s_service_fee'] = $processedPrice['serviceFee'];
                $requestPayload['s_markup_service_fee'] = $processedPrice['markupServiceFee'];
                $requestPayload['s_tax'] = $processedPrice['markupServiceFee'];
                $requestPayload['s_charge'] = "0";
                $requestPayload['s_discount_type'] = "0";
                $requestPayload['s_discount_value'] = "0";
                $requestPayload['s_discount'] = "0";
                $requestPayload['t_discount_type'] = "0";
                $requestPayload['t_discount_value'] = "0";
                $requestPayload['t_discount'] = "0";
                $requestPayload['t_markup_type'] = $processedPrice['markupType'];
                $requestPayload['t_markup_value'] = $processedPrice['markupValue'];
                $requestPayload['t_markup'] = "0";
                $requestPayload['chargeable_seat_price'] = $processedPrice['chargeableSeatPrice'];
                $requestPayload['travelers_price'] = $processedPrice['travelersPrice'];
                $requestPayload['currency_conversion_rate'] = $currencyConversionRate;
                $requestPayload['currency_markup'] = $processedPrice['vat'];
                $requestPayload['booking_from'] = $bookingDetails['bookingDetails']['bookingFrom'];
                if ($bookingDetails['paymentDetails']['redeem_points']['redeemed']) {
                    $requestPayload['redeem_points'] = $bookingDetails['paymentDetails']['redeem_points']['points'];
                    $requestPayload['redeem_amount'] = $bookingDetails['paymentDetails']['redeem_points']['redeemedAmount'];
                } else {
                    $requestPayload['redeem_points'] = 0;
                    $requestPayload['redeem_amount'] = 0;
                }
                $requestPayload['sub_total'] = $bookingDetails['paymentDetails']['subTotal'];
                $requestPayload['total'] = $bookingDetails['paymentDetails']['total'];
                $requestPayload['additional_details'] = $bookingDetails['bookingDetails']['flightRoute'];
                break;
            case 'Hotel-old':
                $hotelBookingDescription = $bookingDetails['hotelDetails']['hotelDetails']['name']['content'] . ' in ' . $bookingDetails['hotelDetails']['hotelDetails']['destination']['name']['content'];
                $processedPrice = $bookingDetails['processedPrice'];
                $requestPayload['booking_type'] = EnumsServiceType::Hotel->value;
                $requestPayload['booking_start_date'] = $bookingDetails['searchDetails']['stay']['checkIn'];
                $requestPayload['customer_id'] = $bookingDetails['userDetails']['userId'];
                $requestPayload['is_guest'] = $isGuestBooking ? true : false;
                $requestPayload['first_name'] = $bookingDetails['userDetails']['first_name'];
                $requestPayload['last_name'] = $bookingDetails['userDetails']['last_name'];
                $requestPayload['email'] = $bookingDetails['userDetails']['emailAddress'];
                $requestPayload['phone_country_code'] = $bookingDetails['userDetails']['countryCode'];
                $requestPayload['phone'] = $bookingDetails['userDetails']['mobileNumber'];
                $requestPayload['supplier_currency'] = $bookingDetails['bookingDetails']['customer_currency'];;;
                $requestPayload['customer_language_code'] = $bookingDetails['bookingDetails']['customer_language_code'];
                $requestPayload['billing_address1'] = (isset($bookingDetails['billingDetails']['address']) ? $bookingDetails['billingDetails']['address'] : '');
                $requestPayload['billing_address2'] = (isset($bookingDetails['billingDetails']['address1']) ? $bookingDetails['billingDetails']['address1'] : '');
                $requestPayload['billing_city'] = (isset($bookingDetails['billingDetails']['city']) ? $bookingDetails['billingDetails']['city'] : '');
                $requestPayload['billing_state'] = (isset($bookingDetails['billingDetails']['state']) ? $bookingDetails['billingDetails']['state'] : '');
                $requestPayload['billing_country'] = (isset($bookingDetails['billingDetails']['country']) ? $bookingDetails['billingDetails']['country'] : '');
                $requestPayload['billing_zip'] = (isset($bookingDetails['billingDetails']['zipcode']) ? $bookingDetails['billingDetails']['zipcode'] : '');
                $requestPayload['supplier_id'] = $bookingDetails['bookingDetails']['supplier_id'];
                $requestPayload['booking_date'] = date('Y-m-d');
                $requestPayload['total'] = $bookingDetails['paymentDetails']['total'];
                $requestPayload['booking_points'] = $bookingDetails['processedPrice']['loyaltyPoints'];
                $requestPayload['service_id'] = $bookingDetails['bookingDetails']['service_type_id'];
                $requestPayload['agency_id'] = $bookingDetails['bookingDetails']['agencyId'];
                $requestPayload['description'] = $hotelBookingDescription;
                $requestPayload['customer_currency'] = $processedPrice['currency'];
                $requestPayload['customer_language_code'] = $bookingDetails['bookingDetails']['customer_language_code'];
                $requestPayload['sub_total'] = $processedPrice['totalPrice'];
                $requestPayload['tax'] = $processedPrice['vat'];
                $requestPayload['s_markup_fee'] = $processedPrice['markupFee'];
                $requestPayload['s_service_fee'] = $processedPrice['serviceFee'];
                $requestPayload['s_markup_service_fee'] = $processedPrice['markupServiceFee'];
                $requestPayload['s_tax'] = $processedPrice['markupServiceFee'];
                $requestPayload['s_charge'] = "0";
                $requestPayload['s_discount_type'] = "0";
                $requestPayload['s_discount_value'] = "0";
                $requestPayload['s_discount'] = "0";
                $requestPayload['t_discount_type'] = "0";
                $requestPayload['t_discount_value'] = "0";
                $requestPayload['t_discount'] = "0";
                $requestPayload['t_markup_type'] = $processedPrice['markupType'];
                $requestPayload['t_markup_value'] = $processedPrice['markupValue'];
                $requestPayload['t_markup'] = "0";
                $requestPayload['currency_conversion_rate'] = $currencyConversionRate;
                $requestPayload['currency_markup'] = $processedPrice['vat'];
                $requestPayload['booking_from'] = $bookingDetails['bookingDetails']['bookingFrom'];
                if ($bookingDetails['paymentDetails']['redeem_points']['redeemed']) {
                    $requestPayload['redeem_points'] = $bookingDetails['paymentDetails']['redeem_points']['points'];
                    $requestPayload['redeem_amount'] = $bookingDetails['paymentDetails']['redeem_points']['redeemedAmount'];
                } else {
                    $requestPayload['redeem_points'] = 0;
                    $requestPayload['redeem_amount'] = 0;
                }
                $requestPayload['sub_total'] = $bookingDetails['paymentDetails']['subTotal'];
                $requestPayload['total'] = $bookingDetails['paymentDetails']['total'];

                $roomNameBoardDetails = [];
                foreach ($bookingDetails['hotelDetails']['hotelDetails']['rooms'] as $key => $room) {
                    foreach ($room['rates'] as $rate) {
                        $roomNameBoardDetails[$rate['rateKey']] = $rate;
                    }
                }
                foreach ($bookingDetails['hotelDetails']['selectedRooms']['rooms'] as $key => $selectedRoomRate) {
                    if (isset($roomNameBoardDetails[$selectedRoomRate['rateKey']])) {
                        $selectedRateDetails = $roomNameBoardDetails[$selectedRoomRate['rateKey']];
                        $combinedRateDetails = array_merge($selectedRateDetails, $selectedRoomRate);
                        $bookingDetails['hotelDetails']['selectedRooms']['rooms'][$key] = $combinedRateDetails;
                    }
                }
                $requestPayload['booking_details'] = json_encode($bookingDetails);


                break;
            case EnumsServiceType::Hotel->value:
                $hotelBookingDescription = $bookingDetails['hotelDetails']['hotelDetails']['DisplayName'];
                $processedPrice = $bookingDetails['processedPrice'];
                $requestPayload['booking_type'] = EnumsServiceType::Hotel->value;
                $requestPayload['booking_start_date'] = $bookingDetails['searchDetails']['stay']['checkIn'];
                $requestPayload['customer_id'] = $bookingDetails['userDetails']['userId'];
                $requestPayload['is_guest'] = $isGuestBooking ? true : false;
                $requestPayload['first_name'] = $bookingDetails['userDetails']['firstName'];
                $requestPayload['last_name'] = $bookingDetails['userDetails']['lastName'];
                $requestPayload['email'] = $bookingDetails['userDetails']['email'];
                $requestPayload['phone_country_code'] = $bookingDetails['userDetails']['phoneCode'];
                $requestPayload['phone'] = $bookingDetails['userDetails']['phoneNumber'];
                $requestPayload['supplier_currency'] = $bookingDetails['bookingDetails']['customer_currency'];
                $requestPayload['customer_language_code'] = $bookingDetails['bookingDetails']['customer_language_code'];
                $requestPayload['billing_address1'] = (isset($bookingDetails['billingDetails']['address']) ? $bookingDetails['billingDetails']['address'] : '');
                $requestPayload['billing_address2'] = (isset($bookingDetails['billingDetails']['address1']) ? $bookingDetails['billingDetails']['address1'] : '');
                $requestPayload['billing_city'] = (isset($bookingDetails['billingDetails']['city']) ? $bookingDetails['billingDetails']['city'] : '');
                $requestPayload['billing_state'] = (isset($bookingDetails['billingDetails']['state']) ? $bookingDetails['billingDetails']['state'] : '');
                $requestPayload['billing_country'] = (isset($bookingDetails['billingDetails']['country']) ? $bookingDetails['billingDetails']['country'] : '');
                $requestPayload['billing_zip'] = (isset($bookingDetails['billingDetails']['zipcode']) ? $bookingDetails['billingDetails']['zipcode'] : '');
                $requestPayload['supplier_id'] = $bookingDetails['bookingDetails']['supplier_id'];
                $requestPayload['booking_date'] = date('Y-m-d');
                $requestPayload['total'] = $bookingDetails['paymentDetails']['total'];
                $requestPayload['booking_points'] = $processedPrice['loyaltyPoints'];
                $requestPayload['service_id'] = $bookingDetails['bookingDetails']['service_type_id'];
                $requestPayload['agency_id'] = $bookingDetails['bookingDetails']['agencyId'];
                $requestPayload['description'] = $hotelBookingDescription;
                $requestPayload['customer_currency'] = $processedPrice['currency'];
                $requestPayload['customer_language_code'] = $bookingDetails['bookingDetails']['customer_language_code'];
                $requestPayload['sub_total'] = $processedPrice['totalPrice'];
                $requestPayload['tax'] = $processedPrice['vat'];
                $requestPayload['s_markup_fee'] = $processedPrice['markupFee'];
                $requestPayload['s_service_fee'] = $processedPrice['serviceFee'];
                $requestPayload['s_markup_service_fee'] = $processedPrice['markupServiceFee'];
                $requestPayload['s_tax'] = $processedPrice['markupServiceFee'];
                $requestPayload['s_charge'] = "0";
                $requestPayload['s_discount_type'] = "0";
                $requestPayload['s_discount_value'] = "0";
                $requestPayload['s_discount'] = "0";
                $requestPayload['t_discount_type'] = "0";
                $requestPayload['t_discount_value'] = "0";
                $requestPayload['t_discount'] = "0";
                $requestPayload['t_markup_type'] = $processedPrice['markupType'];
                $requestPayload['t_markup_value'] = $processedPrice['markupValue'];
                $requestPayload['t_markup'] = "0";
                $requestPayload['currency_conversion_rate'] = $currencyConversionRate;
                $requestPayload['currency_markup'] = $processedPrice['vat'];
                $requestPayload['booking_from'] = '';
                if ($processedPrice['isRedeemUsed']) {
                    $requestPayload['redeem_points'] = str_replace(',', '', $processedPrice['redeemDetails']['maxRedeemPoints']);
                    $requestPayload['redeem_amount'] = $processedPrice['redeemDetails']['maxRedeemPrice'];
                } else {
                    $requestPayload['redeem_points'] = 0;
                    $requestPayload['redeem_amount'] = 0;
                }
                $requestPayload['sub_total'] = $bookingDetails['paymentDetails']['subTotal'];
                $requestPayload['total'] = $bookingDetails['paymentDetails']['total'];
                break;
        }

        $requestPayload['ref_id'] = $refId;
        return $requestPayload;
    }

    public function getUpdateOrderPayload($requestPayload, $referenceDetails, $createNewOrderResponse, $supplierBookingReference = '', $bookingSegmentId = '')
    {
        switch ($referenceDetails['booking_type']) {
            case EnumsServiceType::Flight->value:
                $requestPayload['customer_currency'] = $referenceDetails['booking_details']['processedPrice']['currency'];
                $requestPayload['sub_total'] = $referenceDetails['booking_details']['processedPrice']['grandTotal'];
                $requestPayload['tax'] = $referenceDetails['booking_details']['processedPrice']['vat'];
                $requestPayload['s_tax'] = $referenceDetails['booking_details']['processedPrice']['markupServiceFee'];
                $requestPayload['s_markup_fee'] = $referenceDetails['booking_details']['processedPrice']['markupFee'];
                $requestPayload['s_service_fee'] = $referenceDetails['booking_details']['processedPrice']['serviceFee'];
                $requestPayload['s_markup_service_fee'] = $referenceDetails['booking_details']['processedPrice']['markupServiceFee'];
                $requestPayload['t_markup_type'] = $referenceDetails['booking_details']['processedPrice']['markupType'];
                $requestPayload['t_markup_value'] = $referenceDetails['booking_details']['processedPrice']['markupValue'];
                $requestPayload['currency_markup'] = $referenceDetails['booking_details']['processedPrice']['vat'];

                $associatedRecordIds = [];
                foreach ($createNewOrderResponse['associatedRecords'] as $associatedRecord) {
                    array_push($associatedRecordIds, $associatedRecord['reference']);
                }
                $bookingStartDate = '';
                if (isset($referenceDetails['booking_details']['flightDetails']['flightInfo'][0]['departureDate'])) {
                    $bookingStartDate = date('Y-m-d', strtotime($referenceDetails['booking_details']['flightDetails']['flightInfo'][0]['departureDate']));
                } elseif (isset($referenceDetails['booking_details']['flightDetails']['flightInfo'][0]['lastTicketingDate'])) {
                    $bookingStartDate = date('Y-m-d', strtotime($referenceDetails['booking_details']['flightDetails']['flightInfo'][0]['lastTicketingDate']));
                }
                $requestPayload['booking_start_date'] = $bookingStartDate;
                $requestPayload['supplier_booking_ref'] = $createNewOrderResponse['id'];
                $requestPayload['supplier_booking_associated_ref'] = implode(",", $associatedRecordIds);
                $requestPayload['booking_details'] = json_encode($referenceDetails);
                break;
            case EnumsServiceType::Hotel->value:
                $requestPayload['supplier_booking_ref'] = $supplierBookingReference;
                $requestPayload['supplier_booking_associated_ref'] = $supplierBookingReference;
                $requestPayload['booking_segment_id'] = $bookingSegmentId;
                break;
            case 'SightSeeing':
                break;
        }
        return $requestPayload;
    }

    public function getAndUpdateAmadeusBookingOrderIssuance(
        $amaClientRef,
        $bookingId,
        $customerId,
        $parentLogId,
        $supplierBookingReference,
        $supplierName,
        $createBookingIssuanceResponse
    ) {
        $createBookingIssuanceResponseStr = json_encode($createBookingIssuanceResponse['response']);

        $requestPayload = [
            'log_id' => getRandomString(),
            'booking_id' => $bookingId,
            'log_parent_id' => $parentLogId,
            'type' => EnumsServiceType::Flight->value,
            'supplier' => $supplierName,
            'supplier_reference' => $supplierBookingReference,
            'log_type' => 'flight-order-issuance',
            'customer_id' => $customerId,
            'ama_client_ref' => $amaClientRef,
            'request' => '',
            'response' => $createBookingIssuanceResponseStr
        ];
        SupplierLog::createSupplierLog($requestPayload);

        if ($createBookingIssuanceResponse['status'] == 'true') {
            $issuanceResponseArray = json_decode($createBookingIssuanceResponseStr, true);
            if (
                is_array($issuanceResponseArray) && array_key_exists('data', $issuanceResponseArray) &&
                is_array($issuanceResponseArray['data']['tickets']) && array_key_exists('tickets', $issuanceResponseArray['data'])
            ) {
                $ticketNumbers = [];
                foreach ($issuanceResponseArray['data']['tickets'] as $ticket) {
                    if (array_key_exists('documentNumber', $ticket)) {
                        array_push($ticketNumbers, $ticket['documentNumber']);
                    }
                }
                if (count($ticketNumbers) > 0) {
                    Bookings::updateBooking($bookingId, [
                        'service_provider_issuance_response' => $createBookingIssuanceResponseStr,
                        'ticket_numbers' => implode(',', $ticketNumbers)
                    ]);
                }
            }
        }
    }
}
