<?php

namespace App\Traits;

use App\Models\BookingCheckout;

trait CheckFlightPrice
{
    use BookingHelper;
    public function getUpdatedFlightPriceDetails($savedBookingCheckout, $requestData)
    {
        try {
            $bookingDetails = json_decode($savedBookingCheckout['data']['booking_details'] ?? '{}', true);
            $flightDetails = $bookingDetails['flightDetails'] ?? null;
            $searchDetails = $bookingDetails['searchDetails'] ?? null;
            $processedPrice = $bookingDetails['processedPrice'] ?? null;

            if (!$flightDetails || !$searchDetails || !$processedPrice) {
                return [
                    'status' => false,
                    'message' => 'Invalid booking or search details',
                    'existingPrice' => null,
                    'newPrice' => null,
                ];
            }
            
            $amaClientRef = $customerId = $logId = '';
            if ($bookingDetails['userDetails']['userId'] != '') {
                $customerId = $bookingDetails['userDetails']['userId'];
            }
            if (isset($savedBookingCheckout['log-id'])) {
                $logId = $savedBookingCheckout['log-id'][0];
            }
            if (isset($savedBookingCheckout['ama-client-ref'])) {
                $amaClientRef = $savedBookingCheckout['ama-client-ref'][0];
            }
            $flightOfferPricingPayload = $this->getFlightOfferPricingPayload($requestData['currency'], $requestData['locale'], $bookingDetails['flightDetails']['flightInfo'], $savedBookingCheckout['data']['service_provider']);

            $flightOfferPricingResponse = $this->flightOfferPriceGetWithMarkup($flightOfferPricingPayload, $logId, $customerId, $amaClientRef);

            $newFlightInfo = [];
            $isPriceChanged = false;
            $priceDetails = [];
            $existingPrices = [];
            $newTotalPrice = 0;
            $existingTotalPrice = 0;
            $existingFlightInfo = $bookingDetails['flightDetails']['flightInfo'] ?? [];
            if (array_key_exists('data', $flightOfferPricingResponse)) {
                $newFlightInfo = $flightOfferPricingResponse['data']['flightOffers'];
                // loop through each existing flight-offer
                foreach ($existingFlightInfo as $fIndex => &$existingOffer) {
                    foreach ($newFlightInfo as $newOffer) {
                        if ($newOffer['id'] === $existingOffer['id']) {
                            foreach ($existingOffer['travelerPricings'] as $tIndex => &$existingTraveler) {
                                foreach ($newOffer['travelerPricings'] as $newTraveler) {
                                    if ($newTraveler['travelerId'] === $existingTraveler['travelerId']) {

                                        $oldPrice = isset($existingTraveler['price']['initialTotal'])
                                            ? floatval($existingTraveler['price']['initialTotal'])
                                            : floatval($existingTraveler['price']['total']);

                                        $newPrice = floatval($newTraveler['price']['total']);
                                        // $newPrice = 500;


                                        $existingPrices[] = [
                                            'flight_id'  => $existingOffer['id'],
                                            'travelerId' => $existingTraveler['travelerId'],
                                            'price'      => $oldPrice,
                                        ];

                                        if ($newPrice > $oldPrice) {
                                            $isPriceChanged = true;

                                            $priceDetails[] = [
                                                'flight_id'   => $existingOffer['id'],
                                                'travelerId'  => $existingTraveler['travelerId'],
                                                'old_price'   => $oldPrice,
                                                'new_price'   => $newPrice,
                                                'new_base'    => $newTraveler['price']['base'] ?? null,
                                            ];
                                            $existingTotalPrice +=  $existingTraveler['price']['initialTotal'];
                                            $existingTraveler['price']['initialTotal'] = $newTraveler['price']['total'];
                                            $existingTraveler['price']['total'] = $newTraveler['price']['total'];
                                            $existingTraveler['price']['base'] = $newTraveler['price']['base'];
                                            $newTotalPrice += $newTraveler['price']['total'];

                                            // $existingTotalPrice +=  $existingTraveler['price']['initialTotal'];
                                            // $existingTraveler['price']['initialTotal'] =  $newPrice;
                                            // $existingTraveler['price']['total'] =  $newPrice;
                                            // $existingTraveler['price']['base'] = $newTraveler['price']['base'];
                                            // $newTotalPrice += $newPrice;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                unset($existingOffer, $existingTraveler);
            }
            
            if ($isPriceChanged) {
                $bookingDetails['flightDetails']['flightInfo'] = $existingFlightInfo;
                $processedPrice['isPriceChanged'] = $isPriceChanged;
                $bookingDetails['processedPrice'] = $processedPrice;
                $bookingDetails['processedPrice']['existingPrice'] = $existingTotalPrice;
                $bookingDetails['processedPrice']['newPrice'] = $newTotalPrice;
                $bookingCheckoutId = $savedBookingCheckout['data']['id'];
                $bookingPayload = ['booking_details' => json_encode($bookingDetails)];
                BookingCheckout::updateBookingCheckout($bookingCheckoutId, $bookingPayload);
            }

            return [
                'status' => true,
                'isPriceChanged' => $bookingDetails['processedPrice']['isPriceChanged'],
                'message' => $isPriceChanged
                    ? 'The Current Price of your selected Flight has been changed'
                    : 'The Price of your selected Flight remains the same',
                'existingPrice' =>  $bookingDetails['processedPrice']['existingPrice'],
                'newPrice' => $bookingDetails['processedPrice']['newPrice'],
            ];
        } catch (\GuzzleHttp\Exception\RequestException $e) {
            return [
                'status' => true,
                'message' => $e->getMessage(),
                'response' => $e->hasResponse() ? (string) $e->getResponse()->getBody() : null,
            ];
        }
    }
}
