<?php



namespace App\Traits;

use App\Enums\Currency;
use GuzzleHttp\Client;

use App\Models\BookingCheckout;

use PHPUnit\Framework\Constraint\IsFalse;



trait CheckHotelPrice

{

    public function getUpdatedHotelPrices($savedBookingCheckout, $requestData)

    {

        $client = new Client();
        $bookingDetails = json_decode($savedBookingCheckout['data']['booking_details'] ?? '{}', true);
        $hotelDetails = $bookingDetails['hotelDetails'] ?? null;
        $selectedRooms = array($hotelDetails['selectedRooms']) ?? [];
        $searchDetails = $bookingDetails['searchDetails'] ?? null;
        $bookingPayLoad = [

            'booking_details' => json_encode($bookingDetails),

        ];

        // return $selectedRooms;
        if (!$hotelDetails || !$searchDetails) {
            return [
                'status' => false,
                'message' => 'Invalid booking or search details',
                'existingPrice' => null,
                'newPrice' => null,

            ];
        }
        $searchDetails['searchFrom'] = $requestData['searchFrom'];

        // return $searchDetails;
        $currencyCode = $searchDetails['currencyCode'] ?? Currency::SAR->value;

        try {
            $url = env('API_BASE_URL') . 'hotel/hotel-details-by-id?locale=en&currency=' . $currencyCode;
            $response = $client->post($url, [
                'headers' => [
                    'Accept' => 'application/json',
                    'Content-Type' => 'application/json',
                ],

                'json' => $searchDetails,

            ]);

            $body = $response->getBody()->getContents();
            $originalResponse = json_decode($body, true);
            $matchedUpdatedRooms = [];
            $originalRooms = $originalResponse['data']['Rooms'] ?? [];


            if (!empty($originalRooms) && !empty($selectedRooms)) {
                foreach ($selectedRooms as $selectedRoom) {
                    $selectedRoomBasis = $selectedRoom['RoomBasis'] ?? '';
                    $selectedTargetRoomKey = $selectedRoom['TargetRoomKey'] ?? '';
                    $selectedContractId = $selectedRoom['ContractId'] ?? '';
                    $selectedBedType = $selectedRoom['BedType'] ?? '';

                    foreach ($originalRooms as $roomName => $bedTypes) {
                        foreach ($bedTypes as $bedType => $roomBases) {
                            foreach ($roomBases as $roomBasis => $refundTypes) {
                                foreach ($refundTypes as $refundability => $roomDetail) {
                                    $roomDetailBasis = $roomDetail['RoomBasis'] ?? '';
                                    $roomDetailTargetKey = $roomDetail['TargetRoomKey'] ?? '';
                                    $roomDetailContractId = (string)($roomDetail['ContractId'] ?? '');
                                    $roomDetailBedType = $roomDetail['BedType'] ?? '';

                                    if (
                                        trim($roomDetailBasis) === trim($selectedRoomBasis) &&
                                        trim($roomDetailTargetKey) === trim($selectedTargetRoomKey) &&
                                        $roomDetailContractId === (string)$selectedContractId &&
                                        trim($roomDetailBedType) === trim($selectedBedType)
                                    ) {
                                        $matchedUpdatedRooms[] = $roomDetail;
                                    }
                                }
                            }
                        }
                    }
                }
            }


            $priceDetails = [
                'status' => false,
                'isPriceChanged' => false,
                'existingPrice' => null,
                'newPrice' => null,
            ];

            $isMatched = false;
            if (!empty($matchedUpdatedRooms)) {
                foreach ($selectedRooms as $key => &$selectedRoom) {
                    $isMatched = false;
                    foreach ($matchedUpdatedRooms as $matchedRoom) {
                        if (
                            $selectedRoom['TargetRoomKey'] == $matchedRoom['TargetRoomKey']

                        ) {

                            if (

                                $selectedRoom['SimplePrice'] == $matchedRoom['SimplePrice']

                            ) {

                                break;
                            } else {

                                $isMatched = true;

                                $selectedRooms[$key]['SimplePrice'] = $matchedRoom['SimplePrice'];
                                // $selectedRooms[$key]['SimplePrice'] = 2000;
                            }
                        }
                    }
                }
            }
            // return  reset($selectedRooms);

            $bookingDetails['hotelDetails']['selectedRooms'] = reset($selectedRooms);
            $bookingPayLoad = [
                'booking_details' => json_encode($bookingDetails),
            ];

            if ($isMatched) {
                $booking_details = BookingCheckout::updateBookingByRefId($requestData['ref_id'], $bookingPayLoad);
                if ($booking_details['status'] === true) {
                    $priceDetails['booking_details'] = $booking_details['data'];
                }
            }

            return [
                'status' => true,
                'isPriceChanged' => $bookingDetails['processedPrice']['isPriceChanged'],
                'message' => $bookingDetails['processedPrice']['isPriceChanged']
                    ? 'The Current Price of your selected Hotel has been changed'
                    : 'The Price of your selected Hotel remains the same',
                'existingPrice' => $bookingDetails['processedPrice']['isPriceChanged'] ? $bookingDetails['processedPrice']['finalPrice'] : null,
                'newPrice' => $bookingDetails['processedPrice']['isPriceChanged'] ? $bookingDetails['processedPrice']['grandTotal'] : null,
            ];
        } catch (\GuzzleHttp\Exception\RequestException $e) {
            return [
                'error' => true,
                'message' => $e->getMessage(),
                'response' => $e->hasResponse() ? (string) $e->getResponse()->getBody() : null,
            ];
        }
    }
}
