<?php

namespace App\Traits;

use App\Enums\Currency;
use Illuminate\Support\Facades\Cache;

trait ClearsHomePageCache
{
    protected static function bootClearsHomePageCache()
    {
        static::saved(function () {
            self::clearHomePageCaches();
        });

        static::deleted(function () {
            self::clearHomePageCaches();
        });
    }

    protected static function clearHomePageCaches()
    {
        $currencies = [
            Currency::SAR->value,
            Currency::USD->value,
        ];

        foreach ($currencies as $currency) {
            Cache::forget("home_page_data_{$currency}");
        }

        Cache::forget('countries_list');
    }
}
