<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */


namespace App\Traits;

use App\Models\Bookings;
use App\Models\SupplierLog;

trait CommonService
{

    function libCurl($url, $method, $headers = [], $payload = null)
    {
        $result = [
            'status' => 'false',
            'data' => '',
            'http_code' => '',
            'message' => ''
        ];

        $ch = curl_init();
        if ($method === 'GET' && !empty($payload)) {
            if (is_array($payload)) {
                $url .= '?' . http_build_query($payload);
            } else {
                $url .= '?' . $payload; // if already a query string
            }
        }
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        if ($method == 'POST') {
            curl_setopt($ch, CURLOPT_POST, 1);
            if (is_array($payload)) {
                curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
            } else {
                // payload is already raw string (e.g. URL encoded)
                curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
            }
        } elseif ($method == 'DELETE') {
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'DELETE');
        }
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // this should be set to true in production
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($ch);

        $result['http_code'] = curl_getinfo($ch, CURLINFO_HTTP_CODE);

        if (curl_errno($ch)) {
            $result['message'] = curl_error($ch);
        } else {
            $result['status'] = 'true';
            if ($response) {
                $result['data'] = json_decode($response, true);
            }
        }
        curl_close($ch);

        return $result;
    }

    public function createSupplierLog($type, $supplier, $logType, $request, $response, $customerId = '', $parentLogId = '', $amaClientRef = '', $logId = '')
    {
        if ($logId == '') {
            $logId = getRandomString();
        }
        $requestPayload = [
            'log_id' => $logId,
            'log_parent_id' => $parentLogId,
            'type' => $type,
            'supplier' => $supplier,
            'ama_client_ref' => $amaClientRef,
            'log_type' => $logType,
            'customer_id' => $customerId,
            'request' => $request,
            'response' => $response,
        ];
        $createResponse = SupplierLog::createSupplierLog($requestPayload);
        if ($createResponse['status'] == 'true') {
            return $logId;
        } else {
            return '';
        }
    }

    public function createSupplierLogForBooking($requestData)
    {
        $parentChildLogs = SupplierLog::query()
            ->orWhere('log_id', '=', $requestData['log_parent_id'])
            ->orWhere('log_parent_id', '=', $requestData['log_parent_id'])
            ->get();
        if ($parentChildLogs) {
            $parentChildLogs = $parentChildLogs->toArray();
            foreach ($parentChildLogs as $parentChildLog) {
                $parentChildLog['booking_id'] = $requestData['booking_id'];
                $parentChildLog['customer_id'] = $requestData['customer_id'];
                SupplierLog::updateSupplierLog($parentChildLog);
            }
        }
        $logId = getRandomString();
        $amClientRef = (array_key_exists('ama_client_ref', $requestData)) ? $requestData['ama_client_ref'] : '';
        $requestPayload = [
            'log_id' => $logId,
            'log_parent_id' => $requestData['log_parent_id'],
            'type' => $requestData['type'],
            'supplier' => $requestData['supplier'],
            'supplier_reference' => $requestData['supplier_reference'],
            'ama_client_ref' => $amClientRef,
            'log_type' => $requestData['log_type'],
            'customer_id' => $requestData['customer_id'],
            'booking_id' => $requestData['booking_id'],
            'request' => $requestData['request'],
            'response' => $requestData['response']
        ];
        $createResponse = SupplierLog::createSupplierLog($requestPayload);
        if ($createResponse['status'] == 'true') {
            return $logId;
        } else {
            return '';
        }
    }

    public function getSupplierLogForBooking($bookingId)
    {
        $bookingLogs = SupplierLog::select('log_type', 'supplier', 'supplier_reference', 'request', 'response')
            ->where('booking_id', $bookingId)
            ->orderBy('created_at', 'ASC')
            ->get();
        if ($bookingLogs) {
            $bookingLogs = $bookingLogs->toArray();
            return $bookingLogs;
        } else {
            return [];
        }
    }

    public function getSupplierLogParentIdForBooking($bookingId)
    {
        $supplierLogParentId = '';
        $supplierLog = SupplierLog::select('log_parent_id')
            ->where('booking_id', $bookingId)
            ->where('log_type', 'hotel-order')
            ->get()
            ->first();
        if ($supplierLog) {
            $supplierLogParentId = $supplierLog->log_parent_id;
        }
        return $supplierLogParentId;
    }

    public function getSupplierLogTest($id)
    {
        $response = '';
        $supplierLog = SupplierLog::select('response')
            ->whereId($id)
            ->get()
            ->first();
        if ($supplierLog) {
            $response = $supplierLog->response;
        }
        return $response;
    }

    function getAirportNames($airports, $iataCodes)
    {
        $airportNames = [];
        if (is_array($iataCodes) == false) {
            $iataCodes = explode(',', $iataCodes);
        }
        foreach ($iataCodes as $iataCode) {
            array_push($airportNames, $airports[$iataCode]);
        }
        return $airportNames;
    }

    function getAddressDetails($locale, $latitude, $longitude)
    {
        $result = [
            'address' => '',
            'city' => '',
            'state' => '',
            'country' => ''
        ];
        $googleKey = env('GOOGLE_MAP_KEY');
        $request = 'https://maps.googleapis.com/maps/api/geocode/json?language=' . $locale . '&key=' . $googleKey . '&latlng=' . $latitude . ',' . $longitude . '&sensor=false';
        $file_contents = file_get_contents($request);
        $json_decode = json_decode($file_contents);
        if (isset($json_decode->results[0])) {
            $response = array();
            foreach ($json_decode->results[0]->address_components as $addressComponent) {
                if (in_array('political', $addressComponent->types)) {
                    $response[] = $addressComponent->long_name;
                }
            }
            if (isset($response[0])) {
                $first  =  $response[0];
            } else {
                $first  = 'null';
            }
            if (isset($response[1])) {
                $second =  $response[1];
            } else {
                $second = 'null';
            }
            if (isset($response[2])) {
                $third  =  $response[2];
            } else {
                $third  = 'null';
            }
            if (isset($response[3])) {
                $fourth =  $response[3];
            } else {
                $fourth = 'null';
            }
            if (isset($response[4])) {
                $fifth  =  $response[4];
            } else {
                $fifth  = 'null';
            }

            if ($first != 'null' && $second != 'null' && $third != 'null' && $fourth != 'null' && $fifth != 'null') {
                $result = [
                    'address' => $first,
                    'city' => $second,
                    'state' => $fourth,
                    'country' => $fifth
                ];
            } elseif ($first != 'null' && $second != 'null' && $third != 'null' && $fourth != 'null' && $fifth == 'null') {
                $result = [
                    'address' => $first,
                    'city' => $second,
                    'state' => $third,
                    'country' => $fourth
                ];
            } elseif ($first != 'null' && $second != 'null' && $third != 'null' && $fourth == 'null' && $fifth == 'null') {
                $result = [
                    'address' => '',
                    'city' => $first,
                    'state' => $second,
                    'country' => $third
                ];
            } elseif ($first != 'null' && $second != 'null' && $third == 'null' && $fourth == 'null' && $fifth == 'null') {
                $result = [
                    'address' => '',
                    'city' => '',
                    'state' => $first,
                    'country' => $second
                ];
            } elseif ($first != 'null' && $second == 'null' && $third == 'null' && $fourth == 'null' && $fifth == 'null') {
                $result = [
                    'address' => '',
                    'city' => '',
                    'state' => '',
                    'country' => $first
                ];
            }
        }
        return $result;
    }
}
