<?php

namespace App\Traits;

use App\Models\EditHotelDetail;
use App\Models\EditFlightDetail;

trait EditBooking
{
    public function getEditedBooking($bookingId, $type)
    {
        $bookingData = [];
        $type = strtolower($type);


        if ($type == 'flight') {
            $editedFlightDetail = EditFlightDetail::where('booking_id', $bookingId)->first();

            if ($editedFlightDetail) { 
                $bookingData = [
                    'booking_id'       => $editedFlightDetail->booking_id,
                    'first_name'       => $editedFlightDetail->first_name,
                    'last_name'        => $editedFlightDetail->last_name,
                    'email'            => $editedFlightDetail->email,
                    'booking_date'     => $editedFlightDetail->booking_date,
                    'booking_start_date'=> $editedFlightDetail->booking_start_date,
                    'userDetails'      => $editedFlightDetail->customer_details,
                    'flightDetails'    => $editedFlightDetail->flight_details,
                    'completeflightDetails'    => $editedFlightDetail->complete_flight_details,
                    'passengerDetails' => $editedFlightDetail->passenger_details, 
                    'processedPrice'   => $editedFlightDetail->processed_price,
                    'billingDetails'   => $editedFlightDetail->billing_details,
                    'booking_details'   => $editedFlightDetail->booking_details,
                ];
            }
        }

        if ($type == 'hotel') {
            $editedHotelDetail = EditHotelDetail::where('booking_id', $bookingId)->first();

            if ($editedHotelDetail) { 
                $bookingData = [
                    'booking_id'       => $editedHotelDetail->booking_id,
                    'first_name'       => $editedHotelDetail->first_name,
                    'last_name'        => $editedHotelDetail->last_name,
                    'email'            => $editedHotelDetail->email,
                    'booking_date'     => $editedHotelDetail->booking_date,
                    'booking_start_date'=> $editedHotelDetail->booking_start_date,
                    'userDetails'      => $editedHotelDetail->customer_details,
                    'hotelDetails'     => $editedHotelDetail->hotel_details,
                    'searchDetails'     => $editedHotelDetail->search_details,
                    'processedPrice'   => $editedHotelDetail->processed_price,
                    'billingDetails'   => $editedHotelDetail->billing_details,
                    'booking_details'   => $editedHotelDetail->booking_details,
                ];
            }
        }

        return $bookingData;
    }
}
