<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */


namespace App\Traits;

use App\Enums\Locale;
use App\Models\Setting;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Carbon\Carbon;
use Config;
use App\Models\MailTemplate;
use DateTime;

trait EmailService
{

    public function passwordExpiryMailTemplate($code, $data = [])
    {

        // Get code and check that code exists or not.
        $mailTemplate = DB::table('core_mail_templates')->where('code', $code)->first();
        if (empty($mailTemplate)) {
            return (['status' => 'false', 'error' => 'Service Email Not Started!!']);
        } else {
            $contentData = $mailTemplate->content;
            $subjectData = $mailTemplate->subject;
            // find value and replace with particular data
            $contentData = (str_replace('{{AgencyLogo}}', $data['agency_logo'], $contentData));
            $contentData = (str_replace('{{CustomerName}}', e($data['customer_name']), $contentData));
            $contentData = (str_replace('{{AgencyName}}', ucwords(e($data['agency_name'])), $contentData));
            $contentData = (str_replace('{{DateTime}}', date('Y-m-d h:i:s'), $contentData));
            $contentData = (str_replace('{{PasswordExpiryDay}}', e($data['password_expiry_day']) ?? "", $contentData));
            $subject = (str_replace('{{AgencyName}}', $data['agency_logo'], $subjectData));
            $data = ['mailData' => $contentData, 'subject' => $subject];
            return (['status' => 'true', 'data' => $data]);
        }
    }
    /**
     * replace contect with dynamic values in change password mail template
     * created date 11-07-2023
     */
    public function changePasswordMailTemplate($code, $data = [], $language_code)
    {

        // Get code and check that code exists or not.
        $query = MailTemplate::select('id', 'code')
            ->with(['mailCodeNameSingle' => function ($query) use ($language_code) {
                $query->select(['mail_id', 'content', 'subject', 'language_code'])
                    ->where('language_code', $language_code);
            }])
            ->where('code', $code)
            ->whereHas('mailCodeNameSingle', function ($q) use ($language_code) {
                $q->where('language_code', $language_code);
            })
            ->first();

        if (empty($query)) {
            return (['status' => 'false', 'error' => 'Service Email Not Started!!']);
        } else {
            $contentData = $query->mailCodeNameSingle->content;

            $subjectData = $query->mailCodeNameSingle->subject;
            $contentData = (str_replace('{{AgencyLogo}}', $data['agency_logo'], $contentData));
            $contentData = (str_replace('{{CustomerName}}', e($data['customer_name']), $contentData));
            $contentData = (str_replace('{{AgencyName}}', ucwords(e($data['agency_name'])), $contentData));
            $contentData = (str_replace('{{DateTime}}', date('Y-m-d h:i:s'), $contentData));
            $subject = (str_replace('{{AgencyName}}', e($data['agency_name']), $subjectData));
            $data = ['mailData' => $contentData, 'subject' => $subject];
            return (['status' => 'true', 'data' => $data]);
        }
    }

    /**
     * replace data into user signup mail template
     * created date 08-07-2023
     */
    public static function userSignUpMailTemplate($code, $data = [], $language_code)
    {
        // Get code and check that code exists or not.
        $query = MailTemplate::select('id', 'code')
            ->with(['mailCodeNameSingle' => function ($query) use ($language_code) {
                $query->select(['mail_id', 'content', 'subject', 'language_code'])
                    ->where('language_code', $language_code);
            }])
            ->where('code', $code)
            ->whereHas('mailCodeNameSingle', function ($q) use ($language_code) {
                $q->where('language_code', $language_code);
            })
            ->first();
        if (empty($query)) {

            return (['status' => 'false', 'error' => 'Service Email Not Started!!']);
        } else {
            $click_txt = '';
            if ($language_code == Locale::English->value) {
                $click_txt = 'Click Here';
            }

            if ($language_code == Locale::Arabic->value) {
                $click_txt = 'انقر هنا';
            }
            $contentData = $query->mailCodeNameSingle->content;

            $subjectData = $query->mailCodeNameSingle->subject;

            $contentData = (str_replace('{{AgencyLogo}}', $data['agency_logo'], $contentData));
            $contentData = (str_replace('{{UserName}}', e($data['user_name']), $contentData));
            $contentData = (str_replace('{{AgencyName}}', ucwords(e($data['site_name'])), $contentData));
            $contentData = (str_replace('{{password}}', e($data['password']), $contentData));
            $subject = (str_replace('{{AgencyName}}', e($data['site_name']), $subjectData));
            $data = ['mailData' => $contentData, 'subject' => $subject];
            return (['status' => 'true', 'data' => $data]);
        }
    }
    /**
     * replace data into user account activation mail template
     * created date 11-07-2023
     */
    public static function userAccountActivationMailTemplate($code, $data = [])
    {

        // Get code and check that code exists or not.
        $mailTemplate = DB::table('core_mail_templates')->where('code', $code)->first();
        $userData = processSimpleTemplate($data);
        if (empty($mailTemplate)) {
            return (['status' => 'false', 'error' => 'Service Email Not Started!!']);
        } else {
            $contentData = $mailTemplate->content;
            $subjectData = $mailTemplate->subject;
            $contentData = (str_replace('{{AgencyLogo}}', $userData['agency_logo'], $contentData));
            $contentData = (str_replace('{{UserName}}', e($userData['user_name']), $contentData));
            $contentData = (str_replace('{{AgencyName}}', e($userData['agency_name']), $contentData));
            $subject = (str_replace('{{AgencyName}}', e($userData['agency_name']), $subjectData));
            $data = ['mailData' => $contentData, 'subject' => $subject];
            return (['status' => 'true', 'data' => $data, 'agencyName' => $userData['agency_name']]);
        }
    }
    public static function customerSignUp($code, $data = [], $language_code = Locale::English->value)
    {
        // Get code and check that code exists or not.
        $query = MailTemplate::select('id', 'code')
            ->with(['mailCodeNameSingle' => function ($query) use ($language_code) {
                $query->select(['mail_id', 'content', 'subject', 'language_code'])
                    ->where('language_code', $language_code);
            }])
            ->where('code', $code)
            ->whereHas('mailCodeNameSingle', function ($q) use ($language_code) {
                $q->where('language_code', $language_code);
            })
            ->first();
        if (empty($query)) {

            return (['status' => 'false', 'error' => 'Service Email Not Started!!']);
        } else {
            $click_txt = '';
            if ($language_code == Locale::English->value) {
                $click_txt = 'Click Here';
            }

            if ($language_code == Locale::Arabic->value) {
                $click_txt = 'انقر هنا';
            }
            $contentData = $query->mailCodeNameSingle->content;

            $subjectData = $query->mailCodeNameSingle->subject;

            $contentData = (str_replace('{{CustomerName}}', e($data['first_name']), $contentData));
            $contentData = (str_replace('{{AgencyName}}', ucwords(e($data['agency_name'])), $contentData));
            $contentData = (str_replace('{{CustomerEmail}}', strtolower(e($data['email'])), $contentData));
            $contentData = (str_replace('{{click here}}', '<a href="' . $data['activation_link'] . '" target="_blank">' . $click_txt . '</a>', $contentData));
            $contentData = (str_replace('{{AgencyLogo}}', $data['agency_logo'], $contentData));
            $contentData = (str_replace('{{ActivationLink}}', $data['activation_link'], $contentData));
            $subject = (str_replace('{{AgencyName}}', e($data['agency_name']), $subjectData));

            $data = ['mailData' => $contentData, 'subject' => $subject];
            return (['status' => 'true', 'data' => $data]);
        }
    }
    /**
     * replace data into user welcome agency mail template
     * created date 04-08-2023
     */
    public static function welcomeAgencyMailTemplate($code, $data = [], $language_code = Locale::English->value)
    {

        // Get code and check that code exists or not.
        $query = MailTemplate::select('id', 'code')
            ->with(['mailCodeNameSingle' => function ($query) use ($language_code) {
                $query->select(['mail_id', 'content', 'subject', 'language_code'])
                    ->where('language_code', $language_code);
            }])
            ->where('code', $code)
            ->whereHas('mailCodeNameSingle', function ($q) use ($language_code) {
                $q->where('language_code', $language_code);
            })
            ->first();
        $userData = processSimpleTemplate($data);
        if (empty($query)) {

            return (['status' => 'false', 'error' => 'Service Email Not Started!!']);
        } else {

            $contentData = $query->mailCodeNameSingle->content;
            $subjectData = $query->mailCodeNameSingle->subject;

            $contentData = (str_replace('{{AgencyLogo}}', $userData['agency_logo'], $contentData));
            $contentData = (str_replace('{{UserName}}', e($userData['user_name']), $contentData));
            $contentData = (str_replace('{{AgencyName}}', e($userData['agency_name']), $contentData));
            $subject = (str_replace('{{AgencyName}}', e($userData['agency_name']), $subjectData));
            $data = ['mailData' => $contentData, 'subject' => $subject];
            return (['status' => 'true', 'data' => $data, 'agencyName' => $userData['agency_name']]);
        }
    }
    /**
     * replace data into customer account welcome mail template
     * created date 27-10-2023
     */
    public static function customerWelcomeMailTemplete($code, $data = [], $language_code = Locale::English->value)
    {
        // Get code and check that code exists or not.
        $query = MailTemplate::select('id', 'code')
            ->with(['mailCodeNameSingle' => function ($query) use ($language_code) {
                $query->select(['mail_id', 'content', 'subject', 'language_code'])
                    ->where('language_code', $language_code);
            }])
            ->where('code', $code)
            ->whereHas('mailCodeNameSingle', function ($q) use ($language_code) {
                $q->where('language_code', $language_code);
            })
            ->first();
        if (empty($query)) {

            return (['status' => 'false', 'error' => 'Service Email Not Started!!']);
        } else {

            $contentData = $query->mailCodeNameSingle->content;
            $subjectData = $query->mailCodeNameSingle->subject;

            $contentData = (str_replace('{{AgencyLogo}}', $data['agency_logo'], $contentData));
            $contentData = (str_replace('{{UserName}}', e($data['customer_name']), $contentData));
            $contentData = (str_replace('{{AgencyName}}', ucwords(e($data['agency_name'])), $contentData));
            $contentData = (str_replace('{{Password}}', ucwords(e($data['password'])), $contentData));
            $subject = (str_replace('{{AgencyName}}', e($data['agency_name']), $subjectData));
            $data = ['mailData' => $contentData, 'subject' => $subject];
            return (['status' => 'true', 'data' => $data]);
        }
    }
    /**
     * replace data into customer OTP send mail template
     * created date 07-12-2023
     */
    public static function customerSendOTPTemplete($code, $data = [], $language_code = Locale::English->value)
    {
        // Get code and check that code exists or not.
        $query = MailTemplate::select('id', 'code')
            ->with(['mailCodeNameSingle' => function ($query) use ($language_code) {
                $query->select(['mail_id', 'content', 'subject', 'language_code'])
                    ->where('language_code', $language_code);
            }])
            ->where('code', $code)
            ->whereHas('mailCodeNameSingle', function ($q) use ($language_code) {
                $q->where('language_code', $language_code);
            })
            ->first();
        if (empty($query)) {

            return (['status' => 'false', 'error' => 'Service Email Not Started!!']);
        } else {
            $contentData = $query->mailCodeNameSingle->content;

            $subjectData = $query->mailCodeNameSingle->subject;
            $contentData = (str_replace('{{AgencyLogo}}', $data['agencyLogo'], $contentData));
            $contentData = (str_replace('{{AgencyName}}', e($data['agencyName']), $contentData));
            $contentData = (str_replace('{{CustomerName}}', e($data['customer_name']), $contentData));
            $contentData = (str_replace('{{Otp}}', e($data['otp']), $contentData));
            $contentData = (str_replace('{{Otp_expire_minute}}', e($data['otp_expire_minute']), $contentData));
            // $contentData = (str_replace('{{AgencyName}}', $data['site_name'], $contentData));
            $contentData = (str_replace('{{SiteName}}', e($data['site_name']), $contentData));
            $subject = $subjectData;
            $data = ['mailData' => $contentData, 'subject' => $subject];
            return (['status' => 'true', 'data' => $data]);
        }
    }

    // Reset User Passoword Template
    public static function resetUserPasswordTemplate($code, $data = [], $language_code = Locale::English->value)
    {
        // Get code and check that code exists or not.
        $query = MailTemplate::select('id', 'code')
            ->with(['mailCodeNameSingle' => function ($query) use ($language_code) {
                $query->select(['mail_id', 'content', 'subject', 'language_code'])
                    ->where('language_code', $language_code);
            }])
            ->where('code', $code)
            ->whereHas('mailCodeNameSingle', function ($q) use ($language_code) {
                $q->where('language_code', $language_code);
            })
            ->first();
        if (empty($query)) {

            return (['status' => 'false', 'error' => 'Service Email Not Started!!']);
        } else {
            $contentData = $query->mailCodeNameSingle->content;

            $subjectData = $query->mailCodeNameSingle->subject;
            $contentData = (str_replace('{{AgencyLogo}}', $data['agencyLogo'], $contentData));
            $contentData = (str_replace('{{AgencyName}}', e($data['agencyName']), $contentData));
            $contentData = (str_replace('{{CustomerName}}', e($data['user_name']), $contentData));
            $contentData = (str_replace('{{Otp}}', e($data['otp']), $contentData));
            $contentData = (str_replace('{{Otp_expire_minute}}', e($data['otp_expire_minute']), $contentData));
            // $contentData = (str_replace('{{AgencyName}}', $data['site_name'], $contentData));
            $contentData = (str_replace('{{SiteName}}', e($data['site_name']), $contentData));
            $subject = $subjectData;
            $data = ['mailData' => $contentData, 'subject' => $subject];
            return (['status' => 'true', 'data' => $data]);
        }
    }

    // Reset Customer Passoword Template
    public static function resetCustomerPasswordTemplate($code, $data = [], $language_code = Locale::English->value)
    {
        // Get code and check that code exists or not.
        $query = MailTemplate::select('id', 'code')
            ->with(['mailCodeNameSingle' => function ($query) use ($language_code) {
                $query->select(['mail_id', 'content', 'subject', 'language_code'])
                    ->where('language_code', $language_code);
            }])
            ->where('code', $code)
            ->whereHas('mailCodeNameSingle', function ($q) use ($language_code) {
                $q->where('language_code', $language_code);
            })
            ->first();
        if (empty($query)) {

            return (['status' => 'false', 'error' => 'Service Email Not Started!!']);
        } else {
            $contentData = $query->mailCodeNameSingle->content;

            $subjectData = $query->mailCodeNameSingle->subject;
            $contentData = (str_replace('{{AgencyLogo}}', $data['agencyLogo'], $contentData));
            $contentData = (str_replace('{{AgencyName}}', e($data['agencyName']), $contentData));
            $contentData = (str_replace('{{CustomerName}}', e($data['customer_name']), $contentData));
            $contentData = (str_replace('{{Otp}}', e($data['otp']), $contentData));
            $contentData = (str_replace('{{Otp_expire_minute}}', e($data['otp_expire_minute']), $contentData));
            // $contentData = (str_replace('{{AgencyName}}', $data['site_name'], $contentData));
            $contentData = (str_replace('{{SiteName}}', e($data['site_name']), $contentData));
            $subject = $subjectData;
            $data = ['mailData' => $contentData, 'subject' => $subject];
            return (['status' => 'true', 'data' => $data]);
        }
    }


    //notify user when account has been bloked
    public function mailTemplateBlockAccount($code, $data = [], $language_code = Locale::English->value)
    {

        // Get code and check that code exists or not.
        $query = MailTemplate::select('id', 'code')
            ->with(['mailCodeNameSingle' => function ($query) use ($language_code) {
                $query->select(['mail_id', 'content', 'subject', 'language_code'])
                    ->where('language_code', $language_code);
            }])
            ->where('code', $code)
            ->whereHas('mailCodeNameSingle', function ($q) use ($language_code) {
                $q->where('language_code', $language_code);
            })
            ->first();
        if (empty($query)) {

            return (['status' => 'false', 'error' => 'Service Email Not Started!!']);
        } else {

            $contentData = $query->mailCodeNameSingle->content;
            $subjectData = $query->mailCodeNameSingle->subject;
            $contentData = (str_replace('{{CustomerName}}', e($data['customer_name']), $contentData));
            $contentData = (str_replace('{{AgencyName}}', ucwords(e($data['agency_name'])), $contentData));
            $contentData = (str_replace('{{Hours}}', e($data['hours']) . " " . e($data['duration']), $contentData));
            $contentData = (str_replace('{{AgencyLogo}}', $data['agency_logo'], $contentData));

            $subject = (str_replace('{{AgencyName}}', e($data['agency_name']), $subjectData));
            $data = ['mailData' => $contentData, 'subject' => $subject];
            return (['status' => 'true', 'data' => $data]);
        }
    }
    /**
     * replace data into user agency block mail template
     * created date 07-08-2023
     */
    public static function agencyBlockMailTemplate($code, $data = [])
    {

        // Get code and check that code exists or not.
        $mailTemplate = DB::table('core_mail_templates')->where('code', $code)->first();

        if (empty($mailTemplate)) {
            return (['status' => 'false', 'error' => 'Service Email Not Started!!']);
        } else {
            $contentData = $mailTemplate->content;
            $subjectData = $mailTemplate->subject;
            $contentData = (str_replace('{{AgencyLogo}}', $data['agency_logo'], $contentData));
            $contentData = (str_replace('{{AgencyName}}', ucwords(e($data['agency_name'])), $contentData));
            $subject = (str_replace('{{AgencyName}}', e($data['agency_name']), $subjectData));
            $data = ['mailData' => $contentData, 'subject' => $subject];
            return (['status' => 'true', 'data' => $data]);
        }
    }
    /**
     * replace data into user forgot password mail template
     * created date 16-09-2023
     */
    public function forgotPasswordMailTemplate($code, $data = [], $language_code = Locale::English->value)
    {

        // Get code and check that code exists or not.
        $query = MailTemplate::select('id', 'code')
            ->with(['mailCodeNameSingle' => function ($query) use ($language_code) {
                $query->select(['mail_id', 'content', 'subject', 'language_code'])
                    ->where('language_code', $language_code);
            }])
            ->where('code', $code)
            ->whereHas('mailCodeNameSingle', function ($q) use ($language_code) {
                $q->where('language_code', $language_code);
            })
            ->first();
        if (empty($query)) {

            return (['status' => 'false', 'error' => 'Service Email Not Started!!']);
        } else {
            $click_txt = '';
            if ($language_code == Locale::English->value) {
                $click_txt = 'Click Here';
            }

            if ($language_code == Locale::Arabic->value) {
                $click_txt = 'انقر هنا';
            }
            $contentData = $query->mailCodeNameSingle->content;
            $subjectData = $query->mailCodeNameSingle->subject;
            $contentData = (str_replace('{{AgencyLogo}}', $data['agency_logo'], $contentData));
            $contentData = (str_replace('{{AgencyName}}', ucwords(e($data['agency_name'])), $contentData));
            $contentData = (str_replace('{{CustomerName}}', ucwords(e($data['customer_name'])), $contentData));
            $contentData = (str_replace('Click Here', '<a href="' . $data['activation_link'] . '" target="_blank">' . $click_txt . '</a>', $contentData));
            $subject = (str_replace('{{AgencyName}}', e($data['agency_name']), $subjectData));
            $data = ['mailData' => $contentData, 'subject' => $subject];
            return (['status' => 'true', 'data' => $data]);
        }
    }

    /**
     * Create mail template for booking.
     *
     * @param string $code
     * @param array $data
     * @param string $language_code
     * @return array
     */
    public static function createBookingMailTemplate($code, $language_code = Locale::English->value)
    {
        // Get code and check that code exists or not.
        $query = MailTemplate::select('id', 'code')
            ->with(['mailCodeNameSingle' => function ($query) use ($language_code) {
                $query->select(['mail_id', 'content', 'subject', 'language_code'])
                    ->where('language_code', $language_code);
            }])
            ->where('code', $code)
            ->whereHas('mailCodeNameSingle', function ($q) use ($language_code) {
                $q->where('language_code', $language_code);
            })
            ->first();
        if (empty($query)) {
            return (['status' => 'false', 'error' => 'Service Email Not Started!!']);
        } else {
            return (['status' => 'true', 'data' => [
                'subject' => $query->mailCodeNameSingle->subject,
                'mailData' => $query->mailCodeNameSingle->content
            ]]);
        }
    }



    /**
     * Sends an email using specified parameters.
     *
     * @param string $toEmail The recipient's email address.
     * @param string $subject The subject line of the email.
     * @param array $mailData An array containing email content data.
     * @param array $files An optional array of file paths to attach.
     * @param string $fromName The sender's name (default: "Travel Portal").
     * @param string|null $templateCode An optional template code for the email.
     * @return void
     */
    public static function sendEmail($toEmail, $subject, $mailData, $files = [], $fromName = "Travel Portal")
    {

        $isMail = Setting::where('config_key', 'mail|smtp|server')->value('value');
        $siteEmail = Setting::where('config_key', 'general|basic|siteEmail')->value('value');

        if (empty($siteEmail)) {
            \Log::error('Service Email Not Started: Site email is not configured.');
            return ['status' => 'false', 'error' => 'Service Email Not Started!'];
        }

        if ($isMail == '1') {
            // SMTP settings
            $hostName  = env('MAIL_HOST');
            $fromEmail = env('MAIL_FROM_ADDRESS');
            $userName  = env('MAIL_USERNAME');
            $password  = env('MAIL_PASSWORD');
            $security  = env('MAIL_ENCRYPTION', 'tls'); // Default to 'tls' if not set in .env
            $port      = env('MAIL_PORT');


            if (!$hostName || !$fromEmail || !$userName || !$password || !$port) {
                \Log::error('SMTP configuration is incomplete.');
                return ['status' => 'false', 'error' => 'SMTP configuration is incomplete.'];
            }


            $config = [
                'driver'    => 'smtp',
                'host'      => $hostName,
                'port'      => $port,
                'encryption' => $security,
                'from'      => ['address' => $fromEmail, 'name' => $fromName],
                'username'  => $userName,
                'password'  => $password,
            ];

            Config::set('mail', $config);


            try {
                $mailDataArr = ['mailData' => $mailData];
                Mail::send('mail.blankEmailTemplate', $mailDataArr, function ($message) use ($toEmail, $subject, $fromEmail, $files, $fromName) {
                    $message->from($fromEmail, $fromName);
                    $message->to($toEmail)->subject($subject);

                    foreach ($files as $file) {
                        if (file_exists($file)) {
                            $message->attach($file);
                        } else {
                            \Log::warning("Attachment file not found: $file");
                        }
                    }
                });


                if (count(Mail::failures()) > 0) {
                    \Log::error('Failed to send email to: ' . implode(', ', Mail::failures()));
                    return ['status' => 'false', 'error' => 'Failed to send email.'];
                }

                return ['status' => 'true', 'message' => 'Email sent successfully.'];
            } catch (\Exception $ex) {
                \Log::error('Email Sending Error: ' . $ex->getMessage());
                return ['status' => 'false', 'error' => $ex->getMessage()];
            }
        } else {

            $headers = "From: $fromName <$siteEmail>\r\n";
            $headers .= "MIME-Version: 1.0\r\n";
            $headers .= "Content-Type: text/html; charset=UTF-8\r\n";


            $boundary = md5(time());
            $headers .= "Content-Type: multipart/mixed; boundary=\"{$boundary}\"\r\n";

            $message = "--{$boundary}\r\n";
            $message .= "Content-Type: text/html; charset=UTF-8\r\n";
            $message .= "Content-Transfer-Encoding: 7bit\r\n\r\n";
            $message .= $mailData . "\r\n\r\n";


            if (!empty($files)) {
                foreach ($files as $file) {
                    if (file_exists($file)) {
                        $fileData = chunk_split(base64_encode(file_get_contents($file)));
                        $message .= "--{$boundary}\r\n";
                        $message .= "Content-Type: application/octet-stream; name=\"" . basename($file) . "\"\r\n";
                        $message .= "Content-Transfer-Encoding: base64\r\n";
                        $message .= "Content-Disposition: attachment; filename=\"" . basename($file) . "\"\r\n\r\n";
                        $message .= $fileData . "\r\n\r\n";
                    } else {
                        \Log::warning("Attachment file not found: $file");
                    }
                }
            }

            $message .= "--{$boundary}--";

            try {
                if (mail($toEmail, $subject, $message, $headers)) {
                    return ['status' => 'true', 'message' => 'Email sent using fallback mail().'];
                } else {
                    \Log::error("Fallback mail() failed to send email to: $toEmail");
                    return ['status' => 'false', 'error' => 'Fallback mail() failed to send email.'];
                }
            } catch (\Exception $ex) {
                \Log::error('Fallback Email Sending Error: ' . $ex->getMessage());
                return ['status' => 'false', 'error' => $ex->getMessage()];
            }
        }

        return ['status' => 'false', 'error' => 'Unknown error occurred while sending email.'];
    }





    public static function requestOtpMailTemplate($code, $data = [], $otp)
    {
        $rand = '#' . rand(1000, 9999);
        // Get code and check that code exists or not.
        $mailTemplate = DB::table('core_mail_templates')->where('code', $code)->first();
        $userData = processSimpleTemplate($data);
        if (empty($mailTemplate)) {
            return (['status' => 'false', 'error' => 'Service Email Not Started!!']);
        } else {
            $contentData = $mailTemplate->content;
            $subjectData = $mailTemplate->subject;
            $contentData = (str_replace('{{AgencyLogo}}', $userData['agency_logo'], $contentData));

            $contentData = (str_replace('{{UserName}}', e($userData['user_name']), $contentData));
            $contentData = (str_replace('{{OTP}}', e($otp), $contentData));
            $contentData = (str_replace('{{AgencyName}}', e($userData['agency_name']), $contentData));

            $placeholders = [
                '{{AgencyName}}' => $userData['agency_name'],
                '{{RandomNumber}}' => $rand,
            ];

            $subject = str_replace(array_keys($placeholders), array_values($placeholders), $subjectData);

            $data = ['mailData' => $contentData, 'subject' => $subject];
            return (['status' => 'true', 'data' => $data, 'agencyName' => $userData['agency_name']]);
        }
    }


    public static function subscribeMailTemplate($code)
    {

        // Get code and check that code exists or not.
        $mailTemplate = DB::table('core_mail_templates')->where('code', $code)->first();
        $processData = processSubscriberTemplate();
        $link = 'https://demo.rehlte.com/';

        if (empty($mailTemplate)) {
            return (['status' => 'false', 'error' => 'Service Email Not Started!!']);
        } else {
            $contentData = $mailTemplate->content;
            $subjectData = $mailTemplate->subject;
            $contentData = (str_replace('{{AgencyLogo}}', $processData['agency_logo'], $contentData));

            $contentData = (str_replace('{{Link}}', $link, $contentData));

            $contentData = (str_replace('{{AgencyName}}', e($processData['agency_name']), $contentData));


            $subject = str_replace('{{AgencyName}}', e($processData['agency_name']),  $subjectData);

            $data = ['mailData' => $contentData, 'subject' => $subject];
            return (['status' => 'true', 'data' => $data, 'agencyName' => $processData['agency_name']]);
        }
    }


    public static function deleteAccountOtpMailTemplate($code, $data = [], $otp)
    {

        $rand = '#' . rand(1000, 9999);
        // Get code and check that code exists or not.
        $mailTemplate = DB::table('core_mail_templates')->where('code', $code)->first();
        $userData = processDeleteAccountTemplate($data);
        if (empty($mailTemplate)) {
            return (['status' => 'false', 'error' => 'Service Email Not Started!!']);
        } else {
            $contentData = $mailTemplate->content;
            $subjectData = $mailTemplate->subject;
            $contentData = (str_replace('{{AgencyLogo}}', $userData['agency_logo'], $contentData));

            $contentData = (str_replace('{{UserName}}', e($userData['user_name']), $contentData));
            $contentData = (str_replace('{{OTP}}', e($otp), $contentData));
            $contentData = (str_replace('{{AgencyName}}', e($userData['agency_name']), $contentData));

            $placeholders = [
                '{{AgencyName}}' => $userData['agency_name'],
                '{{RandomNumber}}' => $rand,
            ];

            $subject = str_replace(array_keys($placeholders), array_values($placeholders), $subjectData);

            $data = ['mailData' => $contentData, 'subject' => $subject];
            return (['status' => 'true', 'data' => $data, 'agencyName' => $userData['agency_name']]);
        }
    }



    public static function contactUsMailTemplate($code, $data = [])
    {
        $rand = '#' . rand(1000, 9999);
        $mailTemplate = DB::table('core_mail_templates')->where('code', $code)->first();
        $userData = processContactUsTemplate($data);


        if (empty($mailTemplate)) {
            return (['status' => 'false', 'error' => 'Service Email Not Started!!']);
        } else {
            $contentData = $mailTemplate->content;
            $subjectData = $mailTemplate->subject;


            $contentData = (str_replace('{{UserName}}', e($userData['user_name']), $contentData));
            $contentData = (str_replace('{{Email}}', e($userData['email']), $contentData));
            $contentData = (str_replace('{{Message}}', e($userData['message']), $contentData));
            $contentData = (str_replace('{{PhoneCode}}', e($userData['phone_code']), $contentData));
            $contentData = (str_replace('{{Phone}}', e($userData['phone']), $contentData));

            $contentData = (str_replace('{{AgencyName}}', e($userData['agency_name']), $contentData));

            $placeholders = [
                '{{AgencyName}}' => $userData['agency_name'],
                '{{RandomNumber}}' => $rand,
            ];

            $subject = str_replace(array_keys($placeholders), array_values($placeholders), $subjectData);

            $data = ['mailData' => $contentData, 'subject' => $subject];
            return (['status' => 'true', 'data' => $data, 'agencyName' => $userData['agency_name']]);
        }
    }

    public static function loginAttemptNotifyTemplete($code, $data = [],$language_code)
    {
        // Get code and check that code exists or not.
        $query = MailTemplate::select('id', 'code')
            ->with(['mailCodeNameSingle' => function ($query) use ($language_code) {
                $query->select(['mail_id', 'content', 'subject', 'language_code'])
                    ->where('language_code', $language_code);
            }])
            ->where('code', $code)
            ->whereHas('mailCodeNameSingle', function ($q) use ($language_code) {
                $q->where('language_code', $language_code);
            })
            ->first();
        if (empty($query)) {

            return (['status' => 'false', 'error' => 'Service Email Not Started!!']);
        } else {

            $contentData = $query->mailCodeNameSingle->content;
            $subjectData = $query->mailCodeNameSingle->subject;
            $contentData = (str_replace('{{CustomerName}}', e($data['customer_name']), $contentData));
            $contentData = (str_replace('{{CustomerEmail}}', e($data['customer_email']), $contentData));
            $contentData = (str_replace('{{AttemptCount}}', e($data['attempt_count']), $contentData));
            $contentData = (str_replace('{{IpAddress}}', e($data['ip_address']), $contentData));
            $contentData = (str_replace('{{Time}}', e($data['time']), $contentData));
            $contentData = (str_replace('{{AgencyName}}', ucwords(e($data['agency_name'])), $contentData));
            $contentData = (str_replace('{{Hours}}', e($data['hours']) . " " . e($data['duration']), $contentData));
            $contentData = (str_replace('{{AgencyLogo}}', e($data['agency_logo']), $contentData));

            $subject = (str_replace('{{AgencyName}}', $data['agency_name'], $subjectData));
            $data = ['mailData' => $contentData, 'subject' => $subject];
            return (['status' => 'true', 'data' => $data]);
        }
    }
}
