<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */


namespace App\Traits;

use Carbon\Carbon;
use App\Models\Airline;
use App\Models\Markups;
use App\Models\NegFare;
use App\Models\CityI18n;
use App\Models\TourCode;
use App\Models\AirlineI18ns;
use App\Models\AirportI18ns;
use App\Models\CountryI18ns;
use App\Models\DefaultMarkup;
use App\Models\MarkupSetting;
use App\Services\BrandedFareService;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\Storage;

trait FlightService
{

    public function hasNegFareApplicable($searchCriteria)
    {
        $hasNegFare = false;
        $negFareQuery = NegFare::where('status', 1);

        $travelStartDate = Carbon::parse($searchCriteria['originDestinations'][0]['departureDateTimeRange']['date']);
        switch ($searchCriteria['searchType']) {
            case 'one-way':
                $negFareQuery->whereRaw("FIND_IN_SET(?, from_airports)", [$searchCriteria['originDestinations'][0]['originLocationCode']]);
                $negFareQuery->whereRaw("FIND_IN_SET(?, to_airports)", [$searchCriteria['originDestinations'][0]['destinationLocationCode']]);
                $negFareQuery->where('from_date', '<=', $travelStartDate);
                $negFareQuery->where('to_date', '>=', $travelStartDate);
                break;
            case 'round-trip':
                $travelEndDate = Carbon::parse($searchCriteria['originDestinations'][1]['departureDateTimeRange']['date']);
                $negFareQuery->whereRaw("FIND_IN_SET(?, from_airports)", [$searchCriteria['originDestinations'][0]['originLocationCode']]);
                $negFareQuery->whereRaw("FIND_IN_SET(?, to_airports)", [$searchCriteria['originDestinations'][0]['destinationLocationCode']]);
                $negFareQuery->where('from_date', '<=', $travelStartDate);
                $negFareQuery->where('to_date', '>=', $travelEndDate);
                break;
            case 'multi-city':
                foreach ($searchCriteria['originDestinations'] as $key => $originDestination) {
                    $travelDate = Carbon::parse($originDestination['departureDateTimeRange']['date']);
                    $negFareQuery->whereRaw("FIND_IN_SET(?, from_airports)", [$originDestination['originLocationCode']]);
                    $negFareQuery->whereRaw("FIND_IN_SET(?, to_airports)", [$originDestination['destinationLocationCode']]);
                    $negFareQuery->where('from_date', '<=', $travelDate);
                    $negFareQuery->where('to_date', '>=', $travelDate);
                }
                break;
        }
        $negFareResult = $negFareQuery->get();
        if (count($negFareResult) > 0) {
            $hasNegFare = true;
        }
        return $hasNegFare;
    }

    public function hasTourCodeApplicable($searchCriteria)
    {
        $hasTourCode = false;
        $tourCodeQuery = TourCode::where('status', 1);
        $travelStartDate = Carbon::parse($searchCriteria['originDestinations'][0]['departureDateTimeRange']['date']);
        switch ($searchCriteria['searchType']) {
            case 'one-way':
                $tourCodeQuery->whereRaw("FIND_IN_SET(?, from_airports)", [$searchCriteria['originDestinations'][0]['originLocationCode']]);
                $tourCodeQuery->whereRaw("FIND_IN_SET(?, to_airports)", [$searchCriteria['originDestinations'][0]['destinationLocationCode']]);
                $tourCodeQuery->where('from_date', '<=', $travelStartDate);
                $tourCodeQuery->where('to_date', '>=', $travelStartDate);
                break;
            case 'round-trip':
                $travelEndDate = Carbon::parse($searchCriteria['originDestinations'][1]['departureDateTimeRange']['date']);
                $tourCodeQuery->whereRaw("FIND_IN_SET(?, from_airports)", [$searchCriteria['originDestinations'][0]['originLocationCode']]);
                $tourCodeQuery->whereRaw("FIND_IN_SET(?, to_airports)", [$searchCriteria['originDestinations'][0]['destinationLocationCode']]);
                $tourCodeQuery->where('from_date', '<=', $travelStartDate);
                $tourCodeQuery->where('to_date', '>=', $travelEndDate);
                break;
            case 'multi-city':
                foreach ($searchCriteria['originDestinations'] as $key => $originDestination) {
                    $travelDate = Carbon::parse($originDestination['departureDateTimeRange']['date']);
                    $tourCodeQuery->whereRaw("FIND_IN_SET(?, from_airports)", [$originDestination['originLocationCode']]);
                    $tourCodeQuery->whereRaw("FIND_IN_SET(?, to_airports)", [$originDestination['destinationLocationCode']]);
                    $tourCodeQuery->where('from_date', '<=', $travelDate);
                    $tourCodeQuery->where('to_date', '>=', $travelDate);
                }
                break;
        }
        $tourCodeResult = $tourCodeQuery->get();
        if (count($tourCodeResult) > 0) {
            $hasTourCode = true;
        }
        return $hasTourCode;
    }

    public function checkBrandedFareExists($flight)
    {
        $brandedFareExists = false;
        foreach ($flight['travelerPricings'] as $travelerPricing) {
            if (isset($travelerPricing['fareDetailsBySegment'])) {
                foreach ($travelerPricing['fareDetailsBySegment'] as $fareDetail) {
                    if (isset($fareDetail['amenities'])) {
                        foreach ($fareDetail['amenities'] as $amenity) {
                            if ($amenity['amenityType'] === 'BRANDED_FARES' && $amenity['isChargeable']) {
                                $brandedFareExists = true;
                            }
                        }
                    }
                }
            }
        }
        return $brandedFareExists;
    }

    public function checkBaggageExists($flight)
    {
        foreach ($flight['travelerPricings'] as $travelerPricing) {
            if (!empty($travelerPricing['fareDetailsBySegment'])) {
                foreach ($travelerPricing['fareDetailsBySegment'] as $segment) {
                    if (!empty($segment['amenities'])) {
                        foreach ($segment['amenities'] as $amenity) {
                            if (
                                isset($amenity['amenityType']) &&
                                strtoupper($amenity['amenityType']) === 'BAGGAGE'
                            ) {
                                $description = $amenity['description'];
                                $isChargeable = $amenity['isChargeable'];
                                $descLower = strtolower($description);

                                $shouldProcess = true;
                                $isForcedHandBag = false;

                                // Skip golf bags
                                if (str_contains($descLower, 'golf')) {
                                    $shouldProcess = false;
                                }

                                // Check if it's a hand bag
                                if (str_contains($descLower, 'hand bag')) {
                                    $isForcedHandBag = true;
                                }

                                // Skip other chargeable baggage (but not hand bag)
                                if ($isChargeable && !$isForcedHandBag) {
                                    $shouldProcess = false;
                                }

                                // Forced hand bag processing
                                if ($isForcedHandBag && $shouldProcess) {
                                }

                                // Normal baggage processing
                                if (!$isForcedHandBag && $shouldProcess) {
                                    // Extract KG and PC
                                    $kgMatch = [];
                                    $pcMatch = [];
                                    $kg = null;
                                    $qty = null;

                                    if (preg_match('/(\d+)\s*KG/i', $description, $kgMatch)) {
                                        $kg = (int) $kgMatch[1];
                                    }
                                    if (preg_match('/(\d+)\s*PC/i', $description, $pcMatch)) {
                                        $qty = (int) $pcMatch[1];
                                    }

                                    // Determine baggage type
                                    $isCabin = false;
                                    $isChecked = false;
                                    $checkCabin = false;
                                    if (str_contains($descLower, 'cabin')) {
                                        $isCabin = true;
                                    } elseif (str_contains($descLower, 'checked')) {
                                        $isChecked = true;
                                    } elseif (!is_null($kg)) {
                                        $isCabin = ($kg <= 10);
                                        $isChecked = !$isCabin;
                                    } else {
                                        $isCabin = false;
                                    }

                                    $isQty = !is_null($qty) || !is_null($kg);

                                    // if ($isCabin) {

                                    //     if (!is_null($kg)) {
                                    //         return true;
                                    //     }
                                    //     if (!is_null($qty)) {
                                    //         return true;
                                    //     }
                                    // } else {
                                    //     if (array_key_exists('includedCabinBags', $segment)) {
                                    //         if (is_array($segment['includedCabinBags'])) {
                                    //             if (array_key_exists('quantity', $segment['includedCabinBags'])) {
                                    //                 $qty = (int) $segment['includedCabinBags']['quantity'];

                                    //                 return $qty > 0;
                                    //             } else if (array_key_exists('weight',$segment['includedCabinBags'])) {
                                    //                 $weight = (int) $segment['includedCabinBags']['weight'];

                                    //                 return  $weight > 0;
                                    //             }
                                    //         }
                                    //     } 
                                    // }

                                    if ($isChecked) {

                                        if (!is_null($kg)) {
                                            return true;
                                        }
                                        if (!is_null($qty)) {
                                            return true;
                                        }
                                    } else {
                                        if (array_key_exists('includedCheckedBags', $segment)) {

                                            if (is_array($segment['includedCheckedBags'])) {
                                                if (array_key_exists('quantity', $segment['includedCheckedBags'])) {
                                                    $qty = (int) $segment['includedCheckedBags']['quantity'];

                                                    return $qty > 0;
                                                } elseif (array_key_exists('weight', $segment['includedCheckedBags'])) {
                                                    $weight = (int) $segment['includedCheckedBags']['weight'];
                                                    return $weight > 0;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }


            if (isset($segment['includedCheckedBags'])) {

                if (!empty($segment['includedCheckedBags'])) {
                    if (array_key_exists('quantity', $segment['includedCheckedBags'])) {
                        $qty = (int) $segment['includedCheckedBags']['quantity'];

                        return  $qty > 0;
                    } elseif (array_key_exists('weight', $segment['includedCheckedBags'])) {
                        $weight = (int) $segment['includedCheckedBags']['weight'];

                        return $weight > 0;
                    }
                }
            }
        }
        return false;
    }

    public function createBrandedFarenew(&$flightOffer){
        return BrandedFareService::createBrandedFare($flightOffer, true);
    }




    public function createBrandedFare(&$flightOffer, $isBrandedFare)
    {
        $id = $flightOffer['id'];
        $price = $flightOffer['price']['grandTotal'];
        $travelerPricing = $flightOffer['travelerPricings'][0];
        $fareSegment = $travelerPricing['fareDetailsBySegment'][0];
        $title = strtolower($fareSegment['cabin']);
        if (array_key_exists('brandedFare', $fareSegment)) {
            $title .= ' ' . $fareSegment['brandedFare'];
        }
        $title = ucwords($title);
        $tempBrandedFare = [
            "meals" => [
                "status" => false,
                "chargeable" => false,
            ],
            "beverage" => [
                "status" => false,
                "chargeable" => false,
            ],
            "cabinBaggage" => [
                "status" => false,
                "chargeable" => false,
                "chargeableKg" => 0,
                "qty" => '',
                "isQty" => false
            ],
            "firstCheckedBaggage" => [
                "status" => false,
                "chargeable" => false,
                "chargeableKg" => 0,
                "qty" => '',
                "isQty" => false
            ],
            "isSecondCheckedBaggage" => false,
            "secondCheckedBaggage" => [
                "status" => false,
                "chargeable" => false,
                "chargeableKg" => 0,
                "qty" => '',
                "isQty" => false
            ],
            "refundable" => [
                "status" => false,
                "withFees" => false
            ],
            "changeable" => [
                "status" => false,
                "withFees" => false
            ],
            // Newly Added
            "basicSeat" => [
                "status" => false,
                "withFees" => false
            ],
            "upgradeEligibility" => [
                "status" => false,
                "withFees" => false
            ],
            "changeFee" => [
                "status" => false,
                "withFees" => false
            ],
            "refundableTicket" => [
                "status" => false,
                "withFees" => false
            ],
            "changeableTicket" => [
                "status" => false,
                "withFees" => false
            ],
            "extraLegRoomSeats" => [
                "status" => false,
                "withFees" => false
            ],
            "preferredSeats" => [
                "status" => false,
                "withFees" => false
            ],
            "cancellation" => [
                "status" => false,
                "withFees" => false
            ],
            "premiumSeat" => [
                "status" => false,
                "withFees" => false
            ],
            "milesEarned" => [
                "status" => false,
                "withFees" => false,
                'earned' => '',
            ],
            "milleageAccrual" => [
                "status" => false,
                "withFees" => false,
                'earned' => '',
            ],
        ];
        global $hasCabinBaggage, $hasFirstCheckedBaggage, $hasFirstCheckedBaggage, $hasCheckedBaggage;
        $hasCabinBaggage = false;
        $hasFirstCheckedBaggage = false;
        $hasCheckedBaggage = false;
        /*** 28/05/2025  As per Khaled's suggestion, we will use the following code to check if the baggage is available or not. Khaled Suggestion are..
          Unfortunately, this issue comes from Amadeus, as it returns the baggage info in the same format provided by the airline. So we need to handle this logic on our side.
 
            Here’s how we differentiate between cabin and checked baggage:
            • If there’s no weight mentioned, we assume it’s cabin baggage.
            • If the weight is less than or equal to 10kg, we also treat it as cabin baggage.
            • If the weight is more than 10kg, then it’s considered checked baggage.
            
            So based on this logic, if the amenityType says “Baggage” and no weight is specified, we treat it as cabin baggage.But if a weight is mentioned and it’s over 10kg, we treat it as checked baggage. 

            02-06-2025 - In the amenties you can't find the weight for the checked baggage so you have to get it from
            ````"includedCheckedBags": {
                  "weight": 30,
                  "weightUnit": "KG"
               },```
         ***/
        if (array_key_exists('amenities', $travelerPricing['fareDetailsBySegment'][0])) {
            foreach ($travelerPricing['fareDetailsBySegment'][0]['amenities'] as $amenity) {
                $descriptionChunks = explode(' ', $amenity['description']);
                if (stristr($amenity['amenityType'], 'BAGGAGE')) {
                    $description = $amenity['description'];
                    $isChargeable = $amenity['isChargeable'];
                    $descLower = strtolower($description);

                    $shouldProcess = true;
                    $isForcedHandBag = false;

                    // Skip golf bags
                    if (str_contains($descLower, 'golf')) {
                        $shouldProcess = false;
                    }

                    // Check if it's a hand bag
                    if (str_contains($descLower, 'hand bag')) {
                        $isForcedHandBag = true;
                    }

                    // Skip other chargeable baggage (but not hand bag)
                    if ($isChargeable && !$isForcedHandBag) {
                        $shouldProcess = false;
                    }

                    // Forced hand bag processing
                    if ($isForcedHandBag && $shouldProcess) {
                        $tempBrandedFare['cabinBaggage']['status'] = true;
                        $tempBrandedFare['cabinBaggage']['chargeable'] = false;
                        $tempBrandedFare['cabinBaggage']['isQty'] = true;
                        $tempBrandedFare['cabinBaggage']['chargeableKg'] = 7;
                    }

                    // Normal baggage processing
                    if (!$isForcedHandBag && $shouldProcess) {
                        // Extract KG and PC
                        $kgMatch = [];
                        $pcMatch = [];
                        $kg = null;
                        $qty = null;

                        if (preg_match('/(\d+)\s*KG/i', $description, $kgMatch)) {
                            $kg = (int) $kgMatch[1];
                        }
                        if (preg_match('/(\d+)\s*PC/i', $description, $pcMatch)) {
                            $qty = (int) $pcMatch[1];
                        }

                        // Determine baggage type
                        $isCabin = false;
                        $isChecked = false;
                        $checkCabin = false;
                        if (str_contains($descLower, 'cabin')) {
                            $isCabin = true;
                        } elseif (str_contains($descLower, 'checked')) {
                            $isChecked = true;
                        } elseif (!is_null($kg)) {
                            $isCabin = ($kg <= 10);
                            $isChecked = !$isCabin;
                        } else {
                            $isCabin = false;
                        }

                        $isQty = !is_null($qty) || !is_null($kg);

                        if ($isCabin) {
                            $hasCabinBaggage = true;
                            $tempBrandedFare['cabinBaggage']['status'] = true;
                            $tempBrandedFare['cabinBaggage']['chargeable'] = $isChargeable;
                            $tempBrandedFare['cabinBaggage']['isQty'] = $isQty;
                            if (!is_null($kg)) {
                                $tempBrandedFare['cabinBaggage']['chargeableKg'] = $kg;
                            }
                            if (!is_null($qty)) {
                                $tempBrandedFare['cabinBaggage']['qty'] = $qty;
                            }
                        } else {
                            if (array_key_exists('includedCabinBags', $fareSegment)) {
                                $tempBrandedFare['cabinBaggage']['status'] = true;
                                $tempBrandedFare['cabinBaggage']['chargeable'] = false;
                                $tempBrandedFare['cabinBaggage']['chargeableKg'] = 0;
                                if (is_array($fareSegment['includedCabinBags'])) {
                                    if (array_key_exists('quantity', $fareSegment['includedCabinBags'])) {
                                        $qty = (int) $fareSegment['includedCabinBags']['quantity'];
                                        $tempBrandedFare['cabinBaggage']['status'] = $qty > 0;
                                        $tempBrandedFare['cabinBaggage']['qty'] = $qty;
                                        $tempBrandedFare['cabinBaggage']['isQty'] = $qty > 0;
                                    } else if (array_key_exists('weight', $fareSegment['includedCabinBags'])) {
                                        $weight = (int) $fareSegment['includedCabinBags']['weight'];
                                        $unit = $fareSegment['includedCabinBags']['weightUnit'] ?? '';
                                        $tempBrandedFare['cabinBaggage']['status'] = $weight > 0;
                                        $tempBrandedFare['cabinBaggage']['qty'] = $weight > 0 ? "$weight $unit" : 'No';
                                        $tempBrandedFare['cabinBaggage']['isQty'] = $weight > 0;
                                    }
                                    $hasCabinBaggage =  true;
                                }
                            }
                            // else {
                            //     $hasCabinBaggage = true;
                            //     $tempBrandedFare['cabinBaggage']['status'] = true;
                            //     $tempBrandedFare['cabinBaggage']['chargeable'] = $isChargeable;
                            //     $tempBrandedFare['cabinBaggage']['isQty'] = $isQty;
                            //     if (!is_null($kg)) {
                            //         $tempBrandedFare['cabinBaggage']['chargeableKg'] = $kg;
                            //     }
                            //     if (!is_null($qty)) {
                            //         $tempBrandedFare['cabinBaggage']['qty'] = $qty;
                            //     }
                            // }
                        }

                        if ($isChecked) {
                            $hasFirstCheckedBaggage = true;
                            $tempBrandedFare['firstCheckedBaggage']['status'] = true;
                            $tempBrandedFare['firstCheckedBaggage']['chargeable'] = $isChargeable;
                            $tempBrandedFare['firstCheckedBaggage']['isQty'] = $isQty;
                            if (!is_null($kg)) {
                                $flightOffer['isKgInCheckedBaggage'] = true;
                                $tempBrandedFare['firstCheckedBaggage']['chargeableKg'] = $kg;
                            }
                            if (!is_null($qty)) {
                                $flightOffer['isKgInCheckedBaggage'] = false;
                                $tempBrandedFare['firstCheckedBaggage']['qty'] = $qty;
                            }
                        } else {
                            if (array_key_exists('includedCheckedBags', $fareSegment)) {
                                $tempBrandedFare['firstCheckedBaggage']['status'] = true;
                                $tempBrandedFare['firstCheckedBaggage']['chargeable'] = false;
                                $tempBrandedFare['firstCheckedBaggage']['chargeableKg'] = 0;
                                if (is_array($fareSegment['includedCheckedBags'])) {
                                    if (array_key_exists('quantity', $fareSegment['includedCheckedBags'])) {
                                        $qty = (int) $fareSegment['includedCheckedBags']['quantity'];
                                        $tempBrandedFare['firstCheckedBaggage']['status'] = $qty > 0;
                                        $tempBrandedFare['firstCheckedBaggage']['qty'] = $qty;
                                        $tempBrandedFare['firstCheckedBaggage']['isQty'] = $qty > 0;
                                        $hasFirstCheckedBaggage = $qty > 0;
                                        $flightOffer['isKgInCheckedBaggage'] = false;
                                    } elseif (array_key_exists('weight', $fareSegment['includedCheckedBags'])) {
                                        $weight = (int) $fareSegment['includedCheckedBags']['weight'];
                                        $unit = $fareSegment['includedCheckedBags']['weightUnit'] ?? '';
                                        $tempBrandedFare['firstCheckedBaggage']['status'] = $weight > 0;
                                        $tempBrandedFare['firstCheckedBaggage']['qty'] = $weight > 0 ? "$weight $unit" : 'No';
                                        $tempBrandedFare['firstCheckedBaggage']['isQty'] = $weight > 0;
                                        $hasFirstCheckedBaggage = $weight > 0;
                                        $flightOffer['isKgInCheckedBaggage'] = $weight > 0;
                                    }
                                }

                                $hasFirstCheckedBaggage = true;
                            }
                        }
                    }
                }



                if (stristr($amenity['description'], 'BEVERAGE')) {
                    $tempBrandedFare['beverage']['status'] = true;
                    $tempBrandedFare['beverage']['chargeable'] = $amenity['isChargeable'];
                }
                if (stristr($amenity['amenityType'], 'MEAL')) {
                    $tempBrandedFare['meals']['status'] = true;
                    $tempBrandedFare['meals']['chargeable'] = $amenity['isChargeable'];
                }  
                if (stristr($amenity['description'], 'REFUNDABLE') || stristr($amenity['description'], 'REFUND')) {
                    $tempBrandedFare['refundable']['status'] = true;
                    $tempBrandedFare['refundable']['withFees'] = $amenity['isChargeable'];
                }
                if (stristr($amenity['description'], 'CHANGEABLE') || stristr($amenity['description'], 'CHANGE')) {
                    $tempBrandedFare['changeable']['status'] = true;
                    $tempBrandedFare['changeable']['withFees'] = $amenity['isChargeable'];
                }
                // Newly Added
                if (stristr($amenity['description'], 'BASIC SEAT')) {
                    $tempBrandedFare['basicSeat']['status'] = true;
                    $tempBrandedFare['basicSeat']['withFees'] = $amenity['isChargeable'];
                }
                if (stristr($amenity['description'], 'UPGRADE ELIGIBILITY')) {
                    $tempBrandedFare['upgradeEligibility']['status'] = true;
                    $tempBrandedFare['upgradeEligibility']['withFees'] = $amenity['isChargeable'];
                } 
                if (stristr($amenity['description'], 'CHANGE FEE') || $amenity['description'] == 'NO SHOW') {
                    $tempBrandedFare['changeFee']['status'] = true;
                    $tempBrandedFare['changeFee']['withFees'] = $amenity['isChargeable'];

                    // for changeable
                    $tempBrandedFare['changeable']['status'] = true;
                    $tempBrandedFare['changeable']['withFees'] = $amenity['isChargeable'];
                }
                if (stristr($amenity['description'], 'REFUNDABLE TICKET')) {
                    $tempBrandedFare['refundableTicket']['status'] = true;
                    $tempBrandedFare['refundableTicket']['withFees'] = $amenity['isChargeable'];

                     // for refundable
                    $tempBrandedFare['refundable']['status'] = true;
                    $tempBrandedFare['refundable']['withFees'] = $amenity['isChargeable'];
                }
                if (stristr($amenity['description'], 'CHANGEABLE TICKET')) {
                    $tempBrandedFare['changeableTicket']['status'] = true;
                    $tempBrandedFare['changeableTicket']['withFees'] = $amenity['isChargeable'];

                     // for changeable
                    $tempBrandedFare['changeable']['status'] = true;
                    $tempBrandedFare['changeable']['withFees'] = $amenity['isChargeable'];
                }
                if (stristr($amenity['description'], 'EXTRA LEGROOM SEATS')) {
                    $tempBrandedFare['extraLegRoomSeats']['status'] = true;
                    $tempBrandedFare['extraLegRoomSeats']['withFees'] = $amenity['isChargeable'];
                }
                if (stristr($amenity['description'], 'PREFERRED SEATS')) {
                    $tempBrandedFare['preferredSeats']['status'] = true;
                    $tempBrandedFare['preferredSeats']['withFees'] = $amenity['isChargeable'];
                }
                if (stristr($amenity['description'], 'CANCELLATION')) {
                    $tempBrandedFare['cancellation']['status'] = true;
                    $tempBrandedFare['cancellation']['withFees'] = $amenity['isChargeable'];
                    // for refundable
                    $tempBrandedFare['refundable']['status'] = true;
                    $tempBrandedFare['refundable']['withFees'] = $amenity['isChargeable'];
                }
                if (stristr($amenity['description'], 'PREMIUM SEAT')) {
                    $tempBrandedFare['premiumSeat']['status'] = true;
                    $tempBrandedFare['premiumSeat']['withFees'] = $amenity['isChargeable'];
                }
                if (stristr($amenity['description'], 'MILEAGE ACCRUAL')) {
                    $tempBrandedFare['milleageAccrual']['status'] = true;
                    $tempBrandedFare['milleageAccrual']['withFees'] = $amenity['isChargeable'];
                }
                if (stristr($amenity['description'], 'PERCENT MILES EARNED')) {
                    $tempBrandedFare['milesEarned']['status'] = true;
                    $tempBrandedFare['milesEarned']['withFees'] = $amenity['isChargeable'];

                    $descriptionChunks = explode(' ', $amenity['description']);

                    foreach ($descriptionChunks as $index => $word) {
                        if (strtoupper($word) === 'PERCENT' && $index > 0 && is_numeric($descriptionChunks[$index - 1])) {
                            $tempBrandedFare['milesEarned']['earned'] = (int) $descriptionChunks[$index - 1];
                            break;
                        }
                    }
                }
            }
        }
        if (!$hasCabinBaggage) {

            if (array_key_exists('includedCabinBags', $fareSegment)) {
                $tempBrandedFare['cabinBaggage']['status'] = true;
                $tempBrandedFare['cabinBaggage']['chargeable'] = false;
                $tempBrandedFare['cabinBaggage']['chargeableKg'] = 0;
                if (is_array($fareSegment['includedCabinBags'])) {
                    if (array_key_exists('quantity', $fareSegment['includedCabinBags'])) {
                        $qty = (int) $fareSegment['includedCabinBags']['quantity'];
                        $tempBrandedFare['cabinBaggage']['status'] = $qty > 0;
                        $tempBrandedFare['cabinBaggage']['qty'] = $qty;
                        $tempBrandedFare['cabinBaggage']['isQty'] = $qty > 0;
                    } else if (array_key_exists('weight', $fareSegment['includedCabinBags'])) {
                        $weight = (int) $fareSegment['includedCabinBags']['weight'];
                        $unit = $fareSegment['includedCabinBags']['weightUnit'] ?? '';
                        $tempBrandedFare['cabinBaggage']['status'] = $weight > 0;
                        $tempBrandedFare['cabinBaggage']['qty'] = $weight > 0 ? "$weight $unit" : 'No';
                        $tempBrandedFare['cabinBaggage']['isQty'] = $weight > 0;
                    }
                    $hasCabinBaggage =  true;
                }
            }
        }
        if (!$hasCheckedBaggage) {
            if (array_key_exists('includedCheckedBags', $fareSegment)) {
                $tempBrandedFare['firstCheckedBaggage']['status'] = true;
                $tempBrandedFare['firstCheckedBaggage']['chargeable'] = false;
                $tempBrandedFare['firstCheckedBaggage']['chargeableKg'] = 0;
                if (is_array($fareSegment['includedCheckedBags'])) {
                    if (array_key_exists('quantity', $fareSegment['includedCheckedBags'])) {
                        $qty = (int) $fareSegment['includedCheckedBags']['quantity'];
                        $tempBrandedFare['firstCheckedBaggage']['status'] = $qty > 0;
                        $tempBrandedFare['firstCheckedBaggage']['qty'] = $qty;
                        $tempBrandedFare['firstCheckedBaggage']['isQty'] = $qty > 0;
                        $hasFirstCheckedBaggage = $qty > 0;
                        $flightOffer['isKgInCheckedBaggage'] = false;
                    } elseif (array_key_exists('weight', $fareSegment['includedCheckedBags'])) {
                        $weight = (int) $fareSegment['includedCheckedBags']['weight'];
                        $unit = $fareSegment['includedCheckedBags']['weightUnit'] ?? '';
                        $tempBrandedFare['firstCheckedBaggage']['status'] = $weight > 0;
                        $tempBrandedFare['firstCheckedBaggage']['qty'] = $weight > 0 ? "$weight $unit" : 'No';
                        $tempBrandedFare['firstCheckedBaggage']['isQty'] = $weight > 0;
                        $hasFirstCheckedBaggage = $weight > 0;
                        $flightOffer['isKgInCheckedBaggage'] = $weight > 0;
                    }
                }

                $hasFirstCheckedBaggage = true;
            }
        }
        $brandedFare = [
            "id" => $id,
            "title" => $title,
            "price" => $price,
            "beverage" => [
                "status" => false,
                "chargeable" => false,
                "description_ar" => "",
                "description_en" => "",
            ],
            "meals" => [
                "status" => false,
                "chargeable" => false,
                "description_ar" => "",
                "description_en" => "",
            ],
            "cabinBaggage" => [
                "status" => false,
                "chargeable" => false,
                "description_ar" => "",
                "description_en" => "",
            ],
            "checkedBaggage" => [
                [
                    "status" => false,
                    "chargeable" => false,
                    "description_ar" => "",
                    "description_en" => "",
                    "additional_description_en" => $tempBrandedFare['firstCheckedBaggage']['status'] ? "2 Piece, Airline usually Permits 23 KG Per Bags" : "",
                    "additional_description_ar" => $tempBrandedFare['firstCheckedBaggage']['status'] ? "قطعتين، عادةً ما تسمح شركة الطيران بـ 23 كجم لكل حقيبة " : "",
                ]
            ],
            "refundable" => [
                "status" => false,
                "chargeable" => false,
                "description_ar" => "",
                "description_en" => "",
            ],
            "changeable" => [
                "status" => false,
                "chargeable" => false,
                "description_ar" => "",
                "description_en" => "",
            ],
            // Newly Added
            "basicSeat" => [
                "status" => false,
                "chargeable" => false,
                "description_ar" => "",
                "description_en" => "",
            ],
            "upgradeEligibility" => [
                "status" => false,
                "chargeable" => false,
                "description_ar" => "",
                "description_en" => "",
            ],
            "changeFee" => [
                "status" => false,
                "chargeable" => false,
                "description_ar" => "",
                "description_en" => "",
            ],
            "refundableTicket" => [
                "status" => false,
                "chargeable" => false,
                "description_ar" => "",
                "description_en" => "",
            ],
            "changeableTicket" => [
                "status" => false,
                "chargeable" => false,
                "description_ar" => "",
                "description_en" => "",
            ],
            "extraLegRoomSeats" => [
                "status" => false,
                "chargeable" => false,
                "description_ar" => "",
                "description_en" => "",
            ],
            "preferredSeats" => [
                "status" => false,
                "chargeable" => false,
                "description_ar" => "",
                "description_en" => "",
            ],
            "cancellation" => [
                "status" => false,
                "chargeable" => false,
                "description_ar" => "",
                "description_en" => "",
            ],
            "premiumSeat" => [
                "status" => false,
                "chargeable" => false,
                "description_ar" => "",
                "description_en" => "",
            ],
            "milesEarned" => [
                "status" => false,
                "chargeable" => false,
                "description_ar" => "",
                "description_en" => "",
            ],
            "milleageAccrual" => [
                "status" => false,
                "chargeable" => false,
                "description_ar" => "",
                "description_en" => "",
            ],
        ];
        $brandedFare['cabinBaggage']['status'] = $tempBrandedFare['cabinBaggage']['status'];
        if ($tempBrandedFare['beverage']['status'] == false) {
            $brandedFare['beverage']['description_ar'] = 'لا يوجد مشروبات متاحة';
            $brandedFare['beverage']['description_en'] = 'No beverage available';
        } else {
            $descriptionAr = 'مشروب مجاني متاح';
            $descriptionEn = 'Free beverage available';
            $brandedFare['beverage']['status'] = $tempBrandedFare['beverage']['status'];
            $brandedFare['beverage']['chargeable'] = $tempBrandedFare['beverage']['chargeable'];
            if ($tempBrandedFare['beverage']['chargeable']) {
                $brandedFare['beverage']['description_ar'] = 'المشروبات متاحة مقابل رسوم';
                $brandedFare['beverage']['description_en'] = 'Beverage available with fees';
            } else {
                $brandedFare['beverage']['description_en'] = $descriptionEn;
                $brandedFare['beverage']['description_ar'] = $descriptionAr;
            }
        }
        if ($tempBrandedFare['meals']['status'] == false) {
            $brandedFare['meals']['description_ar'] = 'لا تتوفر وجبات';
            $brandedFare['meals']['description_en'] = 'No meals available';
        } else {
            $brandedFare['meals']['status'] = $tempBrandedFare['meals']['status'];
            $descriptionAr = 'وجبات مجانية متاحة';
            $descriptionEn = 'Free meals available';
            $brandedFare['meals']['chargeable'] = $tempBrandedFare['meals']['chargeable'];
            if ($tempBrandedFare['meals']['chargeable']) {
                $brandedFare['meals']['description_ar'] = 'الوجبات المتاحة برسوم';
                $brandedFare['meals']['description_en'] = 'Meals available with fees';
            } else {
                $brandedFare['meals']['description_ar'] = $descriptionAr;
                $brandedFare['meals']['description_en'] = $descriptionEn;
            }
        }
        if ($tempBrandedFare['cabinBaggage']['status'] == false) {
            $brandedFare['cabinBaggage']['description_ar'] = 'لا يوجد أمتعة مقصورة';
            $brandedFare['cabinBaggage']['description_en'] = 'No Cabin baggage';
        } else {
            $descriptionAr = $tempBrandedFare['cabinBaggage']['qty'] . 'أمتعة المقصورة';
            $descriptionEn = $tempBrandedFare['cabinBaggage']['qty'] . ' Cabin baggage';

            $brandedFare['cabinBaggage']['chargeable'] = $tempBrandedFare['cabinBaggage']['chargeable'];

            $kg = trim($tempBrandedFare['cabinBaggage']['chargeableKg']);
            $kgNormalized = strtolower(preg_replace('/\s+/', '', $kg . 'kg'));

            $enNormalized = strtolower(preg_replace('/\s+/', '', $descriptionEn));
            $arNormalized = strtolower(preg_replace('/\s+/', '', $descriptionAr));

            if ($kg && strpos($enNormalized, $kgNormalized) === false) {
                $descriptionEn = $kg . ' kg ' . $descriptionEn;
            }

            if ($kg && strpos($arNormalized, $kgNormalized) === false) {
                $descriptionAr = $kg . ' كجم ' . $descriptionAr;
            }

            if ($tempBrandedFare['cabinBaggage']['chargeable']) {
                $descriptionAr .= ' قابلة للشحن';
                $descriptionEn .= ' chargeable';
            }

            $brandedFare['cabinBaggage']['description_ar'] = $descriptionAr;
            $brandedFare['cabinBaggage']['description_en'] = $descriptionEn;
        }

        if ($tempBrandedFare['isSecondCheckedBaggage'] == false) {
            $brandedFare['checkedBaggage'][0]['status'] = $tempBrandedFare['firstCheckedBaggage']['status'];



            if ($tempBrandedFare['firstCheckedBaggage']['status'] == false) {
                $flightOffer['isKgInCheckedBaggage'] = false;
                $brandedFare['checkedBaggage'][0]['description_ar'] = 'لا يوجد أمتعة مسجلة';
                $brandedFare['checkedBaggage'][0]['description_en'] = 'No Checked baggage';
            } else {
                $descriptionAr = $tempBrandedFare['firstCheckedBaggage']['qty'] . 'الأمتعة المسجلة';
                $descriptionEn = $tempBrandedFare['firstCheckedBaggage']['qty'] . ' Checked baggage';

                // Extract {"quantity":1} from description
                if (preg_match('/\{.*?"quantity"\s*:\s*(\d+).*?\}(.*)/', $descriptionEn, $matches)) {
                    $descriptionEn = trim($matches[1] . ' ' . $matches[2]);
                } else {
                    $descriptionEn = trim($descriptionEn);
                }

                $brandedFare['checkedBaggage'][0]['chargeable'] = $tempBrandedFare['firstCheckedBaggage']['chargeable'];
                if ($tempBrandedFare['firstCheckedBaggage']['chargeableKg'] > 0) {

                    $descriptionAr = $tempBrandedFare['firstCheckedBaggage']['chargeableKg'] . ' ' . 'كجم' . ' ' . $descriptionAr;
                    $descriptionEn = $tempBrandedFare['firstCheckedBaggage']['chargeableKg'] . ' kg ' . $descriptionEn;
                }

                if ($tempBrandedFare['firstCheckedBaggage']['chargeable']) {
                    $descriptionAr .= ' ' . 'قابلة للشحن';
                    $descriptionEn .= ' chargeable';
                }
                $brandedFare['checkedBaggage'][0]['description_ar'] = $descriptionAr;
                $brandedFare['checkedBaggage'][0]['description_en'] = $descriptionEn;
            }
        } else {
            $brandedFare['checkedBaggage'][0]['status'] = $tempBrandedFare['firstCheckedBaggage']['status'];
            if ($tempBrandedFare['firstCheckedBaggage']['status'] == false) {
                $brandedFare['checkedBaggage'][0]['description_ar'] = 'الحقيبة الأولى: لا توجد أمتعة مسجلة';
                $brandedFare['checkedBaggage'][0]['description_en'] = 'First bag: No Checked baggage';
            } else {
                $descriptionAr = 'الحقيبة الأولى: الأمتعة المسجلة';
                $descriptionEn = 'First bag: Checked baggage';
                $brandedFare['checkedBaggage'][0]['chargeable'] = $tempBrandedFare['firstCheckedBaggage']['chargeable'];
                if ($tempBrandedFare['firstCheckedBaggage']['chargeableKg'] > 0) {
                    $descriptionAr = str_replace('{{kg}}', $tempBrandedFare['firstCheckedBaggage']['chargeableKg'], 'الحقيبة الأولى: {{kg}} كجم من الأمتعة المسجلة');
                    $descriptionEn = 'First bag: ' . $tempBrandedFare['firstCheckedBaggage']['chargeableKg'] . ' kg checked baggage';
                }
                if ($tempBrandedFare['firstCheckedBaggage']['chargeable']) {
                    $descriptionAr .= ' ' . 'قابلة للشحن';
                    $descriptionEn .= ' chargeable';
                }
                $brandedFare['checkedBaggage'][0]['description_ar'] = $descriptionAr;
                $brandedFare['checkedBaggage'][0]['description_en'] = $descriptionEn;
            }
            $brandedFare['checkedBaggage'][1]['status'] = $tempBrandedFare['secondCheckedBaggage']['status'];
            if ($tempBrandedFare['secondCheckedBaggage']['status'] == false) {
                $brandedFare['checkedBaggage'][1]['description_ar'] = 'الحقيبة الثانية: لا توجد أمتعة مسجلة';
                $brandedFare['checkedBaggage'][1]['description_en'] = 'Second bag: No Checked baggage';
            } else {
                $descriptionAr = 'الحقيبة الثانية: الأمتعة المسجلة';
                $descriptionEn = 'Second bag: Checked baggage';
                $brandedFare['checkedBaggage'][1]['chargeable'] = $tempBrandedFare['secondCheckedBaggage']['chargeable'];
                if ($tempBrandedFare['secondCheckedBaggage']['chargeableKg'] > 0) {
                    $descriptionAr = str_replace('{{kg}}', $tempBrandedFare['secondCheckedBaggage']['chargeableKg'], 'الحقيبة الثانية: {{kg}} كجم من الأمتعة المسجلة');
                    $descriptionEn = 'Second bag: ' . $tempBrandedFare['secondCheckedBaggage']['chargeableKg'] . ' kg checked baggage';
                }
                if ($tempBrandedFare['secondCheckedBaggage']['chargeable']) {
                    $descriptionAr .= ' ' . 'قابلة للشحن';
                    $descriptionEn .= ' chargeable';
                }
                $brandedFare['checkedBaggage'][1]['description_ar'] = $descriptionAr;
                $brandedFare['checkedBaggage'][1]['description_en'] = $descriptionEn;
            }
        }

        $brandedFare['refundable']['status'] = $tempBrandedFare['refundable']['status'];
        $brandedFare['refundable']['chargeable'] = $tempBrandedFare['refundable']['withFees'];
        if ($tempBrandedFare['refundable']['status'] == false) {
            $flightOffer['isRefundable'] = false;
            $brandedFare['refundable']['description_ar'] = 'غير قابل للاسترجاع';
            $brandedFare['refundable']['description_en'] = 'Non-refundable';
        } else {
            if ($tempBrandedFare['refundable']['withFees']) {
                $flightOffer['isRefundable'] = $tempBrandedFare['refundable']['withFees'];
                $descriptionAr = 'قابلة للاسترداد مع الرسوم';
                $descriptionEn = 'Refundable with fees';
            } else {
                $flightOffer['isRefundable'] = false;
                $descriptionAr = 'قابلة للاسترداد بدون رسوم';
                $descriptionEn = 'Refundable without fees';
            }
            $brandedFare['refundable']['description_ar'] = $descriptionAr;
            $brandedFare['refundable']['description_en'] = $descriptionEn;
        }

        $brandedFare['changeable']['status'] = $tempBrandedFare['changeable']['status'];
        $brandedFare['changeable']['chargeable'] = $tempBrandedFare['changeable']['withFees'];
        if ($tempBrandedFare['changeable']['status'] == false) {
            $brandedFare['changeable']['description_ar'] = 'أجرة غير قابلة للتغيير';
            $brandedFare['changeable']['description_en'] = 'Non-changeable fare';
        } else {
            if ($tempBrandedFare['changeable']['withFees']) {
                $descriptionAr = 'قابلة للتغيير مع الرسوم';
                $descriptionEn = 'Changeable with fees';
            } else {
                $descriptionAr = 'قابلة للتغيير بدون رسوم';
                $descriptionEn = 'Changeable without fees';
            }
            $brandedFare['changeable']['description_ar'] = $descriptionAr;
            $brandedFare['changeable']['description_en'] = $descriptionEn;
        }
        // Newly Added

        $brandedFare['basicSeat']['status'] = $tempBrandedFare['basicSeat']['status'];
        $brandedFare['basicSeat']['chargeable'] = $tempBrandedFare['basicSeat']['withFees'];
        if ($tempBrandedFare['basicSeat']['status'] == false) {
            $brandedFare['basicSeat']['description_ar'] = 'أجرة غير قابلة للتغيير';
            $brandedFare['basicSeat']['description_en'] = 'Non-changeable fare';
        } else {
            if ($tempBrandedFare['basicSeat']['withFees']) {
                $descriptionAr = 'المقعد الأساسي مع الرسوم';
                $descriptionEn = 'Basic Seat with fees';
            } else {
                $descriptionAr = 'المقعد الأساسي بدون رسوم';
                $descriptionEn = 'Basic Seat without fees';
            }
            $brandedFare['basicSeat']['description_ar'] = $descriptionAr;
            $brandedFare['basicSeat']['description_en'] = $descriptionEn;
        }

        $brandedFare['upgradeEligibility']['status'] = $tempBrandedFare['upgradeEligibility']['status'];
        $brandedFare['upgradeEligibility']['chargeable'] = $tempBrandedFare['upgradeEligibility']['withFees'];
        if ($tempBrandedFare['upgradeEligibility']['status'] == false) {
            $brandedFare['upgradeEligibility']['description_ar'] = 'أجرة غير قابلة للتغيير';
            $brandedFare['upgradeEligibility']['description_en'] = 'Non-changeable fare';
        } else {
            if ($tempBrandedFare['upgradeEligibility']['withFees']) {
                $descriptionAr = 'ترقية الأهلية مع الرسوم';
                $descriptionEn = 'Upgrade Eligibility with fees';
            } else {
                $descriptionAr = 'ترقية الأهلية بدون رسوم';
                $descriptionEn = 'Upgrade Eligibility without fees';
            }
            $brandedFare['upgradeEligibility']['description_ar'] = $descriptionAr;
            $brandedFare['upgradeEligibility']['description_en'] = $descriptionEn;
        }

        $brandedFare['changeFee']['status'] = $tempBrandedFare['changeFee']['status'];
        $brandedFare['changeFee']['chargeable'] = $tempBrandedFare['changeFee']['withFees'];
        if ($tempBrandedFare['changeFee']['status'] == false) {
            $brandedFare['changeFee']['description_ar'] = 'أجرة غير قابلة للتغيير';
            $brandedFare['changeFee']['description_en'] = 'Non-changeable fare';
        } else {
            if ($tempBrandedFare['changeFee']['withFees']) {
                $descriptionAr = 'تغيير الرسوم مع الرسوم';
                $descriptionEn = 'Change Fee with fees';
            } else {
                $descriptionAr = 'رسوم التغيير بدون رسوم';
                $descriptionEn = 'Change Fee without fees';
            }
            $brandedFare['changeFee']['description_ar'] = $descriptionAr;
            $brandedFare['changeFee']['description_en'] = $descriptionEn;
        }

        $brandedFare['refundableTicket']['status'] = $tempBrandedFare['refundableTicket']['status'];
        $brandedFare['refundableTicket']['chargeable'] = $tempBrandedFare['refundableTicket']['withFees'];
        if ($tempBrandedFare['refundableTicket']['status'] == false) {
            $brandedFare['refundableTicket']['description_ar'] = 'أجرة غير قابلة للتغيير';
            $brandedFare['refundableTicket']['description_en'] = 'Non-changeable fare';
        } else {
            if ($tempBrandedFare['refundableTicket']['withFees']) {
                $descriptionAr = 'تذكرة قابلة للاسترداد مع الرسوم';
                $descriptionEn = 'Refundable Ticket with fees';
            } else {
                $descriptionAr = 'تذكرة قابلة للاسترداد بدون رسوم';
                $descriptionEn = 'Refundable Ticket without fees';
            }
            $brandedFare['refundableTicket']['description_ar'] = $descriptionAr;
            $brandedFare['refundableTicket']['description_en'] = $descriptionEn;
        }

        $brandedFare['changeableTicket']['status'] = $tempBrandedFare['changeableTicket']['status'];
        $brandedFare['changeableTicket']['chargeable'] = $tempBrandedFare['changeableTicket']['withFees'];
        if ($tempBrandedFare['changeableTicket']['status'] == false) {
            $brandedFare['changeableTicket']['description_ar'] = 'أجرة غير قابلة للتغيير';
            $brandedFare['changeableTicket']['description_en'] = 'Non-changeable fare';
        } else {
            if ($tempBrandedFare['changeableTicket']['withFees']) {
                $descriptionAr = 'تذكرة قابلة للتغيير مع رسوم';
                $descriptionEn = 'Changeable Ticket with fees';
            } else {
                $descriptionAr = 'تذكرة قابلة للتغيير بدون رسوم';
                $descriptionEn = 'Changeable Ticket without fees';
            }
            $brandedFare['changeableTicket']['description_ar'] = $descriptionAr;
            $brandedFare['changeableTicket']['description_en'] = $descriptionEn;
        }


        $brandedFare['extraLegRoomSeats']['status'] = $tempBrandedFare['extraLegRoomSeats']['status'];
        $brandedFare['extraLegRoomSeats']['chargeable'] = $tempBrandedFare['extraLegRoomSeats']['withFees'];
        if ($tempBrandedFare['extraLegRoomSeats']['status'] == false) {
            $brandedFare['extraLegRoomSeats']['description_ar'] = 'أجرة غير قابلة للتغيير';
            $brandedFare['extraLegRoomSeats']['description_en'] = 'Non-changeable fare';
        } else {
            if ($tempBrandedFare['extraLegRoomSeats']['withFees']) {
                $descriptionAr = 'مقاعد ذات مساحة إضافية للأرجل مع رسوم';
                $descriptionEn = 'Extra LegRoom Seats with fees';
            } else {
                $descriptionAr = 'مقاعد ذات مساحة إضافية للأرجل مع رسوم';
                $descriptionEn = 'Extra LegRoom Seats without fees';
            }
            $brandedFare['extraLegRoomSeats']['description_ar'] = $descriptionAr;
            $brandedFare['extraLegRoomSeats']['description_en'] = $descriptionEn;
        }

        $brandedFare['preferredSeats']['status'] = $tempBrandedFare['preferredSeats']['status'];
        $brandedFare['preferredSeats']['chargeable'] = $tempBrandedFare['preferredSeats']['withFees'];
        if ($tempBrandedFare['preferredSeats']['status'] == false) {
            $brandedFare['preferredSeats']['description_ar'] = 'أجرة غير قابلة للتغيير';
            $brandedFare['preferredSeats']['description_en'] = 'Non-changeable fare';
        } else {
            if ($tempBrandedFare['preferredSeats']['withFees']) {
                $descriptionAr = 'المقاعد المفضلة مع الرسوم';
                $descriptionEn = 'Preferred Seats with fees';
            } else {
                $descriptionAr = 'المقاعد المفضلة بدون رسوم';
                $descriptionEn = 'Preferred Seats without fees';
            }
            $brandedFare['preferredSeats']['description_ar'] = $descriptionAr;
            $brandedFare['preferredSeats']['description_en'] = $descriptionEn;
        }


        $brandedFare['cancellation']['status'] = $tempBrandedFare['cancellation']['status'];
        $brandedFare['cancellation']['chargeable'] = $tempBrandedFare['cancellation']['withFees'];
        if ($tempBrandedFare['cancellation']['status'] == false) {
            $brandedFare['cancellation']['description_ar'] = 'أجرة غير قابلة للتغيير';
            $brandedFare['cancellation']['description_en'] = 'Non-changeable fare';
        } else {
            if ($tempBrandedFare['cancellation']['withFees']) {
                $descriptionAr = 'الإلغاء مع الرسوم';
                $descriptionEn = 'Cancellation with fees';
            } else {
                $descriptionAr = 'الإلغاء بدون رسوم';
                $descriptionEn = 'Cancellation Seats without fees';
            }
            $brandedFare['cancellation']['description_ar'] = $descriptionAr;
            $brandedFare['cancellation']['description_en'] = $descriptionEn;
        }


        $brandedFare['premiumSeat']['status'] = $tempBrandedFare['premiumSeat']['status'];
        $brandedFare['premiumSeat']['chargeable'] = $tempBrandedFare['premiumSeat']['withFees'];
        if ($tempBrandedFare['premiumSeat']['status'] == false) {
            $brandedFare['premiumSeat']['description_ar'] = 'أجرة غير قابلة للتغيير';
            $brandedFare['premiumSeat']['description_en'] = 'Non-changeable fare';
        } else {
            if ($tempBrandedFare['premiumSeat']['withFees']) {
                $descriptionAr = 'مقاعد مميزة برسوم';
                $descriptionEn = 'Premium with fees';
            } else {
                $descriptionAr = 'مقاعد مميزة بدون رسوم';
                $descriptionEn = 'Premium Seats without fees';
            }
            $brandedFare['premiumSeat']['description_ar'] = $descriptionAr;
            $brandedFare['premiumSeat']['description_en'] = $descriptionEn;
        }

        $brandedFare['milesEarned']['status'] = $tempBrandedFare['milesEarned']['status'];
        $brandedFare['milesEarned']['chargeable'] = $tempBrandedFare['milesEarned']['withFees'];
        if ($tempBrandedFare['milesEarned']['status'] == false) {
            $brandedFare['milesEarned']['description_ar'] = 'أجرة غير قابلة للتغيير';
            $brandedFare['milesEarned']['description_en'] = 'Non-changeable fare';
        } else {
            if ($tempBrandedFare['milesEarned']['withFees']) {
                $descriptionAr = '' . $tempBrandedFare['milesEarned']['earned'] . 'الأميال المكتسبة بدون رسوم';
                $descriptionEn = '' . $tempBrandedFare['milesEarned']['earned'] . ' Miles Earned with fees';
            } else {
                $descriptionAr = '' . $tempBrandedFare['milesEarned']['earned'] . 'مقاعد مميزة بدون رسوم';
                $descriptionEn = '' . $tempBrandedFare['milesEarned']['earned'] . ' Miles Earned  without fees';
            }
            $brandedFare['milesEarned']['milesEarned'] = $descriptionAr;
            $brandedFare['milesEarned']['milesEarned'] = $descriptionEn;
        }

        $brandedFare['milleageAccrual']['status'] = $tempBrandedFare['milleageAccrual']['status'];
        $brandedFare['milleageAccrual']['chargeable'] = $tempBrandedFare['milleageAccrual']['withFees'];
        if ($tempBrandedFare['milleageAccrual']['status'] == false) {
            $brandedFare['milleageAccrual']['description_ar'] = 'أجرة غير قابلة للتغيير';
            $brandedFare['milleageAccrual']['description_en'] = 'Non-changeable fare';
        } else {
            if ($tempBrandedFare['milleageAccrual']['withFees']) {
                $descriptionAr = 'استحقاق الأميال مع الرسوم';
                $descriptionEn = 'Milleage Accrual with fees';
            } else {
                $descriptionAr = 'مقاعد مميزة بدون رسوم';
                $descriptionEn = 'Milleage Accrual without fees';
            }
            $brandedFare['milleageAccrual']['milesEarned'] = $descriptionAr;
            $brandedFare['milleageAccrual']['milesEarned'] = $descriptionEn;
        }








        return $brandedFare;
    }

    public function processCalendarSearch($response, $requestData)
    {
        $result = [];
        if (!(array_key_exists('errors', $response) && count($response['errors']))) {
            foreach ($response['data'] as $flightOffer) {
                $dt = $flightOffer['itineraries'][0]['segments'][0]['departure']['at'];
                $dtArr = explode('T', $dt);
                $dt = $dtArr[0];
                if ((array_key_exists($dt, $result) == false) ||
                    (array_key_exists($dt, $result) && $result[$dt] > $flightOffer['price']['grandTotal'])
                ) {
                    $result[$dt] = $flightOffer['price']['grandTotal'];
                }
            }


            // Apply Markup Logic
            $markupSetting = MarkupSetting::first();
            if ($markupSetting && $markupSetting->apply_markup_flight_list == 1) {
                $markups = Markups::where('service_type_id', 1)->get()->toArray();
                $defaultMarkups = DefaultMarkup::where('service_type_id', 1)->get()->toArray();
                $bookingDate = date('Y-m-d');

                $markupDetails = [];

                if (!empty($markups) && !empty($requestData['originDestinations'])) {
                    foreach ($requestData['originDestinations'] as $originDestination) {
                        $departureDate = $originDestination['departureDate'] ?? null;
                        $originLocationCode = $originDestination['originLocationCode'] ?? null;
                        $destinationLocationCode = $originDestination['destinationLocationCode'] ?? null;

                        if ($departureDate && $originLocationCode && $destinationLocationCode) {
                            foreach ($markups as $markup) {
                                if (

                                    ($departureDate >= $markup['from_travel_date'] && $departureDate <= $markup['to_travel_date']) &&
                                    ($destinationLocationCode == $markup['destination_name'] && $originLocationCode == $markup['origin_name'])
                                    ||

                                    ($departureDate >= $markup['from_travel_date'] && $departureDate <= $markup['to_travel_date']) &&
                                    ($markup['origin_criteria'] == 'all' && $markup['destination_criteria'] == 'all')
                                ) {
                                    $markupDetails[] = [
                                        'type' => $markup['b2c_markup_type'],
                                        'from_amount' => (float) $markup['from_price_range'],
                                        'to_amount' => (float) $markup['to_price_range'],
                                        'b2c_amount' => (float) $markup['b2c_markup'],
                                    ];
                                }
                            }
                        }
                    }
                }

                if ($result && !empty($result)) {
                    foreach ($result as $key => &$value) {

                        $markupApplied = false;
                        $highestMarkupAmount = 0;

                        $price = floatval($value);

                        foreach ($markupDetails as $markup) {
                            if (($markup['from_amount'] == 0 && $markup['to_amount'] == 0) ||
                                ($price >= $markup['from_amount'] && $price <= $markup['to_amount'])
                            ) {
                                $currentMarkupAmount = ($markup['type'] === 'percentage')
                                    ? ($price * $markup['b2c_amount']) / 100
                                    : $markup['b2c_amount'];

                                if ($currentMarkupAmount > $highestMarkupAmount) {
                                    $highestMarkupAmount = $currentMarkupAmount;
                                    $markupApplied = true;
                                }
                            }
                        }


                        if ($markupApplied) {
                            $finalAmount = $price + $highestMarkupAmount;
                            $value = $finalAmount;
                        } else {
                            foreach ($defaultMarkups as $defaultMarkup) {
                                $defaultMarkupAmount = ($defaultMarkup['b2c_markup_type'] === 'percentage')
                                    ? ($price * $defaultMarkup['b2c_markup']) / 100
                                    : $defaultMarkup['b2c_markup'];

                                $finalAmount = $price + $defaultMarkupAmount;
                                break;
                            }

                            $value = $finalAmount;
                        }
                    }
                }
            }
            // End of Markup Logic
        }
        return $result;
    }

    public function fetchAirlineData(&$airLineList)
    {
        if (isset($airLineList) && !empty($airLineList)) {
            foreach ($airLineList as &$airlines) {
                if ($airlines && !empty($airlines['logo'])) {
                    $airlines['logo'] = URL::to('/') . '/assets/images/airlineLogo/' . $airlines['code'] . '.png';
                    $airlines['test'] = 'test';
                }
            }
        }
        return $airLineList;
    }

    public function translateFlightBookingDetails(&$bookingDetails, $translatelang)
    {
        $airlines =  $bookingDetails['booking_details']['booking_details']['flightDetails']['airlines'];
        foreach ($airlines as &$airline) {
            foreach ($airline['flights'] as &$flight) {
                // return $airline = $flight['airline']['name'];

                // Airline
                if (isset($flight['airline']['name'])) {
                    $airlineId = AirlineI18ns::where('airline_name', $flight['airline']['name'])->value('airline_id');
                    if ($airlineId) {
                        $airlineName = AirlineI18ns::where('airline_id', $airlineId)->where('language_code', $translatelang)?->value('airline_name');
                        $flight['airline']['name'] = $airlineName ? $airlineName : $flight['airline']['name'];
                    }
                }

                // Arrival Airport Data
                if (isset($flight['arrivalAirportData'])) {
                    if (isset($flight['arrivalAirportData']['airport_name'])) {
                        $airportId = AirportI18ns::where('airport_name', $flight['arrivalAirportData']['airport_name'])->value('airport_id');
                        if ($airportId) {
                            $airportName = AirportI18ns::where('airport_id', $airportId)->where('language_code', $translatelang)?->value('airport_name');
                            $flight['arrivalAirportData']['airport_name'] = $airportName ? $airportName : $flight['arrivalAirportData']['airport_name'];
                        }
                    }

                    if (isset($flight['arrivalAirportData']['city_name'])) {
                        $cityId = CityI18n::where('city_name', $flight['arrivalAirportData']['city_name'])->value('city_id');
                        if ($cityId) {
                            $cityName = CityI18n::where('city_id', $cityId)->where('language_code', $translatelang)?->value('city_name');
                            $flight['arrivalAirportData']['city_name'] = $cityName ? $cityName : $flight['arrivalAirportData']['city_name'];
                        }
                    }
                    if (isset($flight['arrivalAirportData']['country_name'])) {
                        $countryId = CountryI18ns::where('country_name', $flight['arrivalAirportData']['country_name'])->value('country_id');
                        if ($countryId) {
                            $countryName = CountryI18ns::where('country_id', $countryId)->where('language_code', $translatelang)?->value('country_name');
                            $flight['arrivalAirportData']['country_name'] = $countryName ? $countryName : $flight['arrivalAirportData']['country_name'];
                        }
                    }
                }

                // Departure Airport Data
                if (isset($flight['departureAirportData'])) {
                    if (isset($flight['departureAirportData']['airport_name'])) {
                        $airportId = AirportI18ns::where('airport_name', $flight['departureAirportData']['airport_name'])->value('airport_id');
                        if ($airportId) {
                            $airportName = AirportI18ns::where('airport_id', $airportId)->where('language_code', $translatelang)?->value('airport_name');
                            $flight['departureAirportData']['airport_name'] = $airportName ? $airportName : $flight['departureAirportData']['airport_name'];
                        }
                    }

                    if (isset($flight['departureAirportData']['city_name'])) {
                        $cityId = CityI18n::where('city_name', $flight['departureAirportData']['city_name'])->value('city_id');
                        if ($cityId) {
                            $cityName = CityI18n::where('city_id', $cityId)->where('language_code', $translatelang)?->value('city_name');
                            $flight['departureAirportData']['city_name'] = $cityName ? $cityName : $flight['departureAirportData']['city_name'];
                        }
                    }
                    if (isset($flight['departureAirportData']['country_name'])) {
                        $countryId = CountryI18ns::where('country_name', $flight['departureAirportData']['country_name'])->value('country_id');
                        if ($countryId) {
                            $countryName = CountryI18ns::where('country_id', $countryId)->where('language_code', $translatelang)?->value('country_name');
                            $flight['departureAirportData']['country_name'] = $countryName ? $countryName : $flight['departureAirportData']['country_name'];
                        }
                    }
                }

                // Segment
                if (isset($flight['segments'])) {
                    foreach ($flight['segments'] as &$segment) {
                        // Airline
                        if (isset($segment['airlineData']['name'])) {
                            $airlineId = AirlineI18ns::where('airline_name', $segment['airlineData']['name'])->value('airline_id');
                            if ($airlineId) {
                                $airlineName = AirlineI18ns::where('airline_id', $airlineId)->where('language_code', $translatelang)?->value('airline_name');
                                $segment['airlineData']['name'] = $airlineName ? $airlineName : $segment['airlineData']['name'];
                            }
                        }

                        // Arrival Airport Data
                        if (isset($segment['arrivalAirportData'])) {
                            if (isset($segment['arrivalAirportData']['airport_name'])) {
                                $airportId = AirportI18ns::where('airport_name', $segment['arrivalAirportData']['airport_name'])->value('airport_id');
                                if ($airportId) {
                                    $airportName = AirportI18ns::where('airport_id', $airportId)->where('language_code', $translatelang)?->value('airport_name');
                                    $segment['arrivalAirportData']['airport_name'] = $airportName ? $airportName : $segment['arrivalAirportData']['airport_name'];
                                }
                            }

                            if (isset($segment['arrivalAirportData']['city_name'])) {
                                $cityId = CityI18n::where('city_name', $segment['arrivalAirportData']['city_name'])->value('city_id');
                                if ($cityId) {
                                    $cityName = CityI18n::where('city_id', $cityId)->where('language_code', $translatelang)?->value('city_name');
                                    $segment['arrivalAirportData']['city_name'] = $cityName ? $cityName : $segment['arrivalAirportData']['city_name'];
                                }
                            }
                            if (isset($segment['arrivalAirportData']['country_name'])) {
                                $countryId = CountryI18ns::where('country_name', $segment['arrivalAirportData']['country_name'])->value('country_id');
                                if ($countryId) {
                                    $countryName = CountryI18ns::where('country_id', $countryId)->where('language_code', $translatelang)?->value('country_name');
                                    $segment['arrivalAirportData']['country_name'] = $countryName ? $countryName : $segment['arrivalAirportData']['country_name'];
                                }
                            }
                        }

                        // Departure Airport Data
                        if (isset($segment['departureAirportData'])) {
                            if (isset($segment['departureAirportData']['airport_name'])) {
                                $airportId = AirportI18ns::where('airport_name', $segment['departureAirportData']['airport_name'])->value('airport_id');
                                if ($airportId) {
                                    $airportName = AirportI18ns::where('airport_id', $airportId)->where('language_code', $translatelang)?->value('airport_name');
                                    $segment['departureAirportData']['airport_name'] = $airportName ? $airportName : $segment['departureAirportData']['airport_name'];
                                }
                            }

                            if (isset($segment['departureAirportData']['city_name'])) {
                                $cityId = CityI18n::where('city_name', $segment['departureAirportData']['city_name'])->value('city_id');
                                if ($cityId) {
                                    $cityName = CityI18n::where('city_id', $cityId)->where('language_code', $translatelang)?->value('city_name');
                                    $segment['departureAirportData']['city_name'] = $cityName ? $cityName : $segment['departureAirportData']['city_name'];
                                }
                            }
                            if (isset($segment['departureAirportData']['country_name'])) {
                                $countryId = CountryI18ns::where('country_name', $segment['departureAirportData']['country_name'])->value('country_id');
                                if ($countryId) {
                                    $countryName = CountryI18ns::where('country_id', $countryId)->where('language_code', $translatelang)?->value('country_name');
                                    $segment['departureAirportData']['country_name'] = $countryName ? $countryName : $segment['departureAirportData']['country_name'];
                                }
                            }
                        }
                    }
                }
            }
            unset($flight);
        }
        unset($airline);
        $bookingDetails['booking_details']['booking_details']['flightDetails']['airlines'] = $airlines;
        $flightInfoDetails =  $bookingDetails['booking_details']['booking_details']['flightDetails']['flightInfo'];
        foreach ($flightInfoDetails as &$flightInfo) {
            foreach ($flightInfo['itineraries'] as &$itinerary) {
                foreach ($itinerary as &$segments) {
                    if (!is_array($segments)) {
                        continue;
                    }
                    foreach ($segments as &$seg) {
                        // Airline
                        if (isset($seg['airlineData']['name'])) {
                            $airlineId = AirlineI18ns::where('airline_name', $seg['airlineData']['name'])->value('airline_id');
                            if ($airlineId) {
                                $airlineName = AirlineI18ns::where('airline_id', $airlineId)->where('language_code', $translatelang)?->value('airline_name');
                                $seg['airlineData']['name'] = $airlineName ? $airlineName : $seg['airlineData']['name'];
                            }
                        }

                        // Arrival Airport Data
                        if (isset($seg['arrivalAirportData'])) {
                            if (isset($seg['arrivalAirportData']['airport_name'])) {
                                $airportId = AirportI18ns::where('airport_name', $seg['arrivalAirportData']['airport_name'])->value('airport_id');
                                if ($airportId) {
                                    $airportName = AirportI18ns::where('airport_id', $airportId)->where('language_code', $translatelang)?->value('airport_name');
                                    $seg['arrivalAirportData']['airport_name'] = $airportName ? $airportName : $seg['arrivalAirportData']['airport_name'];
                                }
                            }

                            if (isset($seg['arrivalAirportData']['city_name'])) {
                                $cityId = CityI18n::where('city_name', $seg['arrivalAirportData']['city_name'])->value('city_id');
                                if ($cityId) {
                                    $cityName = CityI18n::where('city_id', $cityId)->where('language_code', $translatelang)?->value('city_name');
                                    $seg['arrivalAirportData']['city_name'] = $cityName ? $cityName : $seg['arrivalAirportData']['city_name'];
                                }
                            }
                            if (isset($seg['arrivalAirportData']['country_name'])) {
                                $countryId = CountryI18ns::where('country_name', $seg['arrivalAirportData']['country_name'])->value('country_id');
                                if ($countryId) {
                                    $countryName = CountryI18ns::where('country_id', $countryId)->where('language_code', $translatelang)?->value('country_name');
                                    $seg['arrivalAirportData']['country_name'] = $countryName ? $countryName : $seg['arrivalAirportData']['country_name'];
                                }
                            }
                        }

                        // Departure Airport Data
                        if (isset($seg['departureAirportData'])) {
                            if (isset($seg['departureAirportData']['airport_name'])) {
                                $airportId = AirportI18ns::where('airport_name', $seg['departureAirportData']['airport_name'])->value('airport_id');
                                if ($airportId) {
                                    $airportName = AirportI18ns::where('airport_id', $airportId)->where('language_code', $translatelang)?->value('airport_name');
                                    $seg['departureAirportData']['airport_name'] = $airportName ? $airportName : $seg['departureAirportData']['airport_name'];
                                }
                            }

                            if (isset($seg['departureAirportData']['city_name'])) {
                                $cityId = CityI18n::where('city_name', $seg['departureAirportData']['city_name'])->value('city_id');
                                if ($cityId) {
                                    $cityName = CityI18n::where('city_id', $cityId)->where('language_code', $translatelang)?->value('city_name');
                                    $seg['departureAirportData']['city_name'] = $cityName ? $cityName : $seg['departureAirportData']['city_name'];
                                }
                            }
                            if (isset($seg['departureAirportData']['country_name'])) {
                                $countryId = CountryI18ns::where('country_name', $seg['departureAirportData']['country_name'])->value('country_id');
                                if ($countryId) {
                                    $countryName = CountryI18ns::where('country_id', $countryId)->where('language_code', $translatelang)?->value('country_name');
                                    $seg['departureAirportData']['country_name'] = $countryName ? $countryName : $seg['departureAirportData']['country_name'];
                                }
                            }
                        }
                    }
                    unset($seg);
                }
                unset($segments);
            }
            unset($itinerary);
        }
        unset($flightInfo);
        $bookingDetails['booking_details']['booking_details']['flightDetails']['flightInfo'] =  $flightInfoDetails;
        $bookingDetails = $bookingDetails;
        return $bookingDetails;
    }
}
