<?php

namespace App\Traits;

use App\Enums\Currency;
use App\Models\Markups;
use App\Models\BrandName;
use App\Models\DefaultMarkup;
use App\Models\MarkupSetting;
use App\Traits\LoyaltyPointsService;
use PhpParser\Node\Scalar\Float_;

trait HotelListMarkup
{
    use LoyaltyPointsService;

    public function getHotelListMarkup($result, $requestData)
    {
        // $requestData['searchFrom'] = 'b2c_desktop';
        $brand_names = BrandName::pluck('chain_name', 'chain_code');

        if (!empty($result['data']['HotelsResultFilter']['HotelChain'])) {
            foreach ($result['data']['HotelsResultFilter']['HotelChain'] as &$chain) {
                $code = $chain['Value'];
                $chain['name'] = $brand_names[$code] ?? null;
            }
        }
        $convertedLoyaltyPoints = 0;
        $markupDetails = [];
        $markupSetting = MarkupSetting::first();
        if ($markupSetting && $markupSetting->apply_markup_hotel_list == 1) {

            $markups = Markups::with('getChannel')->where('service_type_id', 2)->get()->toArray();
            $defaultMarkups = DefaultMarkup::where('service_type_id', 2)->get()->toArray();
            $bookingDate = date('Y-m-d');

            $markupDetails = [];


            if (!empty($markups) && isset($requestData['stay']['checkIn'], $requestData['stay']['checkOut'])) {
                foreach ($markups as $markup) {

                    $hasMatchingChannel = false;
                    if (!empty($markup['get_channel'])) {
                        foreach ($markup['get_channel'] as $channel) {
                            if ($channel['channel'] == $requestData['searchFrom']) {
                                $hasMatchingChannel = true;
                                break;
                            }
                        }
                    }

                    if (
                        $hasMatchingChannel &&
                        ($requestData['stay']['checkIn'] >= $markup['from_travel_date'] && $requestData['stay']['checkOut'] <= $markup['to_travel_date']) &&
                        ($bookingDate >= $markup['from_booking_date'] && $bookingDate <= $markup['to_booking_date'])
                    ) {
                        $markupDetails[] = [
                            'type' => $markup['b2c_markup_type'],
                            'from_amount' => (float) $markup['from_price_range'],
                            'to_amount' => (float) $markup['to_price_range'],
                            'b2c_amount' => (float) $markup['b2c_markup'],
                        ];
                    }
                }
            }



            if (!empty($result['data']['Hotels'])) {
                foreach ($result['data']['Hotels'] as &$hotel) {
                    $price = (float) $hotel['Price'];
                    $markupApplied = false;
                    $highestMarkupAmount = 0;

                    foreach ($markupDetails as $markup) {
                        if (
                            $markup['from_amount'] == 0 && $markup['to_amount'] == 0 ||
                            ($price >= $markup['from_amount'] && $price <= $markup['to_amount'])
                        ) {

                            $currentMarkupAmount = ($markup['type'] === 'percentage')
                                ? ($price * $markup['b2c_amount']) / 100
                                : $markup['b2c_amount'];

                            if ($currentMarkupAmount > $highestMarkupAmount) {
                                $highestMarkupAmount = $currentMarkupAmount;
                                $markupApplied = true;
                            }
                        }
                    }


                    if ($markupApplied) {
                        $hotel['Price'] = round((float)$price + (float)$highestMarkupAmount, 2);
                        // $hotel['beforeLoyaltyPoints'] = (float) $hotel['Points'] ?? '0.00';
                        $hotel['Points'] = round((float)$price + (float) $highestMarkupAmount, 2);
                        $convertedLoyaltyPoints = $requestData['currency'] == Currency::USD->value ? getConvertedCurrencyValue($hotel['Points'], Currency::USD->value, Currency::SAR->value) : getConvertedCurrencyValue($hotel['Points'], Currency::SAR->value, Currency::SAR->value);
                        $hotel['Points'] = $convertedLoyaltyPoints['data'] ?? '';
                        // $hotel['defaultMarkup'] = 'no';
                        // $hotel['beforePrice'] = (float) $price;
                    } else {

                        foreach ($defaultMarkups as $defaultMarkup) {
                            $defaultMarkupAmount = ($defaultMarkup['b2c_markup_type'] === 'percentage')
                                ? ($price * $defaultMarkup['b2c_markup']) / 100
                                : $defaultMarkup['b2c_markup'];

                            $hotel['Price'] = round((float) $price + (float) $defaultMarkupAmount, 2);
                            // $hotel['beforeLoyaltyPoints'] = $hotel['Points'] ?? '0.00';
                            $hotel['Points'] = round((float) $price + (float) $defaultMarkupAmount, 2);
                            $convertedLoyaltyPoints = $requestData['currency'] == Currency::USD->value ? getConvertedCurrencyValue($hotel['Points'], Currency::USD->value, Currency::SAR->value) : getConvertedCurrencyValue($hotel['Points'], Currency::SAR->value, Currency::SAR->value);
                            $hotel['Points'] = $convertedLoyaltyPoints['data'] ?? '';
                            // $hotel['defaultMarkup'] = 'yes';
                            // $hotel['beforePrice'] = (float) $price;
                            break;
                        }
                    }

                    // $loyaltyPointsPayload = [
                    //     'service' => 'Hotel Booking',
                    //     'amount' => $hotel['Price'],
                    //     'fromCurrency' => Currency::SAR->value,
                    //     'toCurrency' => $requestData['currencyCode']
                    // ];
                    // $hotel['Points'] = $this->getLoyaltyPoints($loyaltyPointsPayload);

                }
            }
        }

        return $result;
    }

    public function getHotelListMarkupById($result, $requestData)
    {
        // $requestData['searchFrom'] = 'b2c_desktop';
        $markups = Markups::with('getChannel')->where('service_type_id', 2)->get()->toArray();
        $bookingDate = date('Y-m-d');
        $markupDetails = [];
        $convertedLoyaltyPoints = 0;
        // Check if specific markups apply
        if (!empty($markups) && isset($requestData['stay']['checkIn'], $requestData['stay']['checkOut'])) {
            foreach ($markups as $markup) {
                // Check if searchFrom matches any of the associated channels
                $hasMatchingChannel = false;
                if (!empty($markup['get_channel'])) {
                    foreach ($markup['get_channel'] as $channel) {
                        if ($channel['channel'] == $requestData['searchFrom']) {
                            $hasMatchingChannel = true;
                            break;
                        }
                    }
                }

                // Only apply markup if channel matches and dates are within range
                if (
                    $hasMatchingChannel &&
                    ($requestData['stay']['checkIn'] >= $markup['from_travel_date'] &&
                        $requestData['stay']['checkOut'] <= $markup['to_travel_date']) &&
                    ($bookingDate >= $markup['from_booking_date'] &&
                        $bookingDate <= $markup['to_booking_date'])
                ) {
                    $markupDetails[] = [
                        'type' => $markup['b2c_markup_type'],
                        'from_amount' => (float) $markup['from_price_range'],
                        'to_amount' => (float) $markup['to_price_range'],
                        'b2c_amount' => (float) $markup['b2c_markup'],
                    ];
                }
            }
        }


        // Fetch default markup
        $defaultMarkups = DefaultMarkup::where('service_type_id', 2)->get()->toArray();


        if (!empty($result['data']['Rooms'])) {
            foreach ($result['data']['Rooms'] as &$roomName) {
                foreach ($roomName as &$roomType) {
                    foreach ($roomType as &$ratePlan) {
                        foreach ($ratePlan as &$refundability) {
                            if (isset($refundability['SimplePrice'])) {
                                $price = (float) $refundability['SimplePrice'];
                                $markupApplied = false;
                                $highestMarkupAmount = 0;


                                foreach ($markupDetails as $markup) {
                                    if ($price >= $markup['from_amount'] && $price <= $markup['to_amount']) {
                                        $currentMarkupAmount = ($markup['type'] === 'percentage')
                                            ? ($price * $markup['b2c_amount']) / 100
                                            : $markup['b2c_amount'];

                                        if ($currentMarkupAmount > $highestMarkupAmount) {
                                            $highestMarkupAmount = $currentMarkupAmount;
                                            $markupApplied = true;
                                        }
                                    }
                                }


                                if ($markupApplied) {
                                    $refundability['SimplePrice'] = round((float) $price + (float) $highestMarkupAmount, 2);
                                    $refundability['beforePrice'] =  (float) $price;
                                    $refundability['beforeLoyaltyPoints'] = $refundability['LoyaltyPoints'] ?? '0.00';
                                    $refundability['LoyaltyPoints'] = round((float)$price + (float) $highestMarkupAmount, 2);
                                    $convertedLoyaltyPoints = $requestData['currency'] == Currency::USD->value ? getConvertedCurrencyValue($refundability['LoyaltyPoints'], Currency::USD->value, Currency::SAR->value) : getConvertedCurrencyValue($refundability['LoyaltyPoints'], Currency::SAR->value, Currency::SAR->value);
                                    $refundability['LoyaltyPoints'] = $convertedLoyaltyPoints['data'] ?? '';
                                    $refundability['defaultMarkup'] = 'no';
                                } else {

                                    foreach ($defaultMarkups as $defaultMarkup) {
                                        $defaultMarkupAmount = ($defaultMarkup['b2c_markup_type'] === 'percentage')
                                            ? ($price * $defaultMarkup['b2c_markup']) / 100
                                            : $defaultMarkup['b2c_markup'];

                                        $refundability['SimplePrice'] = round((float)$price + (float) $defaultMarkupAmount, 2);
                                        $refundability['beforePrice'] = (float) $price;
                                        $refundability['beforeLoyaltyPoints'] = (float) $refundability['LoyaltyPoints'] ?? '0.00';
                                        $refundability['LoyaltyPoints'] = round((float)$price + (float) $defaultMarkupAmount, 2);
                                        $convertedLoyaltyPoints = $requestData['currency'] == Currency::USD->value ? getConvertedCurrencyValue($refundability['LoyaltyPoints'], Currency::USD->value, Currency::SAR->value) : getConvertedCurrencyValue($refundability['LoyaltyPoints'], Currency::SAR->value, Currency::SAR->value);
                                        $refundability['LoyaltyPoints'] = $convertedLoyaltyPoints['data']?? '';
                                        $refundability['defaultMarkup'] = 'yes';
                                        break;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

        return $result;
    }
}
