<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */


namespace App\Traits;

use App\Enums\Currency;
use Config;
use Carbon\Carbon;
use App\Models\Setting;
use App\Models\Bookings;
use Illuminate\Support\Str;
use App\Models\LoyaltyPointsMap;
use App\Models\LoyaltyPointSetting;
use App\Models\LoyaltyPointToRiyal;
use App\Models\CurrencyExchangeRates;
use App\Models\CustomerLoyaltyPoints;
use App\Models\BookingAdditionalDetail;

trait LoyaltyPointsService
{

    public function getLoyaltyPointToRiyalList()
    {
        return LoyaltyPointToRiyal::getLoyaltyPointToRiyalList();
    }

    public function getLoyaltyPointToRiyal($service)
    {
        return LoyaltyPointToRiyal::getLoyaltyPointToRiyal($service);
    }

    public function getLoyaltyPointsMapList()
    {
        return LoyaltyPointsMap::getLoyaltyPointsMapList();
    }

    function getCommonDetails($service, $isCommon)
    {
        $commonDetails = LoyaltyPointsMap::searchLoyaltyPointsMap([
            [
                'field' => 'service',
                'condition' => '=',
                'value' => $service,
            ],
            [
                'field' => 'is_common',
                'condition' => '=',
                'value' => $isCommon,
            ]
        ]);
        return $commonDetails;
    }

    function getCityDetails($service, $city)
    {
        $cityDetails = LoyaltyPointsMap::searchLoyaltyPointsMap([
            [
                'field' => 'service',
                'condition' => '=',
                'value' => $service,
            ],
            [
                'field' => 'city',
                'condition' => '=',
                'value' => $city,
            ]
        ]);
        return $cityDetails;
    }

    function getServiceProviderDetails($service, $serviceProvider)
    {
        $serviceProviderDetails = LoyaltyPointsMap::searchLoyaltyPointsMap([
            [
                'field' => 'service_provider',
                'condition' => '=',
                'value' => $service,
            ],
            [
                'field' => 'city',
                'condition' => '=',
                'value' => $serviceProvider,
            ]
        ]);
        return $serviceProviderDetails;
    }

    function getFromToDetails($service, $fromPlace, $toPlace)
    {
        $fromToDetails = LoyaltyPointsMap::searchLoyaltyPointsMap([
            [
                'field' => 'service_provider',
                'condition' => '=',
                'value' => $service,
            ],
            [
                'field' => 'from_place',
                'condition' => '=',
                'value' => $fromPlace,
            ],
            [
                'field' => 'to_place',
                'condition' => '=',
                'value' => $toPlace,
            ]
        ]);
        return $fromToDetails;
    }

    function getLoyaltyPointCalculatedAmount($searchDetails)
    {
        $criteria = [
            'calculation_type' => 'fixed',
            'value' => 0
        ];

        $service = $searchDetails['service'];
        $serviceProvider = isset($searchDetails['service_provider']) ? $searchDetails['service_provider'] : '';
        $fromPlace = isset($searchDetails['from_place']) ? $searchDetails['from_place'] : '';
        $toPlace = isset($searchDetails['to_place']) ? $searchDetails['to_place'] : '';
        $serviceStartDate = isset($searchDetails['start_date']) ? $searchDetails['start_date'] : '';
        $serviceEndDate = isset($searchDetails['end_date']) ? $searchDetails['end_date'] : '';
        $isCommon = isset($searchDetails['is_common']) ? $searchDetails['is_common'] : '1';
        $city = isset($searchDetails['city']) ? $searchDetails['city'] : '';

        $criteria = [];
        $criteria['fromTo'] = $this->getFromToDetails($service, $fromPlace, $toPlace);
        $criteria['serviceProvider'] = $this->getServiceProviderDetails($service, $serviceProvider);
        $criteria['city'] = $this->getCityDetails($service, $city);
        $criteria['common'] = $this->getCommonDetails($service, $isCommon);

        if (is_array($criteria['fromTo']) && isset($criteria['fromTo']['value'])) {
            $criteria['calculation_type'] = $criteria['fromTo']['calculation_type'];
            $criteria['value'] = $criteria['fromTo']['value'];
        } else if (is_array($criteria['serviceProvider']) && isset($criteria['serviceProvider']['value'])) {
            $criteria['calculation_type'] = $criteria['serviceProvider']['calculation_type'];
            $criteria['value'] = $criteria['serviceProvider']['value'];
        } else if (is_array($criteria['city']) && isset($criteria['city']['value'])) {
            $criteria['calculation_type'] = $criteria['city']['calculation_type'];
            $criteria['value'] = $criteria['city']['value'];
        } else if (is_array($criteria['common']) && isset($criteria['common']['value'])) {
            $criteria['calculation_type'] = $criteria['common']['calculation_type'];
            $criteria['value'] = $criteria['common']['value'];
        }

        $calculatedAmount = 0;
        if ($criteria['calculation_type'] == 'fixed') {
            $calculatedAmount = $criteria['value'];
        } else if ($criteria['calculation_type'] == 'percentage') {
            $calculatedAmount = $searchDetails['amount'] * $criteria['value'] / 100;
        }
        return $calculatedAmount;
    }

    public function getLoyaltyPoints($searchDetails)
    {
        $calculatedAmount = $searchDetails['amount'];
        // $calculatedAmount = $this->getLoyaltyPointCalculatedAmount($searchDetails);
        
        $convertedAmountResponse =$searchDetails['toCurrency'] == Currency::SAR->value ? getConvertedCurrencyValue($calculatedAmount, $searchDetails['toCurrency'], Currency::SAR->value) : getConvertedCurrencyValue($calculatedAmount, Currency::SAR->value, Currency::SAR->value);
        // if ($convertedAmountResponse['status'] == 1) {
        //     $loyaltyPointPerRiyal = $this->getLoyaltyPointToRiyal($searchDetails['service']);
        //     $loyaltyPoints = number_format(($convertedAmountResponse['data'] * $loyaltyPointPerRiyal), 2, '.', '');
        //     //echo "<pre>Calculated:".$calculatedAmount.',Points:'.$loyaltyPoints; print_r($searchDetails); print_r($convertedAmountResponse); print_r($loyaltyPointPerRiyal); die;
        // } else {
        //     $loyaltyPoints = 0;
        // }
        return $convertedAmountResponse['data'];
    }

    public function getCustomerMaxRedeemPoints($customerId, $bookingType, $currency)
    {
        $result = [
            'availablePoints' => 0,
            'availableRedeemAmount' => 0,
            'maxRedeemPoints' => 0,
            'maxRedeemPrice' => 0,
        ];
        // $customerTotalLoyaltyPoints = CustomerLoyaltyPoints::getCustomerTotalLoyaltyPoints($customerId);
        $customerTotalLoyaltyPoints =  CustomerLoyaltyPoints::getTotalRewardPoints($customerId);;
        // return $customerTotalLoyaltyPoints;
        if ($customerTotalLoyaltyPoints) {
            $rewardPoints = $customerTotalLoyaltyPoints;
            $service = ($bookingType == 'Flight') ? 'Airline Ticket' : 'Hotel Booking';
            // $redeemPointToRiyal = $this->getLoyaltyPointToRiyal($service);
            $loyaltyPointSetting = LoyaltyPointSetting::first();
            $redeemPointToRiyal = $loyaltyPointSetting->point_to_amount ?? 200;

            $maxRedeemPointsFixedAmount = Setting::where('config_key', 'general|site|maxRedeemPointsFixedAmount')->get('value')[0]['value'];

            $availablePoints = $rewardPoints ?? 0;
            $availablePointsToRiyal = number_format(($availablePoints / $redeemPointToRiyal), 2, '.', '');
            if ($availablePointsToRiyal > $maxRedeemPointsFixedAmount) {
                $maxRedeemPrice = $maxRedeemPointsFixedAmount;
            } else {
                $maxRedeemPrice = $availablePointsToRiyal;
            }
            if ($currency != Currency::SAR->value) {
                $currencyConversionRate = CurrencyExchangeRates::where('from_currency_code', Currency::SAR->value)->where('to_currency_code', $currency)->get('exchange_rate')[0]['exchange_rate'];
                $maxRedeemPrice = number_format(($maxRedeemPrice * $currencyConversionRate), 2, '.', '');
            }
            $result = [
                'availablePoints' => $availablePoints,
                'availableRedeemAmount' => (float) $availablePoints/ $redeemPointToRiyal,
                'maxRedeemPoints' => number_format(($maxRedeemPrice * $redeemPointToRiyal), 0),
                'maxRedeemPrice' => $maxRedeemPrice,
                // 'rewardpoints' =>$customerTotalLoyaltyPoints['data']['rewardPoints'] 
            ];
        }
        return $result;
    }

    public function getCustomerPointsWithAmount($customerId, $currency = Currency::SAR->value)
    {
        $pointsResponse = CustomerLoyaltyPoints::getCustomerLoyaltyPointsByType($customerId);
        if ($pointsResponse['status'] == 'true') {
            $loyaltyPointToRiyalListResponse = $this->getLoyaltyPointToRiyalList();
            if ($loyaltyPointToRiyalListResponse['status'] == 1 && count($loyaltyPointToRiyalListResponse['data']) > 0) {
                $result = [
                    'pointsBalance' => 0,
                    'pointsAmount' => 0
                ];

                foreach ($loyaltyPointToRiyalListResponse['data'] as $key => $loyaltyPointToRiyal) {
                    if ($loyaltyPointToRiyal['service'] == 'Airline Ticket') {
                        $pointsResponse['data']['flight']['pointsPerRiyal'] = $loyaltyPointToRiyal['points'];
                    } elseif ($loyaltyPointToRiyal['service'] == 'Hotel Booking') {
                        $pointsResponse['data']['hotel']['pointsPerRiyal'] = $loyaltyPointToRiyal['points'];
                    }
                }
                $flightPrice = $hotelPrice = 0;
                if ($pointsResponse['data']['flight']['pointsPerRiyal'] > 0) {
                    $flightPrice = $pointsResponse['data']['flight']['availablePoints'] / $pointsResponse['data']['flight']['pointsPerRiyal'];
                    if ($currency != Currency::SAR->value) {
                        $convertedTotalPrice = convertCurrencyExchangeRate($flightPrice, Currency::SAR->value, $currency);
                        $flightPrice = (int)$convertedTotalPrice['data']['formattedPrice'];
                    }
                }
                if ($pointsResponse['data']['hotel']['pointsPerRiyal'] > 0) {
                    $hotelPrice = $pointsResponse['data']['hotel']['availablePoints'] / $pointsResponse['data']['hotel']['pointsPerRiyal'];
                    if ($currency != Currency::SAR->value) {
                        $convertedTotalPrice = convertCurrencyExchangeRate($hotelPrice, Currency::SAR->value, $currency);
                        $hotelPrice = (int)$convertedTotalPrice['data']['formattedPrice'];
                    }
                }
                // $result['pointsBalance'] = ($pointsResponse['data']['flight']['availablePoints'] + $pointsResponse['data']['hotel']['availablePoints']);
                $flightPoints = isset($pointsResponse['data']['flight']['availablePoints']) ? (int)$pointsResponse['data']['flight']['availablePoints'] : 0;
                $hotelPoints = isset($pointsResponse['data']['hotel']['availablePoints']) ? (int)$pointsResponse['data']['hotel']['availablePoints'] : 0;
                $result['pointsBalance'] = $flightPoints + $hotelPoints;
                $result['pointsAmount'] = number_format(($flightPrice + $hotelPrice), 2, '.', '');

                $pointsResponse['data'] = $result;
            }
        }
        return $pointsResponse;
    }

    // Calculte Service End Dates for Loyalty points 
    public static function getServiceEndDate($bookingIds)
    {
        $bookings = Bookings::whereIn('id', $bookingIds)
            ->where('booking_status', 'confirmed')
            ->select('id', 'booking_type', 'booking_details')
            ->get();

        $bookingIdsConfirmed = $bookings->pluck('id');

        // Get hotel booking additional details
        $hotelBookings = BookingAdditionalDetail::whereIn('booking_id', $bookingIdsConfirmed)
            ->whereNotNull('booking_details')
            ->get();

        // Get flight bookings
        $flightBookings = $bookings->where('booking_type', 'Flight');

        $serviceEndDetails = [];
        $now = Carbon::now();

        // Get expiry duration settings
        $loyaltyPointSetting = LoyaltyPointSetting::first();

        if ($loyaltyPointSetting) {
            $expiry_year = $loyaltyPointSetting->expiry_year ?? 0;
            $expiry_month = $loyaltyPointSetting->expiry_month ?? 0;
            $expiry_day = $loyaltyPointSetting->expiry_day ?? 0;
        } else {
            $expiry_year = 1;
            $expiry_month = 0;
            $expiry_day = 0;
        }
        
        // Process flight bookings
        foreach ($flightBookings as $flightBooking) {
            $bookingDetails = json_decode($flightBooking->booking_details, true);
            
            $segments = $bookingDetails['booking_details']['flightDetails']['flightInfo'][0]['itineraries'][0]['segments'] ?? [];
         
            if (!empty($segments)) {
                $arrivalAt = $segments[array_key_last($segments)]['arrival']['at'] ?? null;

                if ($arrivalAt) {
                    $arrivalDate = Carbon::parse($arrivalAt);
                    $expiryFromArrival = $arrivalDate->copy()->addYears($expiry_year)->addMonths($expiry_month)->addDays($expiry_day);

                    if ($now->between($arrivalDate, $expiryFromArrival)) {
                        $serviceEndDetails[] = [
                            'booking_id' => $flightBooking->id,
                            'booking_type' => 'Flight',
                            'service_end_date' => $arrivalDate->toDateString()
                        ];

                        // if (CustomerLoyaltyPoints::where('booking_id', $flightBooking->id)->exists()) {
                        //     CustomerLoyaltyPoints::where('booking_id', $flightBooking->id)
                        //         ->update(['service_end_date' => $arrivalDate->toDateString()]);
                        // }
                        
                    }


                }
            }
        }

        // Process hotel bookings
        foreach ($hotelBookings as $hotelBooking) {
            $details = json_decode($hotelBooking->booking_details, true);

            if (isset($details['searchDetails']['stay']['checkOut'])) {
                $checkOut = $details['searchDetails']['stay']['checkOut'];
                $arrivalDate = Carbon::parse($checkOut);
                $expiryFromArrival = $arrivalDate->copy()->addYears($expiry_year)->addMonths($expiry_month)->addDays($expiry_day);

                if ($now->between($arrivalDate, $expiryFromArrival)) {
                    $serviceEndDetails[] = [
                        'booking_id' => $hotelBooking->booking_id,
                        'booking_type' => 'Hotel',
                        'service_end_date' => $arrivalDate->toDateString()
                    ];
                    // if (CustomerLoyaltyPoints::where('booking_id', $hotelBooking->booking_id)->exists()) {
                    //     CustomerLoyaltyPoints::where('booking_id', $hotelBooking->booking_id)
                    //         ->update(['service_end_date' => $arrivalDate->toDateString()]);
                    // }
                }
            }
        }

        return $serviceEndDetails;
    }
}
