<?php
namespace App\Traits;

trait UrlFetcher {
    use CommonService;
    /**
     * Fetch JSON data from a URL and return structured response
     *
     * @param string $url
     * @return array
     */
    public function fetchUrlData(string $url): array {
        try {
            // Initialize cURL session
            // $curl = curl_init();

            // // Set cURL options
            // curl_setopt_array($curl, [
            //     CURLOPT_URL => $url,
            //     CURLOPT_RETURNTRANSFER => true,
            //     CURLOPT_FOLLOWLOCATION => true,
            //     CURLOPT_SSL_VERIFYPEER => true,
            //     CURLOPT_TIMEOUT => 30,
            //     CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            //     CURLOPT_REFERER => 'https://demo.rehlte.com',
            //     CURLOPT_CUSTOMREQUEST => 'GET',
            //     CURLOPT_HTTPHEADER => [
            //         'Accept: application/json',
            //         'Content-Type: application/json'
            //     ],
            // ]);

            // // Execute cURL request
            // $response = curl_exec($curl);
            // $error = curl_error($curl);
            // $statusCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);

            // // Close cURL session
            // curl_close($curl);
            $header = [
                'Accept: application/json',
                'Content-Type: application/json'
            ];
            $result = $this->libCurl($url, 'GET', $header);
            $response = $result['data'];
            $error = !$result['status'];
            $statusCode = $result['http_code'];
            // Handle cURL error
            if ($error) {
                return [
                    'status' => false,
                    'message' => "cURL Error: " . $error,
                    'data' => null
                ];
            }

            // Handle HTTP error
            if ($statusCode !== 200) {
                return [
                    'status' => false,
                    'message' => "HTTP Error: Status code " . $statusCode,
                    'data' => null
                ];
            }

            // Decode JSON response
            // $decodedData = json_decode($response, true);

            // Handle JSON decode error
            if (json_last_error() !== JSON_ERROR_NONE) {
                return [
                    'status' => false,
                    'message' => "JSON Decode Error: " . json_last_error_msg(),
                    'data' => null
                ];
            }

            // Return successful response
            return [
                'status' => true,
                'message' => 'Success',
                'data' => $response
            ];

        } catch (\Exception $e) {
            return [
                'status' => false,
                'message' => "Unexpected Error: " . $e->getMessage(),
                'data' => null
            ];
        }
    }
}
