<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddRelationToCountryI18nsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('country_i18ns', function (Blueprint $table) {
//            if (Schema::hasForeign($table, 'country_id')){
               $table->dropForeign(['country_id']);         
//            }
            
            $table->foreign('country_id')
              ->references('id')
              ->on('countries')
              ->onDelete('cascade')
              ->onUpdate('cascade');

            $table->foreign('language_code')
              ->references('language_code')
              ->on('core_languages')
              ->onDelete('cascade')
              ->onUpdate('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('country_i18ns', function (Blueprint $table) {
            //
        });
    }
}
