<?php

use App\Models\User;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;
use App\Models\CustomerAddresses;

class AddDropForegnKeyInCustomerAddress extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('customer_addresses', function (Blueprint $table) {
            
            DB::statement('SET FOREIGN_KEY_CHECKS=0;');
            CustomerAddresses::truncate();
            DB::statement('SET FOREIGN_KEY_CHECKS=1;');

            $table->dropForeign(['state']);

            // Recreate foreign key constraints
            $table->foreign('state')
                ->references('id')
                ->on('states')
                ->onDelete('cascade')
                ->onUpdate('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('customer_addresses', function (Blueprint $table) {
            //
        });
    }
}
