<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('airline_i18ns', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->char('airline_id', 36)->index('airline_i18ns_airline_id_foreign');
            $table->string('airline_name');
            $table->string('language_code')->index('airline_i18ns_language_code_foreign');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('airline_i18ns');
    }
};
