<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('airport_i18ns', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->char('airport_id', 36)->index('airport_i18ns_airport_id_foreign');
            $table->string('airport_name');
            $table->string('language_code')->index('airport_i18ns_language_code_foreign');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('airport_i18ns');
    }
};
