<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('api_list', function (Blueprint $table) {
            $table->char('id', 36)->primary();
            $table->string('api_category');
            $table->string('api_title');
            $table->string('api_url');
            $table->string('api_method');
            $table->enum('is_header_auth', ['yes', 'no']);
            $table->text('request_payload')->nullable();
            $table->text('success_response');
            $table->text('error_response')->nullable();
            $table->longText('description')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('api_list');
    }
};
