<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('booking_checkout', function (Blueprint $table) {
            $table->char('id', 36)->primary();
            $table->string('ref_id')->index('ref_id');
            $table->string('log_id')->nullable();
            $table->char('customer_id', 36)->nullable();
            $table->string('payment_id')->nullable();
            $table->string('merchant_transaction_id')->nullable();
            $table->string('checkout_url')->nullable();
            $table->float('loyalty_points', 10)->nullable();
            $table->char('booking_id', 36)->nullable();
            $table->string('booking_via')->nullable()->default('web');
            $table->string('booking_ref_id')->nullable();
            $table->text('checkout_ids')->nullable();
            $table->decimal('initial_amount', 10);
            $table->decimal('amount', 10)->nullable();
            $table->string('booking_type');
            $table->string('service_provider')->nullable();
            $table->string('supplier_id', 100)->nullable();
            $table->string('supplier_name', 100)->nullable();
            $table->string('ama_client_ref')->nullable();
            $table->mediumText('booking_details');
            $table->tinyInteger('traacs_voucher_created')->default(0);
            $table->timestamp('created_at')->useCurrentOnUpdate()->useCurrent();
            $table->timestamp('updated_at')->default('0000-00-00 00:00:00');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('booking_checkout');
    }
};
