<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('booking_status_log', function (Blueprint $table) {
            $table->integer('id', true);
            $table->string('booking_id');
            $table->string('booking_status_from');
            $table->string('booking_status_to');
            $table->text('booking_status_description')->default('Nill');
            $table->string('refund_amount')->nullable();
            $table->text('modified_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('booking_status_log');
    }
};
