<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('cities', function (Blueprint $table) {
            $table->char('id', 36)->primary();
            $table->string('iso_code')->index('iso_code_index');
            $table->string('country_code')->index('cities_country_code_foreign');
            $table->string('latitude');
            $table->string('longitude');
            $table->string('airport_code')->nullable();
            $table->enum('status', ['active', 'inactive']);
            $table->integer('sorting')->default(0);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cities');
    }
};
