<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('coupons', function (Blueprint $table) {
            $table->char('id', 36)->primary();
            $table->string('customer_type')->nullable();
            $table->string('coupon_code')->nullable();
            $table->string('coupon_amount')->nullable();
            $table->string('description')->nullable();
            $table->string('discount_type')->nullable();
            $table->date('from_date')->nullable();
            $table->date('to_date')->nullable();
            $table->string('maximum_spend')->nullable();
            $table->string('minimum_spend')->nullable();
            $table->unsignedBigInteger('service_type_id')->nullable()->index('coupons_service_type_id_foreign')->comment('reference id key of core service types table');
            $table->string('limit_per_coupon')->nullable();
            $table->string('limit_per_customer')->nullable();
            $table->integer('redeem_count')->nullable()->default(0);
            $table->string('status')->nullable();
            $table->string('product')->nullable();
            $table->string('bank_name')->nullable();
            $table->string('bank_card_number')->nullable();
            $table->string('airline_name')->nullable();
            $table->string('airline_cabin_class')->nullable();
            $table->string('hotel_name')->nullable();
            $table->string('hotel_city')->nullable();
            $table->string('domestic_product')->nullable();
            $table->string('international_product')->nullable();
            $table->string('payment_method')->nullable();
            $table->integer('is_new')->nullable()->default(0);
            $table->string('coupon_type')->nullable();
            $table->date('expiry_date')->nullable();
            $table->string('thumbnail')->nullable();
            $table->string('banner')->nullable();
            $table->string('banner_title')->nullable();
            $table->string('arabic_banner_title')->nullable();
            $table->string('banner_sub_title')->nullable();
            $table->string('arabic_banner_sub_title')->nullable();
            $table->longText('terms_en')->nullable();
            $table->longText('terms_ar')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('coupons');
    }
};
