<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('curl_request_logs', function (Blueprint $table) {
            $table->char('id', 36)->primary();
            $table->string('method', 10);
            $table->text('url');
            $table->text('headers')->nullable();
            $table->longText('request')->nullable();
            $table->longText('response')->nullable();
            $table->integer('duration_ms')->nullable();
            $table->integer('timeout')->default(30);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('curl_request_logs');
    }
};
