<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('customer_addresses', function (Blueprint $table) {
            $table->char('id', 36)->primary();
            $table->char('customer_id', 36)->index('customer_addresses_customer_id_foreign')->comment('reference key of customer table id');
            $table->text('address1')->nullable()->comment('customer address 1');
            $table->text('address2')->nullable()->comment('customer address 2');
            $table->char('country', 36)->nullable()->index('customer_addresses_country_foreign')->comment('reference key of country table id');
            $table->string('state')->nullable()->index('customer_addresses_state_foreign')->comment('customer address state');
            $table->string('city')->nullable()->index('customer_addresses_city_foreign')->comment('customer address city');
            $table->string('pincode')->nullable()->comment('customer address pincode');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('customer_addresses');
    }
};
