<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('customer_loyalty_points', function (Blueprint $table) {
            $table->char('id', 36)->primary();
            $table->char('customer_id', 36)->index('customer_id');
            $table->char('booking_id', 36);
            $table->bigInteger('points_earned')->nullable();
            $table->bigInteger('points_redeemed')->nullable();
            $table->double('redeem_amount', 10, 2)->nullable();
            $table->string('service_end_date', 20)->nullable();
            $table->string('expiry_date', 50)->nullable();
            $table->string('used_status', 50)->default('not_used');
            $table->timestamp('created_at')->useCurrentOnUpdate()->useCurrent();
            $table->timestamp('updated_at')->default('0000-00-00 00:00:00');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('customer_loyalty_points');
    }
};
