<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('default_markups_suppliers', function (Blueprint $table) {
            $table->char('id', 36)->primary();
            $table->char('default_markups_id', 36)->nullable()->index('default_markups_suppliers_default_markups_id_foreign')->comment('reference id key of default_markups table');
            $table->unsignedBigInteger('supplier_id')->nullable()->index('default_markups_suppliers_supplier_id_foreign')->comment('reference id key of core supplier table');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('default_markups_suppliers');
    }
};
