<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('default_markups', function (Blueprint $table) {
            $table->char('id', 36)->primary();
            $table->unsignedBigInteger('service_type_id')->nullable()->index('default_markups_service_type_id_foreign')->comment('reference id key of core service types table');
            $table->enum('b2c_markup_type', ['percentage', 'fixed_amount'])->nullable();
            $table->decimal('b2c_markup', 10)->nullable();
            $table->enum('b2b_markup_type', ['percentage', 'fixed_amount'])->nullable();
            $table->decimal('b2b_markup', 10)->nullable();
            $table->string('service_calculation_method', 50)->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('default_markups');
    }
};
