<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('edit_flight_details', function (Blueprint $table) {
            $table->char('id', 36)->primary();
            $table->string('ref_id', 100)->nullable();
            $table->string('booking_id');
            $table->string('first_name')->nullable();
            $table->string('last_name')->nullable();
            $table->string('email')->nullable();
            $table->string('booking_date')->nullable();
            $table->string('booking_start_date')->nullable();
            $table->longText('customer_details')->nullable();
            $table->longText('flight_details')->nullable();
            $table->longText('complete_flight_details')->nullable();
            $table->longText('passenger_details')->nullable();
            $table->longText('processed_price')->nullable();
            $table->longText('billing_details')->nullable();
            $table->longText('booking_details')->nullable();
            $table->tinyInteger('status')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('edit_flight_details');
    }
};
