<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('fare_basis_logs', function (Blueprint $table) {
            $table->char('id', 36)->primary();
            $table->string('ref_id')->nullable();
            $table->longText('request')->nullable();
            $table->longText('original_response')->nullable();
            $table->longText('formatted_response')->nullable();
            $table->string('search_from', 50)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('fare_basis_logs');
    }
};
