<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('featured_guides', function (Blueprint $table) {
            $table->char('id', 36)->primary();
            $table->string('name');
            $table->string('url');
            $table->tinyInteger('status');
            $table->string('title');
            $table->string('arabic_title');
            $table->string('sub_title');
            $table->string('arabic_sub_title');
            $table->string('banner_title');
            $table->string('arabic_banner_title');
            $table->string('banner_sub_title');
            $table->string('arabic_banner_sub_title');
            $table->string('banner');
            $table->longText('content')->nullable();
            $table->longText('arabic_content')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('featured_guides');
    }
};
