<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('featured_hotels', function (Blueprint $table) {
            $table->char('id', 36)->primary();
            $table->string('hotel_name');
            $table->string('hotel_name_ar');
            $table->string('hotel_link');
            $table->string('location');
            $table->string('location_ar');
            $table->string('hotel_image');
            $table->decimal('price', 10);
            $table->float('rating', 10, 0);
            $table->tinyInteger('hot_deal');
            $table->tinyInteger('status')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('featured_hotels');
    }
};
