<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('hotel_address', function (Blueprint $table) {
            $table->integer('id', true);
            $table->string('hotelid')->index('idx_hotelid');
            $table->string('displayname');
            $table->string('countrycode')->nullable();
            $table->string('countryname')->nullable();
            $table->string('state')->nullable();
            $table->string('cityname')->nullable();
            $table->string('address')->nullable();
            $table->string('zipcode')->nullable();
            $table->integer('starrating')->nullable();
            $table->string('lat')->nullable();
            $table->string('lng')->nullable();
            $table->integer('roomcount')->nullable();
            $table->string('phone')->nullable();
            $table->string('fax')->nullable();
            $table->string('email')->nullable();
            $table->string('website')->nullable();
            $table->bigInteger('booking_count')->default(0);
            $table->string('creationtime')->nullable();
            $table->string('updatetime')->nullable();
            $table->string('propertycategory')->nullable();
            $table->string('propertysubcategory')->nullable();
            $table->string('chaincode')->nullable();
            $table->timestamp('created_at')->useCurrent();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('hotel_address');
    }
};
