<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('hotel_recommendations', function (Blueprint $table) {
            $table->char('id', 36);
            $table->bigIncrements('control_id');
            $table->string('recommendation_type');
            $table->longText('destination')->nullable();
            $table->longText('hotels')->nullable();
            $table->string('logic_rule')->nullable();
            $table->string('priority_level');
            $table->string('effective_date_from');
            $table->string('effective_date_to');
            $table->enum('status', ['active', 'inactive']);
            $table->longText('notes')->nullable();
            $table->string('created_by');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('hotel_recommendations');
    }
};
