<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('mail_template_i18ns', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->char('mail_id', 36)->index('mail_template_i18ns_mail_id_foreign');
            $table->string('name');
            $table->string('subject');
            $table->text('content');
            $table->string('language_code')->index('mail_template_i18ns_language_code_foreign');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('mail_template_i18ns');
    }
};
