<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('markups_supplier', function (Blueprint $table) {
            $table->char('id', 36)->primary();
            $table->char('markups_id', 36)->nullable()->index('markups_supplier_markups_id_foreign')->comment('reference id key of markups table');
            $table->unsignedBigInteger('supplier_id')->nullable()->index('markups_supplier_supplier_id_foreign')->comment('reference id key of core supplier table');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('markups_supplier');
    }
};
