<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('markups', function (Blueprint $table) {
            $table->char('id', 36)->primary();
            $table->string('rule_name')->nullable();
            $table->unsignedBigInteger('service_type_id')->nullable()->index('markups_service_type_id_foreign')->comment('reference id key of core service types table');
            $table->string('destination_name')->nullable();
            $table->string('destination_criteria')->nullable();
            $table->string('origin_name')->nullable();
            $table->string('origin_criteria')->nullable();
            $table->date('from_booking_date')->nullable();
            $table->date('to_booking_date')->nullable();
            $table->date('from_travel_date')->nullable();
            $table->date('to_travel_date')->nullable();
            $table->string('starCategory')->nullable();
            $table->string('booking_class')->nullable();
            $table->string('cabin_class')->nullable();
            $table->string('trip_type')->nullable();
            $table->string('pax_type')->nullable();
            $table->decimal('to_price_range', 10)->nullable();
            $table->decimal('from_price_range', 10)->nullable();
            $table->enum('fare_type', ['commission', 'net_fare'])->nullable();
            $table->string('service_calculation_method', 50)->nullable();
            $table->enum('b2c_markup_type', ['percentage', 'fixed_amount'])->nullable();
            $table->decimal('b2c_markup', 10)->nullable();
            $table->enum('b2b_markup_type', ['percentage', 'fixed_amount'])->nullable();
            $table->decimal('b2b_markup', 10)->nullable();
            $table->enum('service_b2c_markup_type', ['percentage', 'fixed_amount'])->nullable();
            $table->decimal('service_b2c_markup', 10)->nullable();
            $table->enum('service_b2b_markup_type', ['percentage', 'fixed_amount']);
            $table->decimal('service_b2b_markup', 10)->nullable();
            $table->enum('ancillary_service_markup_type', ['percentage', 'fixed_amount']);
            $table->decimal('ancillary_service_markup', 10);
            $table->integer('priority')->nullable();
            $table->timestamps();
            $table->softDeletes();
            $table->enum('comm_markup_on', ['base_fare', 'base_fare_yq', 'net_fare', 'total_fare'])->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('markups');
    }
};
