<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('modules', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('group_code')->comment('group code');
            $table->string('group_name')->comment('group name');
            $table->string('module_code')->unique()->comment('module code');
            $table->string('module_name')->unique()->comment('module name');
            $table->tinyInteger('is_managerapp')->default(0)->comment('is the module is for manager app or not. If is for manager app than set as 1 else set as 0');
            $table->tinyInteger('is_b2bapp')->default(0)->comment('is the module is for b2b app or not. If is for b2b app than set as 1 else set as 0');
            $table->tinyInteger('is_supplierapp')->default(0)->comment('is the module is for supplier app or not. If is for supplier app than set as 1 else set as 0');
            $table->integer('sort_order')->default(0)->comment('module sorting order');
            $table->integer('b2b_sort_order')->default(0);
            $table->integer('supplier_sort_order')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('modules');
    }
};
