<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('most_booked_hotels', function (Blueprint $table) {
            $table->char('id', 36)->primary();
            $table->string('hotel_id', 50)->index();
            $table->longText('booking_ids')->nullable();
            $table->string('hotel_name')->nullable();
            $table->string('city_name')->nullable();
            $table->bigInteger('booked_count')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('most_booked_hotels');
    }
};
