<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('page_i18ns', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->char('page_id', 36)->index('page_i18ns_page_id_foreign');
            $table->string('page_title');
            $table->text('page_content');
            $table->string('meta_title');
            $table->string('meta_description');
            $table->string('keywords');
            $table->string('language_code')->index('page_i18ns_language_code_foreign');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('page_i18ns');
    }
};
