<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('payment_checkout_id_log', function (Blueprint $table) {
            $table->char('id', 36)->primary();
            $table->string('ref_id');
            $table->char('booking_id', 36)->nullable();
            $table->string('checkout_id');
            $table->string('payment_brand');
            $table->decimal('amount', 10);
            $table->text('request');
            $table->text('response');
            $table->timestamp('created_at')->useCurrentOnUpdate()->useCurrent();
            $table->timestamp('updated_at')->default('0000-00-00 00:00:00');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('payment_checkout_id_log');
    }
};
